/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity;

import com.blakebr0.cucumber.energy.DynamicEnergyStorage;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.CachedRecipe;
import com.blakebr0.cucumber.inventory.SidedItemStackHandlerWrapper;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.api.crafting.IReprocessorRecipe;
import com.blakebr0.mysticalagriculture.block.ReprocessorBlock;
import com.blakebr0.mysticalagriculture.container.ReprocessorContainer;
import com.blakebr0.mysticalagriculture.container.inventory.UpgradeItemStackHandler;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import com.blakebr0.mysticalagriculture.util.IUpgradeableMachine;
import com.blakebr0.mysticalagriculture.util.MachineUpgradeTier;
import com.blakebr0.mysticalagriculture.util.RecipeIngredientCache;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ReprocessorTileEntity
extends BaseInventoryTileEntity
implements MenuProvider,
IUpgradeableMachine {
    private static final int FUEL_TICK_MULTIPLIER = 20;
    public static final int OPERATION_TIME = 200;
    public static final int FUEL_USAGE = 20;
    public static final int FUEL_CAPACITY = 80000;
    private final BaseItemStackHandler inventory;
    private final UpgradeItemStackHandler upgradeInventory;
    private final DynamicEnergyStorage energy;
    private final LazyOptional<IItemHandlerModifiable>[] inventoryCapabilities;
    private final LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(this::getEnergy);
    private final CachedRecipe<IReprocessorRecipe> recipe;
    private MachineUpgradeTier tier;
    private int progress;
    private int fuelLeft;
    private int fuelItemValue;
    private boolean isRunning;

    public ReprocessorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.REPROCESSOR.get(), pos, state);
        this.inventory = ReprocessorTileEntity.createInventoryHandler(() -> ((ReprocessorTileEntity)this).setChangedFast());
        this.upgradeInventory = new UpgradeItemStackHandler();
        this.energy = new DynamicEnergyStorage(80000, () -> ((ReprocessorTileEntity)this).setChangedFast());
        this.inventoryCapabilities = SidedItemStackHandlerWrapper.create((BaseItemStackHandler)this.inventory, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH}, this::canInsertStackSided, null);
        this.recipe = new CachedRecipe((RecipeType)ModRecipeTypes.REPROCESSOR.get());
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("Progress");
        this.fuelLeft = tag.m_128451_("FuelLeft");
        this.fuelItemValue = tag.m_128451_("FuelItemValue");
        this.energy.deserializeNBT(tag.m_128423_("Energy"));
        this.upgradeInventory.deserializeNBT(tag.m_128469_("UpgradeInventory"));
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Progress", this.progress);
        tag.m_128405_("FuelLeft", this.fuelLeft);
        tag.m_128405_("FuelItemValue", this.fuelItemValue);
        tag.m_128365_("Energy", this.energy.serializeNBT());
        tag.m_128365_("UpgradeInventory", (Tag)this.upgradeInventory.serializeNBT());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.m_58901_()) {
            if (cap == ForgeCapabilities.ENERGY) {
                return ForgeCapabilities.ENERGY.orEmpty(cap, this.energyCapability);
            }
            if (side != null && cap == ForgeCapabilities.ITEM_HANDLER) {
                if (side == Direction.UP) {
                    return this.inventoryCapabilities[0].cast();
                }
                if (side == Direction.DOWN) {
                    return this.inventoryCapabilities[1].cast();
                }
                return this.inventoryCapabilities[2].cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public Component m_5446_() {
        return Localizable.of((String)"container.mysticalagriculture.reprocessor").build();
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return ReprocessorContainer.create(id, playerInventory, this.inventory, this.upgradeInventory, this.m_58899_());
    }

    @Override
    public UpgradeItemStackHandler getUpgradeInventory() {
        return this.upgradeInventory;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ReprocessorTileEntity tile) {
        MachineUpgradeTier tier;
        if (tile.energy.getEnergyStored() < tile.energy.getMaxEnergyStored()) {
            ItemStack fuel = tile.inventory.getStackInSlot(1);
            if (tile.fuelLeft <= 0 && !fuel.m_41619_()) {
                tile.fuelItemValue = ForgeHooks.getBurnTime((ItemStack)fuel, null);
                if (tile.fuelItemValue > 0) {
                    tile.fuelLeft = tile.fuelItemValue *= 20;
                    tile.inventory.setStackInSlot(1, StackHelper.shrink((ItemStack)fuel, (int)1, (boolean)true));
                    tile.setChangedFast();
                }
            }
            if (tile.fuelLeft > 0) {
                int fuelPerTick = Math.min(Math.min(tile.fuelLeft, tile.getFuelUsage() * 2), tile.energy.getMaxEnergyStored() - tile.energy.getEnergyStored());
                tile.fuelLeft -= tile.energy.receiveEnergy(fuelPerTick, false);
                if (tile.fuelLeft <= 0) {
                    tile.fuelItemValue = 0;
                }
                tile.setChangedFast();
            }
        }
        if ((tier = tile.getMachineTier()) != tile.tier) {
            tile.tier = tier;
            if (tier == null) {
                tile.energy.resetMaxEnergyStorage();
            } else {
                tile.energy.setMaxEnergyStorage((int)(80000.0 * tier.getFuelCapacityMultiplier()));
            }
            tile.setChangedFast();
        }
        boolean wasRunning = tile.isRunning;
        if (tile.energy.getEnergyStored() >= tile.getFuelUsage()) {
            ItemStack input = tile.inventory.getStackInSlot(0);
            ItemStack output = tile.inventory.getStackInSlot(2);
            tile.isRunning = false;
            if (!input.m_41619_()) {
                ItemStack recipeOutput;
                IReprocessorRecipe recipe = tile.getActiveRecipe();
                if (recipe != null && !(recipeOutput = recipe.m_5874_((Container)tile.inventory.asRecipeWrapper(), level.m_9598_())).m_41619_() && (output.m_41619_() || StackHelper.canCombineStacks((ItemStack)output, (ItemStack)recipeOutput))) {
                    tile.isRunning = true;
                    ++tile.progress;
                    tile.energy.extractEnergy(tile.getFuelUsage(), false);
                    if (tile.progress >= tile.getOperationTime()) {
                        tile.inventory.setStackInSlot(0, StackHelper.shrink((ItemStack)tile.inventory.getStackInSlot(0), (int)1, (boolean)false));
                        tile.inventory.setStackInSlot(2, StackHelper.combineStacks((ItemStack)output, (ItemStack)recipeOutput));
                        tile.progress = 0;
                    }
                    tile.setChangedFast();
                }
            } else {
                tile.isRunning = false;
                if (tile.progress > 0) {
                    tile.progress = 0;
                    tile.setChangedFast();
                }
            }
        } else {
            tile.isRunning = false;
        }
        if (wasRunning != tile.isRunning) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ReprocessorBlock.RUNNING, (Comparable)Boolean.valueOf(tile.isRunning)), 3);
            tile.setChangedFast();
        }
        tile.dispatchIfChanged();
    }

    public static BaseItemStackHandler createInventoryHandler() {
        return ReprocessorTileEntity.createInventoryHandler(null);
    }

    public static BaseItemStackHandler createInventoryHandler(Runnable onContentsChanged) {
        return BaseItemStackHandler.create((int)3, (Runnable)onContentsChanged, builder -> {
            builder.setCanInsert((slot, stack) -> switch (slot) {
                case 1 -> FurnaceBlockEntity.m_58399_((ItemStack)stack);
                case 2 -> false;
                default -> true;
            });
            builder.setCanExtract(slot -> switch (slot) {
                case 1 -> !FurnaceBlockEntity.m_58399_((ItemStack)builder.getStackInSlot(slot.intValue()));
                case 2 -> true;
                default -> false;
            });
        });
    }

    public IReprocessorRecipe getActiveRecipe() {
        if (this.f_58857_ == null) {
            return null;
        }
        return (IReprocessorRecipe)this.recipe.checkAndGet(this.inventory, this.f_58857_);
    }

    public DynamicEnergyStorage getEnergy() {
        return this.energy;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getOperationTime() {
        if (this.tier == null) {
            return 200;
        }
        return (int)(200.0 * this.tier.getOperationTimeMultiplier());
    }

    public int getFuelLeft() {
        return this.fuelLeft;
    }

    public int getFuelItemValue() {
        return this.fuelItemValue;
    }

    public int getFuelUsage() {
        if (this.tier == null) {
            return 20;
        }
        return (int)(20.0 * this.tier.getFuelUsageMultiplier());
    }

    private boolean canInsertStackSided(int slot, ItemStack stack, Direction direction) {
        if (direction == null) {
            return true;
        }
        if (slot == 0 && direction == Direction.UP) {
            return RecipeIngredientCache.INSTANCE.isValidInput(stack, (RecipeType)ModRecipeTypes.REPROCESSOR.get());
        }
        if (slot == 1 && direction == Direction.NORTH) {
            return FurnaceBlockEntity.m_58399_((ItemStack)stack);
        }
        return false;
    }
}

