/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.api.quantumtunnel;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.world.entity.player.Player;
import nuclearscience.api.quantumtunnel.FrequencyType;
import voltaic.api.codec.StreamCodec;

public class TunnelFrequency {
    public static final UUID PUBLIC_ID = UUID.fromString("111aa11a-11a1-111a-aaaa-a1a11a111111");
    private static final UUID EMPTY_ID = UUID.fromString("111aa11a-11a1-111a-aaaa-a1a11a111112");
    public static final Codec<TunnelFrequency> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.f_235867_.fieldOf("channelid").forGetter(TunnelFrequency::getId), (App)UUIDUtil.f_235867_.fieldOf("creatorid").forGetter(TunnelFrequency::getCreatorId), (App)Codec.STRING.fieldOf("channelname").forGetter(TunnelFrequency::getName), (App)Codec.STRING.fieldOf("creatorfallbackname").forGetter(TunnelFrequency::getCreatorFallbackName), (App)Codec.INT.fieldOf("channeltype").forGetter(instance0 -> instance0.channelType)).apply((Applicative)instance, TunnelFrequency::new));
    public static final StreamCodec<ByteBuf, TunnelFrequency> STREAM_CODEC = new StreamCodec<ByteBuf, TunnelFrequency>(){

        public void encode(ByteBuf buffer, TunnelFrequency value) {
            StreamCodec.UUID.encode((Object)buffer, (Object)value.uuid);
            StreamCodec.UUID.encode((Object)buffer, (Object)value.creator);
            StreamCodec.STRING.encode((Object)buffer, (Object)value.name);
            StreamCodec.STRING.encode((Object)buffer, (Object)value.creatorFallbackName);
            StreamCodec.INT.encode((Object)buffer, (Object)value.channelType);
        }

        public TunnelFrequency decode(ByteBuf buffer) {
            return new TunnelFrequency((UUID)StreamCodec.UUID.decode((Object)buffer), (UUID)StreamCodec.UUID.decode((Object)buffer), (String)StreamCodec.STRING.decode((Object)buffer), (String)StreamCodec.STRING.decode((Object)buffer), (Integer)StreamCodec.INT.decode((Object)buffer));
        }
    };
    public static final TunnelFrequency NO_FREQUENCY = new TunnelFrequency(EMPTY_ID, EMPTY_ID, "", "", 0);
    private final UUID uuid;
    private final UUID creator;
    private String name = "";
    private final String creatorFallbackName;
    private final int channelType;

    private TunnelFrequency(UUID uuid, UUID creator, String name, String creatorFallbackName, int channelType) {
        this.uuid = uuid;
        this.creator = creator;
        this.name = name;
        this.creatorFallbackName = creatorFallbackName;
        this.channelType = channelType;
    }

    public UUID getId() {
        return this.uuid;
    }

    public UUID getCreatorId() {
        return this.creator;
    }

    public String getName() {
        return this.name;
    }

    public String getCreatorFallbackName() {
        return this.creatorFallbackName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FrequencyType getChannelType() {
        return FrequencyType.values()[this.channelType];
    }

    public static TunnelFrequency createPrivate(UUID id, Player creator, String name) {
        return new TunnelFrequency(id, creator.m_20148_(), name, creator.m_7755_().getString(), FrequencyType.PRIVATE.ordinal());
    }

    public static TunnelFrequency createPublic(UUID id, Player creator, String name) {
        return new TunnelFrequency(id, creator.m_20148_(), name, creator.m_7755_().getString(), FrequencyType.PUBLIC.ordinal());
    }

    public boolean equals(Object obj) {
        if (obj instanceof TunnelFrequency) {
            TunnelFrequency other = (TunnelFrequency)obj;
            return this.uuid.equals(other.uuid) && this.channelType == other.channelType;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.channelType);
    }
}

