/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import nuclearscience.common.inventory.container.ContainerElectromagneticGateway;
import nuclearscience.common.tile.accelerator.TileElectromagneticGateway;
import nuclearscience.prefab.utils.NuclearDisplayUnits;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.editbox.ScreenComponentEditBox;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.math.Color;

public class ScreenElectromagneticGateway
extends GenericScreen<ContainerElectromagneticGateway> {
    private boolean needsUpdate = true;
    private ScreenComponentEditBox box;

    public ScreenElectromagneticGateway(ContainerElectromagneticGateway container, Inventory inv, Component title) {
        super((GenericContainer)container, inv, title);
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(10, 25, 10, Color.TEXT_GRAY, (Component)NuclearTextUtils.gui("electromagneticswitch.targetspeed", new Object[0])));
        this.box = new ScreenComponentEditBox(10, 40, 120, 15, this.getFontRenderer()).setFilter(ScreenComponentEditBox.POSITIVE_DECIMAL).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(20).setResponder(val -> {
            TileElectromagneticGateway tile = (TileElectromagneticGateway)((ContainerElectromagneticGateway)this.f_97732_).getSafeHost();
            if (tile == null) {
                return;
            }
            float temp = 0.0f;
            try {
                temp = Float.parseFloat(val);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (temp < 0.0f) {
                temp = 0.0f;
            } else if (temp > 100.0f) {
                temp = 100.0f;
            }
            tile.targetSpeed.setValue((Object)Float.valueOf(temp));
        });
        this.addEditBox(this.box);
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(132, 43, 10, Color.TEXT_GRAY, (Component)DisplayUnits.PERCENTAGE.getSymbol().m_6881_().m_7220_(NuclearDisplayUnits.SPEEDOFLIGHT.getSymbol())));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        TileElectromagneticGateway gateway = (TileElectromagneticGateway)((ContainerElectromagneticGateway)this.m_6262_()).getSafeHost();
        if (this.needsUpdate && gateway != null) {
            this.box.setValue("" + gateway.targetSpeed.getValue());
            this.needsUpdate = false;
        }
    }
}

