/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.logisticsnetwork.interfaces;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import nuclearscience.common.network.ReactorLogisticsNetwork;
import nuclearscience.common.tags.NuclearScienceTags;
import nuclearscience.common.tile.reactor.fission.IFissionControlRod;
import nuclearscience.common.tile.reactor.fission.TileFissionReactorCore;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileControlRodModule;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileReactorLogisticsCable;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileSupplyModule;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.GenericTileInterface;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentTickable;

public class TileFissionInterface
extends GenericTileInterface
implements IFissionControlRod {
    public final SingleProperty<Integer> insertion = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "insertion", (Object)0));

    public TileFissionInterface(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)NuclearScienceTiles.TILE_FISSIONINTERFACE.get(), worldPos, blockState);
    }

    @Override
    public void tickServer(ComponentTickable tickable) {
        int j;
        ItemStack item;
        super.tickServer(tickable);
        if (!this.networkCable.valid() || !(this.networkCable.getSafe() instanceof TileReactorLogisticsCable)) {
            this.insertion.setValue((Object)0);
            return;
        }
        TileReactorLogisticsCable cable = (TileReactorLogisticsCable)((Object)this.networkCable.getSafe());
        if (cable.m_58901_()) {
            this.insertion.setValue((Object)0);
            return;
        }
        ReactorLogisticsNetwork network = (ReactorLogisticsNetwork)cable.getNetwork();
        if (!network.isControllerActive()) {
            this.insertion.setValue((Object)0);
            return;
        }
        TileControlRodModule controlRod = network.getControlRod((BlockPos)this.controlRodLocation.getValue());
        if (controlRod == null) {
            this.insertion.setValue((Object)0);
        } else {
            this.insertion.setValue(controlRod.insertion.getValue());
        }
        TileSupplyModule supplyModule = network.getSupplyModule((BlockPos)this.supplyModuleLocation.getValue());
        if (!this.reactor.valid() || supplyModule == null || !(this.reactor.getSafe() instanceof TileFissionReactorCore)) {
            return;
        }
        TileFissionReactorCore core = (TileFissionReactorCore)((Object)this.reactor.getSafe());
        ComponentInventory coreInv = (ComponentInventory)core.getComponent(IComponentType.Inventory);
        ComponentInventory supplyInv = (ComponentInventory)supplyModule.getComponent(IComponentType.Inventory);
        boolean isExtractingSpentCell = this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_1) || this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_2) || this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_3) || this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_4);
        boolean isInsertingFuelCell = this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_1) || this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_2) || this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_3) || this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_4);
        boolean isExtractingTritium = this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_TRITIUM_EXTRACT);
        boolean isInsertingDeuterium = this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FISSION_DEUTERIUM_INSERT);
        ItemStack deuterium = coreInv.m_8020_(4);
        if (!isInsertingFuelCell) {
            for (int i = 0; i < 4; ++i) {
                item = coreInv.m_8020_(i);
                if (item.m_41619_() || !item.m_204117_(NuclearScienceTags.Items.FUELROD_SPENT)) continue;
                boolean inserted = false;
                for (j = 9; j < 18; ++j) {
                    if (!supplyInv.m_8020_(j).m_41619_()) continue;
                    supplyInv.m_6836_(j, item.m_41777_());
                    coreInv.m_6836_(i, ItemStack.f_41583_);
                    inserted = true;
                    break;
                }
                if (!inserted) continue;
                switch (i) {
                    case 0: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_1.ordinal());
                        break;
                    }
                    case 1: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_2.ordinal());
                        break;
                    }
                    case 2: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_3.ordinal());
                        break;
                    }
                    case 3: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_WASTE_4.ordinal());
                    }
                }
                isExtractingSpentCell = true;
            }
        }
        if (!isInsertingDeuterium && !coreInv.areOutputsEmpty()) {
            item = coreInv.m_8020_(5);
            boolean extracted = false;
            for (j = 9; j < 18 && !coreInv.areOutputsEmpty() && !item.m_41619_(); ++j) {
                ItemStack destItem = supplyInv.m_8020_(j);
                if (destItem.m_41619_()) {
                    supplyInv.m_6836_(j, item.m_41777_());
                    coreInv.m_6836_(5, ItemStack.f_41583_);
                    extracted = true;
                    continue;
                }
                if (!destItem.m_204117_(NuclearScienceTags.Items.CELL_TRITIUM) || destItem.m_41613_() >= destItem.m_41741_()) continue;
                int taken = Math.min(destItem.m_41741_() - destItem.m_41613_(), item.m_41613_());
                destItem.m_41769_(taken);
                item.m_41774_(taken);
                extracted = true;
            }
            if (extracted) {
                this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_TRITIUM_EXTRACT.ordinal());
                isExtractingTritium = true;
            }
        }
        if (!isExtractingSpentCell && !supplyInv.areInputsEmpty()) {
            block15: for (int i = 0; i < 4; ++i) {
                item = coreInv.m_8020_(i);
                if (item.m_204117_(NuclearScienceTags.Items.FUELROD_URANIUM_LOW_EN) || item.m_204117_(NuclearScienceTags.Items.FUELROD_URANIUM_HIGH_EN) || item.m_204117_(NuclearScienceTags.Items.FUELROD_PLUTONIUM) || !item.m_41619_()) continue;
                boolean inserted = false;
                for (int j2 = 0; j2 < 9; ++j2) {
                    ItemStack supplyItem = supplyInv.m_8020_(j2);
                    if (!supplyItem.m_204117_(NuclearScienceTags.Items.FUELROD_URANIUM_LOW_EN) && !supplyItem.m_204117_(NuclearScienceTags.Items.FUELROD_URANIUM_HIGH_EN) && !supplyItem.m_204117_(NuclearScienceTags.Items.FUELROD_PLUTONIUM)) continue;
                    coreInv.m_6836_(i, supplyItem.m_41777_());
                    supplyInv.m_6836_(j2, ItemStack.f_41583_);
                    inserted = true;
                    break;
                }
                if (!inserted) continue;
                switch (i) {
                    case 0: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_1.ordinal());
                        continue block15;
                    }
                    case 1: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_2.ordinal());
                        continue block15;
                    }
                    case 2: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_3.ordinal());
                        continue block15;
                    }
                    case 3: {
                        this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_FUEL_4.ordinal());
                    }
                }
            }
        }
        if (!isExtractingTritium && (deuterium.m_41619_() || deuterium.m_204117_(NuclearScienceTags.Items.CELL_DEUTERIUM) && deuterium.m_41613_() < deuterium.m_41741_())) {
            boolean taken = false;
            for (int j3 = 0; !(j3 >= 9 || (deuterium = coreInv.m_8020_(4)).m_204117_(NuclearScienceTags.Items.CELL_DEUTERIUM) && deuterium.m_41613_() >= deuterium.m_41741_()); ++j3) {
                item = supplyInv.m_8020_(j3).m_41777_();
                if (!item.m_204117_(NuclearScienceTags.Items.CELL_DEUTERIUM)) continue;
                if (deuterium.m_41619_()) {
                    coreInv.m_6836_(4, item.m_41777_());
                    supplyInv.m_6836_(j3, ItemStack.f_41583_);
                    taken = true;
                    continue;
                }
                if (deuterium.m_41613_() >= deuterium.m_41741_()) continue;
                int amt = Math.min(item.m_41613_(), deuterium.m_41741_() - deuterium.m_41613_());
                supplyInv.m_7407_(j3, amt);
                deuterium.m_41769_(amt);
                taken = true;
            }
            if (taken) {
                this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FISSION_DEUTERIUM_INSERT.ordinal());
            }
        }
        this.handleServerAnimations(tickable);
    }

    @Override
    public int getInsertion() {
        return (Integer)this.insertion.getValue();
    }

    @Override
    public Direction getReactorDirection() {
        return Direction.UP;
    }

    @Override
    public GenericTileInterface.InterfaceType getInterfaceType() {
        return GenericTileInterface.InterfaceType.FISSION;
    }

    @Override
    public Direction getCableLocation() {
        return Direction.DOWN;
    }
}

