/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.compatibility.jei;

import electrodynamics.compatibility.jei.recipecategories.utils.psuedorecipes.types.PsuedoItem2ItemRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IExtraIngredientRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;
import nuclearscience.NuclearScience;
import nuclearscience.client.screen.ScreenChemicalExtractor;
import nuclearscience.client.screen.ScreenFissionReactorCore;
import nuclearscience.client.screen.ScreenGasCentrifuge;
import nuclearscience.client.screen.ScreenMSRFuelPreProcessor;
import nuclearscience.client.screen.ScreenNuclearBoiler;
import nuclearscience.client.screen.ScreenParticleInjector;
import nuclearscience.client.screen.ScreenRadioactiveProcessor;
import nuclearscience.compatibility.jei.recipecategories.fluiditem2gas.specificmachines.NuclearBoilerRecipeCategory;
import nuclearscience.compatibility.jei.recipecategories.fluiditem2item.specificmachines.ChemicalExtractorRecipeCategory;
import nuclearscience.compatibility.jei.recipecategories.fluiditem2item.specificmachines.MSRProcessorRecipeCategory;
import nuclearscience.compatibility.jei.recipecategories.fluiditem2item.specificmachines.RadioactiveProcessorRecipeCategory;
import nuclearscience.compatibility.jei.recipecategories.item2item.FissionReactorRecipeCategory;
import nuclearscience.compatibility.jei.recipecategories.item2item.FuelReprocessorRecipeCategory;
import nuclearscience.compatibility.jei.recipecategories.psuedo.specificmachines.GasCentrifugeRecipeCategory;
import nuclearscience.compatibility.jei.recipecategories.psuedo.specificmachines.ParticleAcceleratorAntiMatterRecipeCategory;
import nuclearscience.compatibility.jei.recipecategories.psuedo.specificmachines.ParticleAcceleratorDarkMatterRecipeCategory;
import nuclearscience.compatibility.jei.utils.psuedorecipes.NuclearSciencePsuedoRecipes;
import nuclearscience.compatibility.jei.utils.psuedorecipes.PsuedoGasCentrifugeRecipe;
import nuclearscience.registers.NuclearScienceFluids;
import nuclearscience.registers.NuclearScienceGases;
import nuclearscience.registers.NuclearScienceRecipies;
import voltaic.api.gas.Gas;
import voltaic.api.gas.GasStack;
import voltaic.compatibility.jei.utils.ingredients.VoltaicJeiTypes;
import voltaic.registers.VoltaicGases;

@JeiPlugin
public class NuclearSciencePlugin
implements IModPlugin {
    public static final ResourceLocation ID = NuclearScience.rl("jei");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(GasCentrifugeRecipeCategory.INPUT_MACHINE, new RecipeType[]{GasCentrifugeRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(NuclearBoilerRecipeCategory.INPUT_MACHINE, new RecipeType[]{NuclearBoilerRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(ChemicalExtractorRecipeCategory.INPUT_MACHINE, new RecipeType[]{ChemicalExtractorRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(FissionReactorRecipeCategory.INPUT_MACHINE, new RecipeType[]{FissionReactorRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(ParticleAcceleratorAntiMatterRecipeCategory.INPUT_MACHINE, new RecipeType[]{ParticleAcceleratorAntiMatterRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(ParticleAcceleratorDarkMatterRecipeCategory.INPUT_MACHINE, new RecipeType[]{ParticleAcceleratorDarkMatterRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(FuelReprocessorRecipeCategory.INPUT_MACHINE, new RecipeType[]{FuelReprocessorRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(RadioactiveProcessorRecipeCategory.INPUT_MACHINE, new RecipeType[]{RadioactiveProcessorRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(MSRProcessorRecipeCategory.INPUT_MACHINE, new RecipeType[]{MSRProcessorRecipeCategory.RECIPE_TYPE});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        NuclearSciencePsuedoRecipes.addNuclearScienceRecipes();
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = Objects.requireNonNull(mc.f_91073_);
        RecipeManager recipeManager = world.m_7465_();
        ArrayList<PsuedoGasCentrifugeRecipe> gasCentrifugeRecipes = new ArrayList<PsuedoGasCentrifugeRecipe>(NuclearSciencePsuedoRecipes.GAS_CENTRIFUGE_RECIPES);
        registration.addRecipes(GasCentrifugeRecipeCategory.RECIPE_TYPE, gasCentrifugeRecipes);
        List nuclearBoilerRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)NuclearScienceRecipies.NUCLEAR_BOILER_TYPE.get());
        registration.addRecipes(NuclearBoilerRecipeCategory.RECIPE_TYPE, nuclearBoilerRecipes);
        List chemicalExtractorRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)NuclearScienceRecipies.CHEMICAL_EXTRACTOR_TYPE.get());
        registration.addRecipes(ChemicalExtractorRecipeCategory.RECIPE_TYPE, chemicalExtractorRecipes);
        List fissionReactorRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)NuclearScienceRecipies.FISSION_REACTOR_TYPE.get());
        registration.addRecipes(FissionReactorRecipeCategory.RECIPE_TYPE, fissionReactorRecipes);
        ArrayList<PsuedoItem2ItemRecipe> antiMatterRecipes = new ArrayList<PsuedoItem2ItemRecipe>(NuclearSciencePsuedoRecipes.ANTI_MATTER_RECIPES);
        registration.addRecipes(ParticleAcceleratorAntiMatterRecipeCategory.RECIPE_TYPE, antiMatterRecipes);
        ArrayList<PsuedoItem2ItemRecipe> darkMatterRecipes = new ArrayList<PsuedoItem2ItemRecipe>(NuclearSciencePsuedoRecipes.DARK_MATTER_RECIPES);
        registration.addRecipes(ParticleAcceleratorDarkMatterRecipeCategory.RECIPE_TYPE, darkMatterRecipes);
        List fuelReprocessorRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)NuclearScienceRecipies.FUEL_REPROCESSOR_TYPE.get());
        registration.addRecipes(FuelReprocessorRecipeCategory.RECIPE_TYPE, fuelReprocessorRecipes);
        List radioactiveProcessorRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)NuclearScienceRecipies.RADIOACTIVE_PROCESSOR_TYPE.get());
        registration.addRecipes(RadioactiveProcessorRecipeCategory.RECIPE_TYPE, radioactiveProcessorRecipes);
        List msrProcessorRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)NuclearScienceRecipies.MSR_FUEL_PREPROCESSOR_TYPE.get());
        registration.addRecipes(MSRProcessorRecipeCategory.RECIPE_TYPE, msrProcessorRecipes);
        NuclearSciencePlugin.nuclearScienceInfoTabs(registration);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new GasCentrifugeRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new NuclearBoilerRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ChemicalExtractorRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FissionReactorRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ParticleAcceleratorAntiMatterRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ParticleAcceleratorDarkMatterRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FuelReprocessorRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new RadioactiveProcessorRecipeCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new MSRProcessorRecipeCategory(helper)});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addRecipeClickArea(ScreenNuclearBoiler.class, 97, 31, 22, 15, new RecipeType[]{NuclearBoilerRecipeCategory.RECIPE_TYPE});
        registry.addRecipeClickArea(ScreenRadioactiveProcessor.class, 97, 31, 22, 15, new RecipeType[]{RadioactiveProcessorRecipeCategory.RECIPE_TYPE});
        registry.addRecipeClickArea(ScreenChemicalExtractor.class, 97, 31, 22, 15, new RecipeType[]{ChemicalExtractorRecipeCategory.RECIPE_TYPE});
        registry.addRecipeClickArea(ScreenGasCentrifuge.class, 105, 13, 20, 54, new RecipeType[]{GasCentrifugeRecipeCategory.RECIPE_TYPE});
        registry.addRecipeClickArea(ScreenFissionReactorCore.class, 77, 38, 22, 15, new RecipeType[]{FissionReactorRecipeCategory.RECIPE_TYPE});
        registry.addRecipeClickArea(ScreenParticleInjector.class, 102, 43, 28, 14, new RecipeType[]{ParticleAcceleratorAntiMatterRecipeCategory.RECIPE_TYPE, ParticleAcceleratorDarkMatterRecipeCategory.RECIPE_TYPE});
        registry.addRecipeClickArea(ScreenMSRFuelPreProcessor.class, 98, 40, 16, 16, new RecipeType[]{MSRProcessorRecipeCategory.RECIPE_TYPE});
    }

    private static void nuclearScienceInfoTabs(IRecipeRegistration registration) {
    }

    public void registerExtraIngredients(IExtraIngredientRegistration registration) {
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        for (RegistryObject fluid : NuclearScienceFluids.FLUIDS.getEntries()) {
            fluids.add(new FluidStack((Fluid)fluid.get(), 1000));
        }
        registration.addExtraIngredients((IIngredientType)ForgeTypes.FLUID_STACK, fluids);
        ArrayList<GasStack> gases = new ArrayList<GasStack>();
        for (RegistryObject gas : NuclearScienceGases.GASES.getEntries()) {
            if (gas.get() == VoltaicGases.EMPTY.get()) continue;
            gases.add(new GasStack((Gas)gas.get(), 1000, 293, 1));
        }
        registration.addExtraIngredients((IIngredientType)VoltaicJeiTypes.GAS_STACK, gases);
    }
}

