/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.frame;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.client.gui.clickable.IClickable;
import lehjr.numina.client.gui.clickable.ModularItemTabToggleWidget;
import lehjr.numina.client.gui.clickable.button.VanillaButton;
import lehjr.numina.client.gui.frame.AbstractGuiFrame;
import lehjr.numina.client.gui.geometry.DrawableTile;
import lehjr.numina.client.gui.geometry.IRect;
import lehjr.numina.client.gui.geometry.MusePoint2D;
import lehjr.numina.client.gui.geometry.Rect;
import lehjr.numina.common.capabilities.inventory.modularitem.IModularItem;
import lehjr.numina.common.constants.NuminaConstants;
import lehjr.numina.common.item.ItemUtils;
import lehjr.numina.common.string.StringUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class ModularItemSelectionFrame
extends AbstractGuiFrame {
    public ModularItemTabToggleWidget selectedTab = null;
    public VanillaButton creativeInstallButton;
    public VanillaButton creativeInstallAllButton;
    IChanged changed;
    List<IRect> boxes;
    final List<EquipmentSlot> equipmentSlotTypes = Arrays.asList(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET, EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND);

    public ModularItemSelectionFrame(MusePoint2D ul) {
        this(ul, EquipmentSlot.HEAD);
    }

    public ModularItemSelectionFrame(MusePoint2D ul, EquipmentSlot type) {
        super(new DrawableTile(ul, ul.plus(35.0, 200.0)));
        this.boxes = new ArrayList<IRect>();
        this.boxes.add(new Rect(ul.copy(), ul.plus(35.0, 11.0)));
        boolean i = false;
        for (EquipmentSlot slotType : this.equipmentSlotTypes) {
            ModularItemTabToggleWidget widget = new ModularItemTabToggleWidget(slotType);
            widget.setUL(ul.copy());
            widget.setBelow(this.boxes.get(this.boxes.size() - 1));
            widget.setOnPressed(pressed -> {
                if (widget != this.selectedTab) {
                    this.selectedTab.setStateActive(false);
                    this.selectedTab = widget;
                    this.selectedTab.setStateActive(true);
                    this.onChanged();
                    this.disableAbstractContainerMenuSlots();
                }
            });
            if (slotType == type) {
                this.selectedTab = widget;
                this.selectedTab.setStateActive(true);
            }
            this.boxes.add(widget);
            this.boxes.add(new Rect(ul, ul.plus(35.0, 3.0)));
        }
        this.creativeInstallButton = new VanillaButton(MusePoint2D.ZERO, (Component)Component.m_237115_((String)NuminaConstants.GUI_CREATIVE_INSTALL), false);
        this.creativeInstallButton.setHeight(18.0);
        this.creativeInstallButton.setWidth(38.0);
        this.creativeInstallButton.disableAndHide();
        this.creativeInstallButton.setToolTip(List.of(Component.m_237115_((String)NuminaConstants.GUI_CREATIVE_INSTALL_DESC)));
        this.creativeInstallButton.setUL(this.getUL().copy());
        this.boxes.add(this.creativeInstallButton);
        this.creativeInstallAllButton = new VanillaButton(MusePoint2D.ZERO, (Component)Component.m_237115_((String)NuminaConstants.GUI_CREATIVE_INSTALL_ALL), false);
        this.creativeInstallAllButton.setHeight(18.0);
        this.creativeInstallAllButton.setWidth(StringUtils.getStringWidth((FormattedText)this.creativeInstallAllButton.getLabel()) + 6.0);
        this.creativeInstallAllButton.disableAndHide();
        this.creativeInstallAllButton.setToolTip(List.of(Component.m_237115_((String)NuminaConstants.GUI_CREATIVE_INSTALL_ALL_DESC)));
        this.creativeInstallAllButton.setUL(this.getUL().copy());
        this.boxes.add(this.creativeInstallAllButton);
        this.refreshRects();
    }

    public void refreshRects() {
        double finalHeight = 0.0;
        for (int index = 0; index < this.boxes.size(); ++index) {
            IRect rect = this.boxes.get(index);
            if (index == 0) {
                rect.setUL(this.getUL());
            } else {
                rect.setLeft(this.left()).setBelow(this.boxes.get(index - 1));
            }
            finalHeight += rect.height();
        }
        this.setHeight(finalHeight);
        this.creativeInstallButton.setLeft(this.left() - 7.0);
        this.creativeInstallAllButton.setLeft(this.creativeInstallButton.left() + this.creativeInstallButton.width() - this.creativeInstallAllButton.width());
    }

    public VanillaButton getCreativeInstallButton() {
        return this.creativeInstallButton;
    }

    public VanillaButton getCreativeInstallAllButton() {
        return this.creativeInstallAllButton;
    }

    void disableAbstractContainerMenuSlots() {
    }

    public ItemStack getModularItemOrEmpty() {
        return this.getSelectedTab().map(tab -> {
            ItemStack stack = this.getStack(tab.getSlotType());
            return this.getModularItemCapability(tab.getSlotType()).isPresent() ? stack : ItemStack.f_41583_;
        }).orElse(ItemStack.f_41583_);
    }

    public Optional<IModularItem> getModularItemCapability() {
        return this.getModularItemOrEmpty().getCapability(ForgeCapabilities.ITEM_HANDLER).filter(IModularItem.class::isInstance).map(IModularItem.class::cast);
    }

    public boolean playerHasModularItems() {
        return this.equipmentSlotTypes.stream().anyMatch(type -> this.getModularItemCapability((EquipmentSlot)type).isPresent());
    }

    Optional<IModularItem> getModularItemCapability(EquipmentSlot type) {
        return this.getStack(type).getCapability(ForgeCapabilities.ITEM_HANDLER).filter(IModularItem.class::isInstance).map(IModularItem.class::cast);
    }

    @Nonnull
    ItemStack getStack(EquipmentSlot type) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        assert (player != null);
        return ItemUtils.getItemFromEntitySlot((LivingEntity)player, type);
    }

    public Optional<EquipmentSlot> selectedType() {
        return this.getSelectedTab().map(ModularItemTabToggleWidget::getSlotType);
    }

    public Optional<ModularItemTabToggleWidget> getSelectedTab() {
        if (this.selectedTab == null) {
            this.selectedTab = this.boxes.stream().filter(ModularItemTabToggleWidget.class::isInstance).map(ModularItemTabToggleWidget.class::cast).findFirst().orElse(null);
            if (this.selectedTab != null) {
                this.selectedTab.setStateActive(true);
            }
        }
        this.boxes.stream().filter(ModularItemTabToggleWidget.class::isInstance).map(ModularItemTabToggleWidget.class::cast).forEach(widget -> widget.setStateActive(widget == this.selectedTab));
        return Optional.ofNullable(this.selectedTab);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.boxes.stream().filter(IClickable.class::isInstance).map(IClickable.class::cast).anyMatch(box -> box.mouseClicked(mouseX, mouseY, button))) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.boxes.stream().filter(IClickable.class::isInstance).map(IClickable.class::cast).anyMatch(box -> box.mouseReleased(mouseX, mouseY, button))) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        this.boxes.stream().filter(IClickable.class::isInstance).map(IClickable.class::cast).forEach(box -> box.m_88315_(gfx, mouseX, mouseY, partialTick));
    }

    @Override
    @Nullable
    public List<Component> getToolTip(int x, int y) {
        return this.boxes.stream().filter(IClickable.class::isInstance).map(IClickable.class::cast).filter(box -> box.containsPoint(x, y)).findFirst().map(box -> box.getToolTip(x, y)).orElse(super.getToolTip(x, y));
    }

    @Override
    public void update(double mouseX, double mouseY) {
        super.update(mouseX, mouseY);
        this.getSelectedTab();
    }

    public void setOnChanged(IChanged changed) {
        this.changed = changed;
    }

    public void onChanged() {
        if (this.isEnabled() && this.isVisible()) {
            this.refreshRects();
            if (this.changed != null) {
                this.changed.onChanged();
            }
        }
    }

    public static interface IChanged {
        public void onChanged();
    }
}

