/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.heat;

import javax.annotation.Nonnull;
import lehjr.numina.common.capabilities.heat.HeatStorage;
import lehjr.numina.common.capabilities.heat.IHeatStorage;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.common.tags.TagUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;

public class HeatItemWrapper
extends HeatStorage {
    ItemStack stack;
    private final LazyOptional<IHeatStorage> holder = LazyOptional.of(() -> this);

    public HeatItemWrapper(@Nonnull ItemStack stack, double baseMax, LazyOptional<IPowerModule> moduleCap) {
        this(stack, baseMax + moduleCap.map(cap -> cap.applyPropertyModifiers("maxHeat")).orElse(0.0));
    }

    public HeatItemWrapper(@Nonnull ItemStack stack, double capacity) {
        this(stack, capacity, capacity, capacity);
    }

    public HeatItemWrapper(@Nonnull ItemStack stack, double capacity, double maxTransfer) {
        this(stack, capacity, maxTransfer, maxTransfer);
    }

    public HeatItemWrapper(@Nonnull ItemStack stack, double capacity, double maxReceive, double maxExtract) {
        super(capacity, maxReceive, maxExtract, 0.0);
        this.stack = stack;
    }

    @Override
    public void loadCapValues() {
        this.heat = Math.min(this.capacity, TagUtils.getModularItemDoubleOrZero(this.stack, "heat"));
    }

    @Override
    public void onValueChanged() {
        TagUtils.setModularItemDoubleOrRemove(this.stack, "heat", this.heat);
    }
}

