/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.inventory.modularitem;

import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class NuminaRangedWrapper
extends RangedWrapper {
    private final int minSlot;
    private final int maxSlot;

    public NuminaRangedWrapper(IItemHandlerModifiable compose, int minSlot, int maxSlotExclusive) {
        super(compose, minSlot, maxSlotExclusive);
        this.minSlot = minSlot;
        this.maxSlot = maxSlotExclusive;
    }

    public boolean contains(int slot) {
        return slot >= this.minSlot && slot < this.maxSlot;
    }

    public Pair<Integer, Integer> getRange() {
        return Pair.of((Object)this.minSlot, (Object)this.maxSlot);
    }

    public int getSlots() {
        return super.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return super.getStackInSlot(slot - this.minSlot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return super.insertItem(slot - this.minSlot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return super.extractItem(slot - this.minSlot, amount, simulate);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        super.setStackInSlot(slot - this.minSlot, stack);
    }

    public int getSlotLimit(int slot) {
        return super.getSlotLimit(slot - this.minSlot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return super.isItemValid(slot - this.minSlot, stack);
    }
}

