/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.render.chameleon;

import java.util.Optional;
import javax.annotation.Nonnull;
import lehjr.numina.common.capabilities.render.chameleon.IChameleon;
import lehjr.numina.common.tags.TagUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;

public class Chameleon
implements IChameleon,
INBTSerializable<StringTag> {
    ResourceLocation blockRegName = null;
    @Nonnull
    ItemStack module;

    public Chameleon(@Nonnull ItemStack module) {
        this.module = module;
        CompoundTag tag = TagUtils.getModuleTag(this.module);
        if (tag.m_128425_("block", 8)) {
            this.deserializeNBT((StringTag)tag.m_128423_("block"));
        }
    }

    @Override
    public Optional<ResourceLocation> getTargetBlockRegName() {
        return Optional.ofNullable(this.blockRegName);
    }

    @Override
    public Optional<Block> getTargetBlock() {
        return this.getTargetBlockRegName().map(regNane -> (Block)ForgeRegistries.BLOCKS.getValue(regNane));
    }

    @Override
    @Nonnull
    public ItemStack getStackToRender() {
        return this.getTargetBlock().map(block -> new ItemStack((ItemLike)block.m_5456_())).orElse(this.module);
    }

    public StringTag serializeNBT() {
        if (this.blockRegName != null) {
            return StringTag.m_129297_((String)this.blockRegName.toString());
        }
        return null;
    }

    @Override
    public void setTargetBlockByRegName(ResourceLocation regName) {
        IChameleon.super.setTargetBlockByRegName(regName);
        this.blockRegName = regName;
        this.serializeNBT();
    }

    public void deserializeNBT(StringTag nbt) {
        if (nbt != null) {
            this.blockRegName = new ResourceLocation(nbt.m_7916_());
        }
    }

    @Override
    public void loadCapValues() {
        CompoundTag tag = TagUtils.getModuleTag(this.module);
        if (tag.m_128425_("block", 8)) {
            this.deserializeNBT((StringTag)tag.m_128423_("block"));
        }
    }

    @Override
    public void onValueChanged() {
        TagUtils.setModuleResourceLocation(this.module, "block", this.blockRegName);
    }
}

