/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.pillagers_gun.compat.tacz;

import com.google.common.collect.Maps;
import com.scarasol.pillagers_gun.config.CommonConfig;
import com.scarasol.pillagers_gun.event.EventHandler;
import com.scarasol.pillagers_gun.init.PillagersGunItems;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.resource.pojo.data.gun.FeedType;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.sound.SoundManager;
import com.tacz.guns.util.AttachmentDataUtils;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class TaczCompat {
    public static final ItemStack SHOTGUN;
    public static final ItemStack ASSAULT_RIFLE;
    public static final ItemStack PISTOL;
    public static final ItemStack SNIPERS_RIFLE;
    public static final ItemStack BAZOOKA;
    public static final Map<Item, ItemStack> GUN_SWITCH;
    public static final Map<String, Double> GUN_INACCURACY;
    public static final Map<ResourceLocation, Double> SPAWN_GUN;
    public static double totalWeight;

    public static void playSound(ItemStack itemStack, LivingEntity shooter) {
        Item item = itemStack.m_41720_();
        if (item instanceof IGun) {
            IGun gun = (IGun)item;
            String soundId = SoundManager.SHOOT_3P_SOUND;
            SoundManager.sendSoundToNearby((LivingEntity)shooter, (int)64, (ResourceLocation)gun.getGunId(itemStack), (ResourceLocation)gun.getGunDisplayId(itemStack), (String)soundId, (float)0.8f, (float)(0.9f + shooter.m_217043_().m_188501_() * 0.125f));
        }
    }

    public static ItemStack itemStackSwitch(ItemStack itemStack) {
        return GUN_SWITCH.getOrDefault(itemStack.m_41720_(), itemStack);
    }

    public static void changeEquipmentTo(LivingEquipmentChangeEvent event) {
        TaczCompat.zoomAttributeModifier(event.getTo(), event.getEntity());
    }

    public static void zoomAttributeModifier(ItemStack itemStack, LivingEntity shooter) {
        IGun gun = IGun.getIGunOrNull((ItemStack)itemStack);
        if (gun != null) {
            float aimingZoom;
            try {
                aimingZoom = gun.getAimingZoom(itemStack) / 2.0f - 1.0f;
            }
            catch (NoSuchMethodError e) {
                aimingZoom = 0.0f;
            }
            AttributeInstance attributeInstance = shooter.m_21204_().m_22146_(Attributes.f_22277_);
            if (attributeInstance != null) {
                attributeInstance.m_22120_(EventHandler.ATTRIBUTE_MODIFIER_UUID);
                if (aimingZoom > 0.0f) {
                    AttributeModifier attributeModifier = new AttributeModifier(EventHandler.ATTRIBUTE_MODIFIER_UUID, "tacz", (double)aimingZoom, AttributeModifier.Operation.MULTIPLY_BASE);
                    attributeInstance.m_22125_(attributeModifier);
                }
            }
        }
    }

    public static double getInaccuracy(String type, double originalValue) {
        if (GUN_INACCURACY.isEmpty()) {
            for (String info : (List)CommonConfig.TACZ_GUN_INACCURACY.get()) {
                String[] inaccuracy = info.trim().split(",");
                if (inaccuracy.length < 2) continue;
                GUN_INACCURACY.put(inaccuracy[0], Double.parseDouble(inaccuracy[1]));
            }
        }
        return GUN_INACCURACY.getOrDefault(type, originalValue);
    }

    public static boolean spawnWithTaczGun(Mob mob) {
        Item item;
        if (SPAWN_GUN.isEmpty()) {
            for (String info : (List)CommonConfig.TACZ_GUN_TYPE.get()) {
                String[] gunType = info.trim().split(",");
                if (gunType.length < 2) continue;
                totalWeight += Double.parseDouble(gunType[1]);
                SPAWN_GUN.put(new ResourceLocation(gunType[0]), Double.parseDouble(gunType[1]));
            }
        }
        if (totalWeight > 0.0 && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tacz:modern_kinetic_gun"))) instanceof IGun) {
            IGun iGun = (IGun)item;
            ItemStack itemStack = new ItemStack((ItemLike)item);
            Random random = new Random();
            double weight = random.nextDouble() * totalWeight;
            for (Map.Entry<ResourceLocation, Double> entry : SPAWN_GUN.entrySet()) {
                if (weight <= entry.getValue()) {
                    return TimelessAPI.getCommonGunIndex((ResourceLocation)entry.getKey()).map(commonGunIndex -> {
                        iGun.setGunId(itemStack, (ResourceLocation)entry.getKey());
                        int maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment((ItemStack)itemStack, (GunData)commonGunIndex.getGunData());
                        iGun.setCurrentAmmoCount(itemStack, random.nextInt(0, maxAmmoCount));
                        iGun.setFireMode(itemStack, (FireMode)commonGunIndex.getGunData().getFireModeSet().get(0));
                        iGun.setBulletInBarrel(itemStack, true);
                        if (((Boolean)CommonConfig.TACZ_GUNNERS_NEED_AMMO.get()).booleanValue()) {
                            if (iGun.useInventoryAmmo(itemStack)) {
                                iGun.setDummyAmmoAmount(itemStack, (int)(random.nextDouble((Double)CommonConfig.GUARD_TACZ_GUN_MIN_AMMO.get(), (Double)CommonConfig.GUARD_TACZ_GUN_MAX_AMMO.get()) * 40.0));
                            } else if (commonGunIndex.getGunData().getReloadData().getType() == FeedType.FUEL) {
                                iGun.setDummyAmmoAmount(itemStack, (int)random.nextDouble((Double)CommonConfig.GUARD_TACZ_GUN_MIN_AMMO.get(), (Double)CommonConfig.GUARD_TACZ_GUN_MAX_AMMO.get()));
                            } else {
                                iGun.setDummyAmmoAmount(itemStack, (int)(random.nextDouble((Double)CommonConfig.GUARD_TACZ_GUN_MIN_AMMO.get(), (Double)CommonConfig.GUARD_TACZ_GUN_MAX_AMMO.get()) * (double)maxAmmoCount));
                            }
                        }
                        mob.m_21008_(InteractionHand.MAIN_HAND, itemStack);
                        return true;
                    }).orElse(false);
                }
                weight -= entry.getValue().doubleValue();
            }
        }
        return false;
    }

    static {
        GUN_SWITCH = Maps.newHashMap();
        GUN_INACCURACY = Maps.newHashMap();
        SPAWN_GUN = Maps.newHashMap();
        totalWeight = 0.0;
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tacz:modern_kinetic_gun"));
        SHOTGUN = new ItemStack((ItemLike)item);
        ASSAULT_RIFLE = new ItemStack((ItemLike)item);
        PISTOL = new ItemStack((ItemLike)item);
        SNIPERS_RIFLE = new ItemStack((ItemLike)item);
        BAZOOKA = new ItemStack((ItemLike)item);
        if (item instanceof IGun) {
            IGun gun = (IGun)item;
            gun.setGunId(PISTOL, new ResourceLocation("tacz:m1911"));
            gun.setGunId(SHOTGUN, new ResourceLocation("tacz:m870"));
            gun.setGunId(ASSAULT_RIFLE, new ResourceLocation("tacz:ak47"));
            gun.setGunId(SNIPERS_RIFLE, new ResourceLocation("tacz:ai_awp"));
            gun.setGunId(BAZOOKA, new ResourceLocation("tacz:rpg7"));
        }
        GUN_SWITCH.put((Item)PillagersGunItems.SHOTGUN.get(), SHOTGUN);
        GUN_SWITCH.put((Item)PillagersGunItems.ASSAULT_RIFLE.get(), ASSAULT_RIFLE);
        GUN_SWITCH.put((Item)PillagersGunItems.PISTOL.get(), PISTOL);
        GUN_SWITCH.put((Item)PillagersGunItems.SNIPERS_RIFLE.get(), SNIPERS_RIFLE);
        GUN_SWITCH.put((Item)PillagersGunItems.BAZOOKA.get(), BAZOOKA);
    }
}

