/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v1;

import fuzs.puzzleslib.api.init.v2.RegistryReference;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatType;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.data.event.GatherDataEvent;

public abstract class AbstractLanguageProvider
extends LanguageProvider {
    protected final String modId;

    public AbstractLanguageProvider(GatherDataEvent evt, String modId) {
        this(evt.getGenerator().getPackOutput(), modId);
    }

    public AbstractLanguageProvider(PackOutput packOutput, String modId) {
        super(packOutput, modId, "en_us");
        this.modId = modId;
    }

    protected abstract void addTranslations();

    public void addCreativeModeTab(String value) {
        this.addCreativeModeTab("main", value);
    }

    public void addCreativeModeTab(String tabId, String value) {
        this.addCreativeModeTab(new ResourceLocation(this.modId, tabId), value);
    }

    public void addCreativeModeTab(ResourceLocation identifier, String value) {
        this.addCreativeModeTab((ResourceKey<CreativeModeTab>)ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)identifier), value);
    }

    public void addCreativeModeTab(ResourceKey<CreativeModeTab> resourceKey, String value) {
        this.add((CreativeModeTab)BuiltInRegistries.f_279662_.m_6246_(resourceKey), value);
    }

    public void add(CreativeModeTab tab, String value) {
        Objects.requireNonNull(tab, "tab is null");
        ComponentContents componentContents = tab.m_40786_().m_214077_();
        if (!(componentContents instanceof TranslatableContents)) {
            throw new UnsupportedOperationException("Cannot add language entry for tab %s".formatted(tab.m_40786_().getString()));
        }
        TranslatableContents contents = (TranslatableContents)componentContents;
        this.add(contents.m_237508_(), value);
    }

    public void add(Attribute attribute, String value) {
        this.add(attribute.m_22087_(), value);
    }

    public void add(StatType<?> statType, String value) {
        this.add(statType.m_12904_(), value);
    }

    public void add(Potion potion, String value) {
        String potionName = potion.m_43492_("");
        this.add("item.minecraft.tipped_arrow.effect." + potionName, "Arrow of " + value);
        this.add("item.minecraft.potion.effect." + potionName, "Potion of " + value);
        this.add("item.minecraft.splash_potion.effect." + potionName, "Splash Potion of " + value);
        this.add("item.minecraft.lingering_potion.effect." + potionName, "Lingering Potion of " + value);
    }

    public void add(SoundEvent soundEvent, String value) {
        this.add("subtitles." + soundEvent.m_11660_().m_135815_(), value);
    }

    public void add(KeyMapping keyMapping, String value) {
        this.add(keyMapping.m_90860_(), value);
    }

    public void add(ResourceLocation identifier, String value) {
        this.add(identifier.m_214298_(), value);
    }

    public void add(GameRules.Key<?> gameRule, String value) {
        this.add(gameRule.m_46331_(), value);
    }

    public void addGameRuleDescription(GameRules.Key<?> gameRule, String value) {
        this.add(gameRule.m_46331_() + ".description", value);
    }

    @Deprecated(forRemoval=true)
    public void addAdditional(Block block, String key, String value) {
        this.add(block.m_7705_() + "." + key, value);
    }

    public void add(Block block, String additionalKey, String value) {
        this.add(block.m_7705_() + "." + additionalKey, value);
    }

    @Deprecated(forRemoval=true)
    public void addAdditional(Item item, String key, String value) {
        this.add(item.m_5524_() + "." + key, value);
    }

    public void add(Item item, String additionalKey, String value) {
        this.add(item.m_5524_() + "." + additionalKey, value);
    }

    @Deprecated(forRemoval=true)
    public void addAdditional(Enchantment enchantment, String key, String value) {
        this.add(enchantment.m_44704_() + "." + key, value);
    }

    public void add(Enchantment enchantment, String additionalKey, String value) {
        this.add(enchantment.m_44704_() + "." + additionalKey, value);
    }

    @Deprecated(forRemoval=true)
    public void addAdditional(MobEffect mobEffect, String key, String value) {
        this.add(mobEffect.m_19481_() + "." + key, value);
    }

    public void add(MobEffect mobEffect, String additionalKey, String value) {
        this.add(mobEffect.m_19481_() + "." + additionalKey, value);
    }

    @Deprecated(forRemoval=true)
    public void addAdditional(EntityType<?> entityType, String key, String value) {
        this.add(entityType.m_20675_() + "." + key, value);
    }

    public void add(EntityType<?> entityType, String additionalKey, String value) {
        this.add(entityType.m_20675_() + "." + additionalKey, value);
    }

    public void add(Attribute attribute, String additionalKey, String value) {
        this.add(attribute.m_22087_() + "." + additionalKey, value);
    }

    public void add(StatType<?> statType, String additionalKey, String value) {
        this.add(statType.m_12904_() + "." + additionalKey, value);
    }

    public void add(String key, String additionalKey, String value) {
        this.add(key + "." + additionalKey, value);
    }

    public void add(ResourceLocation identifier, String additionalKey, String value) {
        this.add(identifier.m_214298_() + "." + additionalKey, value);
    }

    @Deprecated(forRemoval=true)
    public void addDamageSource(String damageSource, String value) {
        this.add("death.attack." + damageSource, value);
    }

    @Deprecated(forRemoval=true)
    public void addDamageType(ResourceKey<DamageType> damageType, String value) {
        this.addGenericDamageType(damageType, value);
    }

    public void addGenericDamageType(ResourceKey<DamageType> damageType, String value) {
        this.add("death.attack." + damageType.m_135782_().m_135815_(), value);
    }

    public void addPlayerDamageType(ResourceKey<DamageType> damageType, String value) {
        this.add("death.attack." + damageType.m_135782_().m_135815_() + ".player", value);
    }

    public void addItemDamageType(ResourceKey<DamageType> damageType, String value) {
        this.add("death.attack." + damageType.m_135782_().m_135815_() + ".item", value);
    }

    public void add(String registry, RegistryReference<?> registryReference, String value) {
        this.add(registry, registryReference.getResourceLocation(), value);
    }

    public void add(String registry, ResourceKey<?> resourceKey, String value) {
        this.add(registry, resourceKey.m_135782_(), value);
    }

    public void add(String registry, ResourceLocation resourceLocation, String value) {
        this.add(Util.m_137492_((String)registry, (ResourceLocation)resourceLocation), value);
    }
}

