/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.network.v3;

import com.google.common.base.Preconditions;
import java.util.Objects;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public interface PlayerSet {
    public void broadcast(Packet<?> var1);

    public static PlayerSet ofNone() {
        return packet -> {};
    }

    public static PlayerSet ofEntity(Entity entity) {
        PlayerSet playerSet;
        Objects.requireNonNull(entity, "entity is null");
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            playerSet = PlayerSet.ofPlayer(serverPlayer);
        } else {
            playerSet = PlayerSet.ofNone();
        }
        return playerSet;
    }

    public static PlayerSet ofPlayer(ServerPlayer serverPlayer) {
        Objects.requireNonNull(serverPlayer, "server player is null");
        return packet -> serverPlayer.f_8906_.m_9829_(packet);
    }

    public static PlayerSet ofOthers(ServerPlayer serverPlayer) {
        Objects.requireNonNull(serverPlayer, "server player is null");
        return packet -> serverPlayer.m_20194_().m_6846_().m_11314_().forEach(currentServerPlayer -> {
            if (currentServerPlayer != serverPlayer) {
                PlayerSet.ofPlayer(currentServerPlayer).broadcast(packet);
            }
        });
    }

    public static PlayerSet ofAll(MinecraftServer minecraftServer) {
        return packet -> minecraftServer.m_6846_().m_11314_().forEach(serverPlayer -> PlayerSet.ofPlayer(serverPlayer).broadcast(packet));
    }

    public static PlayerSet inLevel(ServerLevel serverLevel) {
        Objects.requireNonNull(serverLevel, "server level is null");
        return packet -> {
            for (ServerPlayer serverPlayer : serverLevel.m_6907_()) {
                PlayerSet.ofPlayer(serverPlayer).broadcast(packet);
            }
        };
    }

    public static PlayerSet nearPosition(Vec3i position, ServerLevel serverLevel) {
        Objects.requireNonNull(position, "position is null");
        return PlayerSet.nearPosition(position.m_123341_(), position.m_123342_(), position.m_123343_(), serverLevel);
    }

    public static PlayerSet nearPosition(double posX, double posY, double posZ, ServerLevel serverLevel) {
        return PlayerSet.nearPosition(null, posX, posY, posZ, 64.0, serverLevel);
    }

    public static PlayerSet nearPosition(@Nullable ServerPlayer serverPlayer, double posX, double posY, double posZ, double distance, ServerLevel serverLevel) {
        Objects.requireNonNull(serverLevel, "server level is null");
        return packet -> serverLevel.m_7654_().m_6846_().m_11241_((Player)serverPlayer, posX, posY, posZ, distance, serverLevel.m_46472_(), packet);
    }

    public static PlayerSet nearBlockEntity(BlockEntity blockEntity) {
        Objects.requireNonNull(blockEntity, "block entity is null");
        Level level = blockEntity.m_58904_();
        Objects.requireNonNull(level, "block entity level is null");
        Preconditions.checkState((!level.f_46443_ ? 1 : 0) != 0, (Object)"block entity level is client level");
        return PlayerSet.nearPosition((Vec3i)blockEntity.m_58899_(), (ServerLevel)level);
    }

    public static PlayerSet nearChunk(LevelChunk levelChunk) {
        Objects.requireNonNull(levelChunk, "chunk is null");
        Preconditions.checkState((!levelChunk.m_62953_().f_46443_ ? 1 : 0) != 0, (Object)"chunk level is client level");
        return PlayerSet.nearChunk((ServerLevel)levelChunk.m_62953_(), levelChunk.m_7697_());
    }

    public static PlayerSet nearChunk(ServerLevel serverLevel, ChunkPos chunkPos) {
        Objects.requireNonNull(serverLevel, "server level is null");
        Objects.requireNonNull(chunkPos, "chunk pos is null");
        return packet -> serverLevel.m_7726_().f_8325_.m_183262_(chunkPos, false).forEach(serverPlayer -> PlayerSet.ofPlayer(serverPlayer).broadcast(packet));
    }

    public static PlayerSet nearEntity(Entity entity) {
        Objects.requireNonNull(entity, "entity is null");
        Preconditions.checkState((!entity.m_20193_().f_46443_ ? 1 : 0) != 0, (Object)"entity level is client level");
        return packet -> ((ServerLevel)entity.m_20193_()).m_7726_().m_8394_(entity, packet);
    }

    public static PlayerSet nearPlayer(ServerPlayer serverPlayer) {
        Objects.requireNonNull(serverPlayer, "server player is null");
        return packet -> serverPlayer.m_284548_().m_7726_().m_8445_((Entity)serverPlayer, packet);
    }
}

