/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.block;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.content.building.block.be.VariantTrappedChestBlockEntity;
import org.violetmoon.quark.content.building.module.VariantChestsModule;
import org.violetmoon.zeta.block.IZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.BooleanSuppliers;

public class VariantTrappedChestBlock
extends ChestBlock
implements IZetaBlock,
VariantChestsModule.IVariantChest {
    @Nullable
    private final ZetaModule module;
    private BooleanSupplier enabledSupplier = BooleanSuppliers.TRUE;
    protected final String type;

    public VariantTrappedChestBlock(String prefix, String type, @Nullable ZetaModule module, Supplier<BlockEntityType<? extends ChestBlockEntity>> supplier, BlockBehaviour.Properties props) {
        super(props, supplier);
        this.module = module;
        this.type = type;
        if (module == null) {
            return;
        }
        String resloc = (String)(prefix != null ? prefix + "_" : "") + type + "_trapped_chest";
        module.zeta().registry.registerBlock((Block)this, resloc, true);
    }

    public VariantTrappedChestBlock(String type, ZetaModule module, Supplier<BlockEntityType<? extends ChestBlockEntity>> supplier, BlockBehaviour.Properties props) {
        this(null, type, module, supplier, props);
    }

    public int getFlammabilityZeta(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 0;
    }

    public boolean isFlammableZeta(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return false;
    }

    public VariantTrappedChestBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    @Nullable
    public ZetaModule getModule() {
        return this.module;
    }

    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new VariantTrappedChestBlockEntity(pos, state);
    }

    @Override
    public String getTexturePath() {
        return this.type;
    }

    @NotNull
    protected Stat<ResourceLocation> m_7699_() {
        return Stats.f_12988_.m_12902_((Object)Stats.f_12962_);
    }

    public boolean m_7899_(@NotNull BlockState state) {
        return true;
    }

    public int m_6378_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull Direction side) {
        return Mth.m_14045_((int)ChestBlockEntity.m_59086_((BlockGetter)world, (BlockPos)pos), (int)0, (int)15);
    }

    public int m_6376_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull Direction side) {
        return side == Direction.UP ? state.m_60746_(world, pos, side) : 0;
    }
}

