/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;

public class RepeatingBehaviour<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    protected final ExtendedBehaviour<E> child;
    protected Predicate<E> shouldRepeat = entity -> true;
    protected ToIntFunction<E> repeatCountProvider = entity -> Integer.MAX_VALUE;
    protected int repeats;

    public RepeatingBehaviour(ExtendedBehaviour<E> child) {
        this.child = child;
        this.noTimeout();
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return this.child.getMemoryRequirements();
    }

    public RepeatingBehaviour<E> repeatingWhen(Predicate<E> predicate) {
        this.shouldRepeat = predicate;
        return this;
    }

    public RepeatingBehaviour<E> repeatNTimes(int repeats) {
        return this.repeatNTimes(entity -> repeats);
    }

    public RepeatingBehaviour<E> repeatNTimes(ToIntFunction<E> function) {
        this.repeatCountProvider = function;
        return this;
    }

    @Override
    protected boolean doStartCheck(ServerLevel level, E entity, long gameTime) {
        return super.doStartCheck(level, entity, gameTime) && this.child.m_22554_(level, entity, gameTime);
    }

    @Override
    protected void m_6735_(ServerLevel level, E entity, long gameTime) {
        super.m_6735_(level, entity, gameTime);
        this.repeats = this.repeatCountProvider.applyAsInt(entity);
    }

    @Override
    protected boolean m_6737_(ServerLevel level, E entity, long gameTime) {
        return this.child.m_22536_() != Behavior.Status.STOPPED || this.repeats > 0;
    }

    @Override
    protected void m_6725_(ServerLevel level, E entity, long gameTime) {
        super.m_6725_(level, entity, gameTime);
        if (this.child.m_22536_() != Behavior.Status.STOPPED) {
            this.child.m_22558_(level, (LivingEntity)entity, gameTime);
            return;
        }
        if (this.repeats > 0 && this.shouldRepeat.test(entity) && this.child.m_22554_(level, entity, gameTime)) {
            --this.repeats;
        }
    }

    @Override
    protected void m_6732_(ServerLevel level, E entity, long gameTime) {
        super.m_6732_(level, entity, gameTime);
        if (this.child.m_22536_() != Behavior.Status.STOPPED) {
            this.child.m_22562_(level, (LivingEntity)entity, gameTime);
        }
    }
}

