/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;

public class WormholeTravelCriterion
extends SimpleCriterionTrigger<WormholeTravelTrigger> {
    public static final WormholeTravelCriterion INSTANCE = new WormholeTravelCriterion();
    private static final ResourceLocation CRITERION_ID = new ResourceLocation("sgjourney", "stargate_wormhole_travel");

    protected WormholeTravelTrigger createInstance(JsonObject obj, ContextAwarePredicate playerPredicate, DeserializationContext predicateDeserializer) {
        Optional<ResourceLocation> initialDimension = Optional.empty();
        Optional<ResourceLocation> destinationDimension = Optional.empty();
        Optional<Long> distanceTraveled = Optional.empty();
        if (GsonHelper.m_13813_((JsonObject)obj, (String)"from")) {
            initialDimension = Optional.of(ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)obj, (String)"from")));
        }
        if (GsonHelper.m_13813_((JsonObject)obj, (String)"to")) {
            destinationDimension = Optional.of(ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)obj, (String)"to")));
        }
        if (GsonHelper.m_144762_((JsonObject)obj, (String)"distance")) {
            distanceTraveled = Optional.of(GsonHelper.m_13921_((JsonObject)obj, (String)"distance"));
        }
        return new WormholeTravelTrigger(playerPredicate, initialDimension, destinationDimension, distanceTraveled);
    }

    public void trigger(ServerPlayer player, ResourceLocation initialDimension, ResourceLocation destinationDimension, long distanceTraveled) {
        this.m_66234_(player, trigger -> trigger.matches(initialDimension, destinationDimension, distanceTraveled));
    }

    public ResourceLocation m_7295_() {
        return CRITERION_ID;
    }

    public static class WormholeTravelTrigger
    extends AbstractCriterionTriggerInstance {
        private final Optional<ResourceLocation> initialDimension;
        private final Optional<ResourceLocation> destinationDimension;
        private final Optional<Long> distanceTraveled;

        public WormholeTravelTrigger(ContextAwarePredicate entity, Optional<ResourceLocation> initialDimension, Optional<ResourceLocation> destinationDimension, Optional<Long> distanceTraveled) {
            super(CRITERION_ID, entity);
            this.initialDimension = initialDimension;
            this.destinationDimension = destinationDimension;
            this.distanceTraveled = distanceTraveled;
        }

        public boolean matches(ResourceLocation initialDimension, ResourceLocation destinationDimension, long distanceTraveled) {
            if (this.initialDimension.isPresent() && !Objects.equals(this.initialDimension.get(), initialDimension)) {
                return false;
            }
            if (this.destinationDimension.isPresent() && !Objects.equals(this.destinationDimension.get(), destinationDimension)) {
                return false;
            }
            return !this.distanceTraveled.isPresent() || this.distanceTraveled.get() <= distanceTraveled;
        }

        public JsonObject m_7683_(SerializationContext predicateSerializer) {
            JsonObject jsonObject = super.m_7683_(predicateSerializer);
            if (this.initialDimension.isPresent()) {
                jsonObject.add("from", (JsonElement)new JsonPrimitive(this.initialDimension.get().toString()));
            }
            if (this.destinationDimension.isPresent()) {
                jsonObject.add("to", (JsonElement)new JsonPrimitive(this.destinationDimension.get().toString()));
            }
            if (this.distanceTraveled.isPresent()) {
                jsonObject.add("distance", (JsonElement)new JsonPrimitive((Number)this.distanceTraveled.get()));
            }
            return jsonObject;
        }
    }
}

