/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.packets.ClientboundSymbolUpdatePacket;
import org.jetbrains.annotations.NotNull;

public abstract class SymbolBlockEntity
extends BlockEntity {
    public static final String SYMBOL = "Symbol";
    public static final String SYMBOLS = "Symbols";
    public static final String SYMBOL_NUMBER = "SymbolNumber";
    public static final ResourceLocation EMPTY = StargateJourney.EMPTY_LOCATION;
    public int symbolNumber = 0;
    public ResourceLocation pointOfOrigin = EMPTY;
    public ResourceLocation symbols = EMPTY;

    public SymbolBlockEntity(BlockEntityType<?> entity, BlockPos pos, BlockState state) {
        super(entity, pos, state);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (this.pointOfOrigin.equals((Object)EMPTY)) {
            this.setPointOfOrigin(this.f_58857_);
        }
        if (this.symbols.equals((Object)EMPTY)) {
            this.setSymbols(this.f_58857_);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(SYMBOL_NUMBER)) {
            this.symbolNumber = tag.m_128451_(SYMBOL_NUMBER);
        }
        if (tag.m_128441_(SYMBOL)) {
            this.pointOfOrigin = new ResourceLocation(tag.m_128461_(SYMBOL));
        }
        if (tag.m_128441_(SYMBOLS)) {
            this.symbols = new ResourceLocation(tag.m_128461_(SYMBOLS));
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128405_(SYMBOL_NUMBER, this.symbolNumber);
        if (this.pointOfOrigin != null) {
            tag.m_128359_(SYMBOL, this.pointOfOrigin.toString());
        }
        if (this.symbols != null) {
            tag.m_128359_(SYMBOLS, this.symbols.toString());
        }
        super.m_183515_(tag);
    }

    public int getSymbolNumber() {
        return this.symbolNumber;
    }

    public void setPointOfOrigin(Level level) {
        if (level.m_5776_()) {
            return;
        }
        this.pointOfOrigin = Universe.get(level).getPointOfOrigin((ResourceKey<Level>)level.m_46472_()).m_135782_();
    }

    public ResourceLocation getPointOfOrigin() {
        return this.pointOfOrigin;
    }

    public void setSymbols(Level level) {
        if (level.m_5776_()) {
            return;
        }
        this.symbols = Universe.get(level).getSymbols((ResourceKey<Level>)level.m_46472_()).m_135782_();
    }

    public ResourceLocation getSymbols() {
        return this.symbols;
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(this.f_58858_)), (Object)new ClientboundSymbolUpdatePacket(this.f_58858_, this.symbolNumber, this.pointOfOrigin, this.symbols));
    }

    public static class RedSandstone
    extends SymbolBlockEntity {
        public RedSandstone(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.RED_SANDSTONE_SYMBOL.get(), pos, state);
        }
    }

    public static class Sandstone
    extends SymbolBlockEntity {
        public Sandstone(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.SANDSTONE_SYMBOL.get(), pos, state);
        }
    }

    public static class Stone
    extends SymbolBlockEntity {
        public Stone(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.STONE_SYMBOL.get(), pos, state);
        }
    }
}

