/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.stargate;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.RotatingStargateEntity;
import net.povstalec.sgjourney.common.compatibility.cctweaked.CCTweakedCompatibility;
import net.povstalec.sgjourney.common.compatibility.cctweaked.StargatePeripheralWrapper;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.packets.ClientBoundSoundPackets;
import net.povstalec.sgjourney.common.packets.ClientboundMilkyWayStargateUpdatePacket;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import net.povstalec.sgjourney.common.sgjourney.Symbols;

public class MilkyWayStargateEntity
extends RotatingStargateEntity {
    public static final int MAX_ROTATION = 156;
    public static final int TOTAL_SYMBOLS = 39;
    public static final int RING_SEGMENTS = 3;
    public static final int SYMBOLS_PER_SEGMENT = 13;
    public static final StargateInfo.ChevronLockSpeed CHEVRON_LOCK_SPEED = (StargateInfo.ChevronLockSpeed)((Object)CommonStargateConfig.milky_way_chevron_lock_speed.get());
    private final ResourceLocation backVariant = new ResourceLocation("sgjourney", "milky_way/milky_way_back_chevron");
    public boolean isChevronOpen = false;

    public MilkyWayStargateEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.MILKY_WAY_STARGATE.get(), new ResourceLocation("sgjourney", "milky_way/milky_way"), pos, state, 39, StargateInfo.Gen.GEN_2, 2, 156);
    }

    @Override
    public CompoundTag serializeStargateInfo(CompoundTag tag) {
        super.serializeStargateInfo(tag);
        tag.m_128359_("PointOfOrigin", this.symbolInfo().pointOfOrigin().toString());
        tag.m_128359_("Symbols", this.symbolInfo().symbols().toString());
        return tag;
    }

    @Override
    public void deserializeStargateInfo(CompoundTag tag, boolean isUpgraded) {
        if (tag.m_128441_("PointOfOrigin")) {
            this.symbolInfo().setPointOfOrigin(new ResourceLocation(tag.m_128461_("PointOfOrigin")));
        }
        if (tag.m_128441_("Symbols")) {
            this.symbolInfo().setSymbols(new ResourceLocation(tag.m_128461_("Symbols")));
        }
        super.deserializeStargateInfo(tag, isUpgraded);
    }

    @Override
    public ResourceLocation defaultVariant() {
        return ClientStargateConfig.milky_way_stargate_back_lights_up.get() ? this.backVariant : super.defaultVariant();
    }

    @Override
    public StargateInfo.Feedback resetStargate(StargateInfo.Feedback feedback, boolean updateInterfaces) {
        if (this.isChevronOpen) {
            this.isChevronOpen = false;
            this.chevronSound(this.getCurrentChevron(), false, false, false);
        }
        return super.resetStargate(feedback, updateInterfaces);
    }

    private short getCurrentChevron() {
        if (this.getCurrentSymbol() == 0) {
            return 0;
        }
        if (this.getAddress().getLength() > 0 && this.getCurrentSymbol() == this.getAddress().getSymbol(this.getAddress().getLength() - 1)) {
            return (short)this.getAddress().getLength();
        }
        return (short)(this.getAddress().getLength() + 1);
    }

    public boolean isChevronOpen() {
        return this.isChevronOpen;
    }

    @Override
    public StargateInfo.Feedback encodeChevron() {
        int symbol;
        if (!this.isChevronOpen()) {
            return this.setRecentFeedback(StargateInfo.Feedback.CHEVRON_NOT_OPEN);
        }
        if (!this.f_58857_.m_5776_()) {
            this.synchronizeWithClient();
        }
        if ((symbol = this.getCurrentSymbol()) == 0) {
            return this.setRecentFeedback(StargateInfo.Feedback.CANNOT_ENCODE_POINT_OF_ORIGIN);
        }
        return this.setRecentFeedback(this.encodeChevron(symbol, false, true));
    }

    public StargateInfo.Feedback openChevron() {
        if (!this.isChevronOpen) {
            if (!this.getAddress().containsSymbol(this.getCurrentSymbol())) {
                if (!this.f_58857_.m_5776_()) {
                    PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.Chevron(this.f_58858_, this.getCurrentChevron(), false, true, false));
                }
                this.isChevronOpen = true;
                if (!this.f_58857_.m_5776_()) {
                    this.synchronizeWithClient();
                }
                return this.setRecentFeedback(StargateInfo.Feedback.CHEVRON_RAISED);
            }
            return this.setRecentFeedback(StargateInfo.Feedback.SYMBOL_IN_ADDRESS);
        }
        return this.setRecentFeedback(StargateInfo.Feedback.CHEVRON_ALREADY_OPENED);
    }

    public StargateInfo.Feedback closeChevron() {
        if (this.isChevronOpen) {
            this.isChevronOpen = false;
            StargateInfo.Feedback feedback = this.engageSymbol(this.getCurrentSymbol());
            if (feedback == StargateInfo.Feedback.SYMBOL_IN_ADDRESS) {
                this.chevronSound(this.getCurrentChevron(), false, false, false);
            }
            return this.setRecentFeedback(feedback);
        }
        if (!this.f_58857_.m_5776_()) {
            this.synchronizeWithClient();
        }
        return this.setRecentFeedback(StargateInfo.Feedback.CHEVRON_ALREADY_CLOSED);
    }

    @Override
    protected void rotate() {
        if (!this.isConnected() && !this.isChevronOpen) {
            if (this.rotating) {
                this.rotateToTarget();
            } else if (this.signalStrength > 0 && this.signalStrength < 15) {
                if (this.signalStrength > 7) {
                    this.rotate(false);
                } else {
                    this.rotate(true);
                }
            } else {
                this.syncRotation();
            }
        } else {
            this.syncRotation();
        }
        this.m_6596_();
    }

    @Override
    public StargateInfo.Feedback startRotation(int desiredSymbol, boolean rotateClockwise) {
        if (this.isChevronOpen) {
            return StargateInfo.Feedback.ROTATION_BLOCKED;
        }
        return super.startRotation(desiredSymbol, rotateClockwise);
    }

    @Override
    protected void manualDialing() {
        if (this.signalStrength > 0) {
            if (this.signalStrength == 15 && (this.getCurrentSymbol() != 0 || this.getAddress().getLength() > 0)) {
                if (!this.isConnected()) {
                    this.openChevron();
                } else {
                    this.disconnectStargate(StargateInfo.Feedback.CONNECTION_ENDED_BY_POINT_OF_ORIGIN, true);
                }
            }
        } else if (this.signalStrength == 0 && this.previousSignalStrength == 15) {
            this.closeChevron();
        }
        if (!this.f_58857_.m_5776_()) {
            this.synchronizeWithClient();
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MilkyWayStargateEntity stargate) {
        RotatingStargateEntity.tick(level, pos, state, stargate);
    }

    @Override
    public boolean synchronizeWithClient() {
        if (!super.synchronizeWithClient()) {
            return false;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundMilkyWayStargateUpdatePacket(this.f_58858_, this.isChevronOpen));
        return true;
    }

    @Override
    public StargateInfo.ChevronLockSpeed getChevronLockSpeed() {
        return CHEVRON_LOCK_SPEED;
    }

    @Override
    public void registerInterfaceMethods(StargatePeripheralWrapper wrapper) {
        CCTweakedCompatibility.registerMilkyWayStargateMethods(wrapper);
    }

    @Override
    public void generate() {
        super.generate();
        Random random = new Random();
        this.setRotation(2 * random.nextInt(0, 79));
    }

    @Override
    public void generateAdditional(StructureGenEntity.Step generationStep) {
        if (generationStep == StructureGenEntity.Step.SETUP) {
            if (!PointOfOrigin.validLocation(this.f_58857_.m_7654_(), this.symbolInfo().pointOfOrigin())) {
                this.symbolInfo().setPointOfOrigin(StargateJourney.EMPTY_LOCATION);
            }
            if (!Symbols.validLocation(this.f_58857_.m_7654_(), this.symbolInfo().symbols())) {
                this.symbolInfo().setSymbols(StargateJourney.EMPTY_LOCATION);
            }
        } else {
            if (!PointOfOrigin.validLocation(this.f_58857_.m_7654_(), this.symbolInfo().pointOfOrigin())) {
                if (this.localPointOfOrigin) {
                    this.symbolInfo().setPointOfOrigin(PointOfOrigin.fromDimension(this.f_58857_.m_7654_(), (ResourceKey<Level>)this.f_58857_.m_46472_()));
                } else {
                    this.symbolInfo().setPointOfOrigin(PointOfOrigin.randomPointOfOrigin(this.f_58857_.m_7654_(), (ResourceKey<Level>)this.f_58857_.m_46472_()));
                }
            }
            if (!Symbols.validLocation(this.f_58857_.m_7654_(), this.symbolInfo().symbols())) {
                this.symbolInfo().setSymbols(Symbols.fromDimension(this.f_58857_.m_7654_(), (ResourceKey<Level>)this.f_58857_.m_46472_()));
            }
        }
    }
}

