/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.tech;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.povstalec.sgjourney.common.block_entities.tech.CableBlockEntity;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.config.CommonCableConfig;
import net.povstalec.sgjourney.common.data.ConduitNetworks;

public abstract class CableBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<ConnectorType> NORTH = EnumProperty.m_61587_((String)"north", ConnectorType.class);
    public static final EnumProperty<ConnectorType> EAST = EnumProperty.m_61587_((String)"east", ConnectorType.class);
    public static final EnumProperty<ConnectorType> SOUTH = EnumProperty.m_61587_((String)"south", ConnectorType.class);
    public static final EnumProperty<ConnectorType> WEST = EnumProperty.m_61587_((String)"west", ConnectorType.class);
    public static final EnumProperty<ConnectorType> UP = EnumProperty.m_61587_((String)"up", ConnectorType.class);
    public static final EnumProperty<ConnectorType> DOWN = EnumProperty.m_61587_((String)"down", ConnectorType.class);
    public final VoxelShape[] shapeCache;

    public CableBlock(BlockBehaviour.Properties properties, double thickness) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapeCache = this.buildShapeCache(thickness);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> state) {
        state.m_61104_(new Property[]{WATERLOGGED, NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        state = this.calculateState((LevelAccessor)level, pos, state);
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CableBlockEntity) {
            CableBlockEntity cable = (CableBlockEntity)blockEntity;
            if (!this.isEdge(state)) {
                level.m_46747_(pos);
                cable.m_7651_();
                level.m_7731_(pos, state, 3);
                return;
            }
            BlockState otherState = level.m_8055_(fromPos);
            if (otherState.m_60734_() instanceof LightningRodBlock && ((Boolean)otherState.m_61143_((Property)LightningRodBlock.f_153703_)).booleanValue()) {
                cable.transferEnergy((Long)CommonCableConfig.lightning_strike_energy.get(), false, false);
            }
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        return (BlockState)this.calculateState((LevelAccessor)level, pos, this.m_49966_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.m_6402_(level, pos, state, entity, stack);
        this.updateCable(level, pos);
        BlockState blockState = this.calculateState((LevelAccessor)level, pos, state);
        if (state != blockState) {
            level.m_46597_(pos, blockState);
        }
    }

    public void m_6810_(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (oldState.m_60734_() != newState.m_60734_()) {
            ConduitNetworks.get(level).removeCable(level, pos);
            super.m_6810_(oldState, level, pos, newState, isMoving);
        } else {
            super.m_6810_(oldState, level, pos, newState, isMoving);
            this.updateCable(level, pos);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        ConnectorType north = CableBlock.connectorType(state, NORTH);
        ConnectorType east = CableBlock.connectorType(state, EAST);
        ConnectorType south = CableBlock.connectorType(state, SOUTH);
        ConnectorType west = CableBlock.connectorType(state, WEST);
        ConnectorType up = CableBlock.connectorType(state, UP);
        ConnectorType down = CableBlock.connectorType(state, DOWN);
        return this.shapeCache[CableBlock.bitsFromConnectors(north, east, south, west, up, down)];
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor level, BlockPos current, BlockPos offset) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_183324_().m_183393_(new ScheduledTick((Object)Fluids.f_76193_, current, (long)Fluids.f_76193_.m_6718_((LevelReader)level), 0L));
        }
        return this.calculateState(level, current, state);
    }

    private void updateCable(Level level, BlockPos pos) {
        if (!level.m_5776_()) {
            ConduitNetworks.get(level).update(level, pos);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof CableBlockEntity) {
                CableBlockEntity cable = (CableBlockEntity)blockEntity;
                cable.update();
            }
        }
    }

    public static ConnectorType connectionTypeTo(BlockGetter getter, BlockPos pos, Direction direction) {
        BlockPos otherPos = pos.m_121945_(direction);
        BlockState state = getter.m_8055_(otherPos);
        Direction otherDirection = direction.m_122424_();
        if (state.m_60795_()) {
            return ConnectorType.NONE;
        }
        if (state.m_60734_() instanceof CableBlock) {
            return state.m_60734_() == getter.m_8055_(pos).m_60734_() ? ConnectorType.CABLE : ConnectorType.NONE;
        }
        BlockEntity blockEntity = getter.m_7702_(otherPos);
        if (blockEntity != null) {
            return blockEntity.getCapability(ForgeCapabilities.ENERGY, otherDirection).isPresent() ? ConnectorType.BLOCK : ConnectorType.NONE;
        }
        if (state.m_60734_() instanceof LightningRodBlock && state.m_61143_((Property)LightningRodBlock.f_52588_) == direction) {
            return ConnectorType.BLOCK;
        }
        return ConnectorType.NONE;
    }

    public static ConnectorType connectorType(BlockState state, EnumProperty<ConnectorType> property) {
        try {
            return (ConnectorType)((Object)state.m_61143_(property));
        }
        catch (IllegalArgumentException e) {
            return ConnectorType.NONE;
        }
    }

    public static ConnectorType connectionTypeSide(BlockGetter getter, BlockPos pos, Direction direction) {
        BlockState state = getter.m_8055_(pos);
        if (state.m_60795_()) {
            return ConnectorType.NONE;
        }
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> CableBlock.connectorType(state, NORTH);
            case Direction.EAST -> CableBlock.connectorType(state, EAST);
            case Direction.SOUTH -> CableBlock.connectorType(state, SOUTH);
            case Direction.WEST -> CableBlock.connectorType(state, WEST);
            case Direction.UP -> CableBlock.connectorType(state, UP);
            case Direction.DOWN -> CableBlock.connectorType(state, DOWN);
        };
    }

    protected BlockState calculateState(LevelAccessor level, BlockPos pos, BlockState state) {
        ConnectorType north = CableBlock.connectionTypeTo((BlockGetter)level, pos, Direction.NORTH);
        ConnectorType east = CableBlock.connectionTypeTo((BlockGetter)level, pos, Direction.EAST);
        ConnectorType south = CableBlock.connectionTypeTo((BlockGetter)level, pos, Direction.SOUTH);
        ConnectorType west = CableBlock.connectionTypeTo((BlockGetter)level, pos, Direction.WEST);
        ConnectorType up = CableBlock.connectionTypeTo((BlockGetter)level, pos, Direction.UP);
        ConnectorType down = CableBlock.connectionTypeTo((BlockGetter)level, pos, Direction.DOWN);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((Object)north))).m_61124_(SOUTH, (Comparable)((Object)south))).m_61124_(WEST, (Comparable)((Object)west))).m_61124_(EAST, (Comparable)((Object)east))).m_61124_(UP, (Comparable)((Object)up))).m_61124_(DOWN, (Comparable)((Object)down));
    }

    public VoxelShape[] buildShapeCache(double thickness) {
        VoxelShape[] shapes = new VoxelShape[64];
        for (byte i = 0; i < 64; i = (byte)(i + 1)) {
            shapes[i] = this.shapeFromBits(thickness, i);
        }
        return shapes;
    }

    public static VoxelShape centerShape(double thickness) {
        double sideSpace = (1.0 - thickness) / 2.0;
        return Shapes.m_83048_((double)sideSpace, (double)sideSpace, (double)sideSpace, (double)(sideSpace + thickness), (double)(sideSpace + thickness), (double)(sideSpace + thickness));
    }

    public static VoxelShape northShape(double thickness) {
        double sideSpace = (1.0 - thickness) / 2.0;
        return Shapes.m_83048_((double)sideSpace, (double)sideSpace, (double)0.0, (double)(sideSpace + thickness), (double)(sideSpace + thickness), (double)sideSpace);
    }

    public static VoxelShape southShape(double thickness) {
        double sideSpace = (1.0 - thickness) / 2.0;
        return Shapes.m_83048_((double)sideSpace, (double)sideSpace, (double)(sideSpace + thickness), (double)(sideSpace + thickness), (double)(sideSpace + thickness), (double)1.0);
    }

    public static VoxelShape westShape(double thickness) {
        double sideSpace = (1.0 - thickness) / 2.0;
        return Shapes.m_83048_((double)0.0, (double)sideSpace, (double)sideSpace, (double)sideSpace, (double)(sideSpace + thickness), (double)(sideSpace + thickness));
    }

    public static VoxelShape eastShape(double thickness) {
        double sideSpace = (1.0 - thickness) / 2.0;
        return Shapes.m_83048_((double)(sideSpace + thickness), (double)sideSpace, (double)sideSpace, (double)1.0, (double)(sideSpace + thickness), (double)(sideSpace + thickness));
    }

    public static VoxelShape upShape(double thickness) {
        double sideSpace = (1.0 - thickness) / 2.0;
        return Shapes.m_83048_((double)sideSpace, (double)(sideSpace + thickness), (double)sideSpace, (double)(sideSpace + thickness), (double)1.0, (double)(sideSpace + thickness));
    }

    public static VoxelShape downShape(double thickness) {
        double sideSpace = (1.0 - thickness) / 2.0;
        return Shapes.m_83048_((double)sideSpace, (double)0.0, (double)sideSpace, (double)(sideSpace + thickness), (double)sideSpace, (double)(sideSpace + thickness));
    }

    public VoxelShape shapeFromBits(double thickness, byte bits) {
        VoxelShape shape = CableBlock.centerShape(thickness);
        if ((1 & bits) != 0) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CableBlock.northShape(thickness));
        }
        if ((2 & bits) != 0) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CableBlock.eastShape(thickness));
        }
        if ((4 & bits) != 0) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CableBlock.southShape(thickness));
        }
        if ((8 & bits) != 0) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CableBlock.westShape(thickness));
        }
        if ((0x10 & bits) != 0) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CableBlock.upShape(thickness));
        }
        if ((0x20 & bits) != 0) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CableBlock.downShape(thickness));
        }
        return shape;
    }

    public static byte bitsFromConnectors(ConnectorType north, ConnectorType east, ConnectorType south, ConnectorType west, ConnectorType up, ConnectorType down) {
        byte bits = 0;
        if (north != ConnectorType.NONE) {
            bits = (byte)(bits | 1);
        }
        if (east != ConnectorType.NONE) {
            bits = (byte)(bits | 2);
        }
        if (south != ConnectorType.NONE) {
            bits = (byte)(bits | 4);
        }
        if (west != ConnectorType.NONE) {
            bits = (byte)(bits | 8);
        }
        if (up != ConnectorType.NONE) {
            bits = (byte)(bits | 0x10);
        }
        if (down != ConnectorType.NONE) {
            bits = (byte)(bits | 0x20);
        }
        return bits;
    }

    public boolean isEdge(BlockState state) {
        return CableBlock.connectorType(state, NORTH).isEdge() || CableBlock.connectorType(state, EAST).isEdge() || CableBlock.connectorType(state, SOUTH).isEdge() || CableBlock.connectorType(state, WEST).isEdge() || CableBlock.connectorType(state, UP).isEdge() || CableBlock.connectorType(state, DOWN).isEdge();
    }

    public abstract long energyTransfer();

    public abstract boolean transfersZeroPointEnergy();

    public void m_5871_(ItemStack stack, @Nullable BlockGetter getter, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (this.transfersZeroPointEnergy()) {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.cable.zpm_transfer").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        }
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.energy_transfer").m_7220_((Component)Component.m_237113_((String)(": " + SGJourneyEnergy.energyToString(this.energyTransfer()) + "/t"))).m_130940_(ChatFormatting.RED));
        super.m_5871_(stack, getter, tooltipComponents, isAdvanced);
    }

    public static enum ConnectorType implements StringRepresentable
    {
        BLOCK("block", true),
        CABLE("cable", false),
        NONE("none", false);

        private String name;
        private boolean isEdge;

        private ConnectorType(String name, boolean isEdge) {
            this.name = name;
            this.isEdge = isEdge;
        }

        public String m_7912_() {
            return this.name;
        }

        public boolean isEdge() {
            return this.isEdge;
        }
    }

    public static class LargeNaquadahCable
    extends CableBlock {
        public LargeNaquadahCable(BlockBehaviour.Properties properties) {
            super(properties, 0.5);
        }

        @Nullable
        public BlockEntity m_142194_(BlockPos pos, BlockState state) {
            return this.isEdge(state) ? new CableBlockEntity.LargeNaquadahCable(pos, state) : null;
        }

        @Override
        public long energyTransfer() {
            return (Long)CommonCableConfig.large_naquadah_cable_max_transfer.get();
        }

        @Override
        public boolean transfersZeroPointEnergy() {
            return (Boolean)CommonCableConfig.large_naquadah_cable_transfers_zero_point_energy.get();
        }
    }

    public static class MediumNaquadahCable
    extends CableBlock {
        public MediumNaquadahCable(BlockBehaviour.Properties properties) {
            super(properties, 0.375);
        }

        @Nullable
        public BlockEntity m_142194_(BlockPos pos, BlockState state) {
            return this.isEdge(state) ? new CableBlockEntity.MediumNaquadahCable(pos, state) : null;
        }

        @Override
        public long energyTransfer() {
            return (Long)CommonCableConfig.medium_naquadah_cable_max_transfer.get();
        }

        @Override
        public boolean transfersZeroPointEnergy() {
            return (Boolean)CommonCableConfig.medium_naquadah_cable_transfers_zero_point_energy.get();
        }
    }

    public static class SmallNaquadahCable
    extends CableBlock {
        public SmallNaquadahCable(BlockBehaviour.Properties properties) {
            super(properties, 0.25);
        }

        @Nullable
        public BlockEntity m_142194_(BlockPos pos, BlockState state) {
            return this.isEdge(state) ? new CableBlockEntity.SmallNaquadahCable(pos, state) : null;
        }

        @Override
        public long energyTransfer() {
            return (Long)CommonCableConfig.small_naquadah_cable_max_transfer.get();
        }

        @Override
        public boolean transfersZeroPointEnergy() {
            return (Boolean)CommonCableConfig.small_naquadah_cable_transfers_zero_point_energy.get();
        }
    }

    public static class NaquadahWire
    extends CableBlock {
        public final VoxelShape[] collisionShapeCache = this.buildShapeCache(0.125);

        public NaquadahWire(BlockBehaviour.Properties properties) {
            super(properties, 0.25);
        }

        @Nullable
        public BlockEntity m_142194_(BlockPos pos, BlockState state) {
            return this.isEdge(state) ? new CableBlockEntity.NaquadahWire(pos, state) : null;
        }

        public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
            ConnectorType north = NaquadahWire.connectorType(state, (EnumProperty<ConnectorType>)NORTH);
            ConnectorType east = NaquadahWire.connectorType(state, (EnumProperty<ConnectorType>)EAST);
            ConnectorType south = NaquadahWire.connectorType(state, (EnumProperty<ConnectorType>)SOUTH);
            ConnectorType west = NaquadahWire.connectorType(state, (EnumProperty<ConnectorType>)WEST);
            ConnectorType up = NaquadahWire.connectorType(state, (EnumProperty<ConnectorType>)UP);
            ConnectorType down = NaquadahWire.connectorType(state, (EnumProperty<ConnectorType>)DOWN);
            return this.collisionShapeCache[NaquadahWire.bitsFromConnectors(north, east, south, west, up, down)];
        }

        @Override
        public long energyTransfer() {
            return (Long)CommonCableConfig.naquadah_wire_max_transfer.get();
        }

        @Override
        public boolean transfersZeroPointEnergy() {
            return (Boolean)CommonCableConfig.naquadah_wire_transfers_zero_point_energy.get();
        }
    }
}

