/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.capabilities;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.povstalec.sgjourney.common.capabilities.ZeroPointEnergy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ZPMEnergyProvider
implements ICapabilityProvider {
    private static final String ENERGY = "Energy";
    private static final String ENTROPY = "Entropy";
    private ItemStack stack;
    private final ZeroPointEnergy ENERGY_STORAGE = new ZeroPointEnergy(1000, this.capacity(), this.maxReceive(), this.maxExtract()){

        @Override
        public long receiveLongEnergy(long maxReceive, boolean simulate) {
            ZPMEnergyProvider.this.loadEnergy();
            return super.receiveLongEnergy(maxReceive, simulate);
        }

        @Override
        public long extractLongEnergy(long maxExtract, boolean simulate) {
            ZPMEnergyProvider.this.loadEnergy();
            return super.extractLongEnergy(maxExtract, simulate);
        }

        @Override
        public long getTrueEnergyStored() {
            ZPMEnergyProvider.this.loadEnergy();
            return this.energy;
        }

        @Override
        public boolean canExtract() {
            return ZPMEnergyProvider.this.canExtractEnergy();
        }

        @Override
        public boolean canReceive() {
            return ZPMEnergyProvider.this.canReceiveEnergy();
        }

        @Override
        public void onEnergyChanged(long difference, boolean simulate) {
            ZPMEnergyProvider.this.energyChanged(difference, simulate);
        }
    };
    private LazyOptional<IEnergyStorage> lazyEnergyHandler = LazyOptional.of(() -> this.ENERGY_STORAGE);

    public ZPMEnergyProvider(ItemStack stack) {
        this.stack = stack;
    }

    public long capacity() {
        return ZPMEnergyProvider.getMaxEnergy();
    }

    public long maxReceive() {
        return 0L;
    }

    public long maxExtract() {
        return ZPMEnergyProvider.getMaxExtract();
    }

    public boolean canReceiveEnergy() {
        return false;
    }

    public boolean canExtractEnergy() {
        return true;
    }

    public void energyChanged(long difference, boolean simulate) {
        this.saveEnergy();
    }

    public long getEnergy() {
        return this.ENERGY_STORAGE.getTrueEnergyStored();
    }

    public static long getMaxEnergy() {
        return ZeroPointEnergy.ENERGY_PER_ENTROPY_LEVEL;
    }

    public static long getMaxExtract() {
        return ZeroPointEnergy.ENERGY_PER_ENTROPY_LEVEL;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyHandler.cast();
        }
        return LazyOptional.empty();
    }

    public void loadEnergy() {
        CompoundTag tag = this.stack.m_41784_();
        if (tag.m_128425_(ENERGY, 4)) {
            this.ENERGY_STORAGE.deserializeNBT(tag.m_128423_(ENERGY));
        }
        if (tag.m_128425_(ENTROPY, 3)) {
            this.ENERGY_STORAGE.deserializeEntropy(tag.m_128423_(ENTROPY));
        }
    }

    public void saveEnergy() {
        CompoundTag tag = this.stack.m_41784_();
        tag.m_128365_(ENERGY, this.ENERGY_STORAGE.serializeNBT());
        tag.m_128365_(ENTROPY, this.ENERGY_STORAGE.serializeEntropy());
        this.stack.m_41751_(tag);
    }
}

