/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.compatibility.cctweaked.peripherals;

import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.util.LazyOptional;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.tech.EnergyBlockEntity;
import net.povstalec.sgjourney.common.block_entities.tech_interface.AbstractInterfaceEntity;
import net.povstalec.sgjourney.common.compatibility.cctweaked.peripherals.InterfacePeripheral;
import net.povstalec.sgjourney.common.compatibility.cctweaked.peripherals.StargatePeripheral;

public class InterfacePeripheralWrapper {
    private AbstractInterfaceEntity interfaceEntity;
    private InterfacePeripheral interfacePeripheral;
    private LazyOptional<IPeripheral> peripheral;
    protected final List<IComputerAccess> computerList = new LinkedList<IComputerAccess>();

    public InterfacePeripheralWrapper(AbstractInterfaceEntity interfaceEntity) {
        this.interfaceEntity = interfaceEntity;
    }

    public static InterfacePeripheral createPeripheral(AbstractInterfaceEntity interfaceEntity, EnergyBlockEntity energyBlockEntity) {
        if (energyBlockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)energyBlockEntity;
            return new StargatePeripheral(interfaceEntity, stargate);
        }
        return new InterfacePeripheral(interfaceEntity);
    }

    public boolean resetInterface() {
        InterfacePeripheral newPeripheral = InterfacePeripheralWrapper.createPeripheral(this.interfaceEntity, this.interfaceEntity.findEnergyBlockEntity());
        if (this.interfacePeripheral != null && this.interfacePeripheral.equals((IPeripheral)newPeripheral)) {
            return false;
        }
        this.interfacePeripheral = newPeripheral;
        if (this.peripheral != null) {
            this.peripheral.invalidate();
            this.peripheral = LazyOptional.of(() -> newPeripheral);
        }
        return true;
    }

    public LazyOptional<IPeripheral> newPeripheral() {
        this.interfacePeripheral = InterfacePeripheralWrapper.createPeripheral(this.interfaceEntity, this.interfaceEntity.findEnergyBlockEntity());
        this.peripheral = LazyOptional.of(() -> this.interfacePeripheral);
        if (this.peripheral == null) {
            this.interfacePeripheral = InterfacePeripheralWrapper.createPeripheral(this.interfaceEntity, this.interfaceEntity.findEnergyBlockEntity());
            this.peripheral = LazyOptional.of(() -> this.interfacePeripheral);
        }
        return this.peripheral;
    }

    public void queueEvent(String eventName, Object ... objects) {
        InterfacePeripheral interfacePeripheral = this.interfacePeripheral;
        if (interfacePeripheral instanceof StargatePeripheral) {
            StargatePeripheral stargatePeripheral = (StargatePeripheral)interfacePeripheral;
            stargatePeripheral.queueEvent(eventName, objects);
        }
    }

    public InterfacePeripheral getPeripheral() {
        return this.interfacePeripheral;
    }
}

