/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.tech_interface.AbstractInterfaceEntity;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.data.BlockEntityList;
import net.povstalec.sgjourney.common.data.StargateNetwork;
import net.povstalec.sgjourney.common.events.custom.SGJourneyEvents;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.Dialing;
import net.povstalec.sgjourney.common.sgjourney.Galaxy;
import net.povstalec.sgjourney.common.sgjourney.SolarSystem;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import net.povstalec.sgjourney.common.sgjourney.stargate.Stargate;

public class StargateConnection {
    private static final String EVENT_CHEVRON_ENGAGED = "stargate_chevron_engaged";
    private static final String EVENT_INCOMING_CONNECTION = "stargate_incoming_connection";
    private static final String EVENT_INCOMING_WORMHOLE = "stargate_incoming_wormhole";
    private static final String EVENT_OUTGOING_WORMHOLE = "stargate_outgoing_wormhole";
    private static final String EVENT_DISCONNECTED = "stargate_disconnected";
    private static final String ADDRESS = "address";
    private static final String DIMENSION = "Dimension";
    private static final String COORDINATES = "Coordinates";
    private static final String DIALING_STARGATE = "DialingStargate";
    private static final String DIALED_STARGATE = "DialedStargate";
    private static final String USED = "Used";
    private static final String TIME_SINCE_LAST_TRAVELER = "TimeSinceLastTraveler";
    private static final String OPEN_TIME = "OpenTime";
    private static final String CONNECTION_TIME = "ConnectionTime";
    private static final String CONNECTION_TYPE = "ConnectionType";
    private static final String DO_KAWOOSH = "DoKawoosh";
    public static final int KAWOOSH_TICKS = 40;
    public static final int VORTEX_TICKS = 20;
    protected static final int maxOpenTime = (Integer)CommonStargateConfig.max_wormhole_open_time.get() * 20;
    protected static final boolean energyBypassEnabled = (Boolean)CommonStargateConfig.enable_energy_bypass.get();
    protected static final boolean requireEnergy = !StargateJourneyConfig.disable_energy_use.get();
    protected static final long systemWideConnectionCost = (Long)CommonStargateConfig.system_wide_connection_energy_cost.get();
    protected static final long systemWideConnectionDraw = (Long)CommonStargateConfig.system_wide_connection_energy_draw.get();
    protected static final long systemWideConnectionBypassDraw = (Long)CommonStargateConfig.system_wide_connection_bypass_energy_draw.get();
    protected static final long interstellarConnectionCost = (Long)CommonStargateConfig.interstellar_connection_energy_cost.get();
    protected static final long interstellarConnectionDraw = (Long)CommonStargateConfig.interstellar_connection_energy_draw.get();
    protected static final long interstellarConnectionBypassDraw = (Long)CommonStargateConfig.interstellar_connection_bypass_energy_draw.get();
    protected static final long intergalacticConnectionCost = (Long)CommonStargateConfig.intergalactic_connection_energy_cost.get();
    protected static final long intergalacticConnectionDraw = (Long)CommonStargateConfig.intergalactic_connection_energy_draw.get();
    protected static final long intergalacticConnectionBypassDraw = (Long)CommonStargateConfig.intergalactic_connection_bypass_energy_draw.get();
    protected final UUID uuid;
    protected final Type connectionType;
    protected Stargate dialingStargate;
    protected Stargate dialedStargate;
    protected boolean doKawoosh;
    protected boolean used;
    protected int connectionTime;
    protected int openTime;
    protected int timeSinceLastTraveler;

    private StargateConnection(UUID uuid, Type connectionType, Stargate dialingStargate, Stargate dialedStargate, boolean used, int connectionTime, int openTime, int timeSinceLastTraveler, boolean doKawoosh) {
        this.uuid = uuid;
        this.connectionType = connectionType;
        this.dialingStargate = dialingStargate;
        this.dialedStargate = dialedStargate;
        this.used = used;
        this.connectionTime = connectionTime;
        this.openTime = openTime;
        this.timeSinceLastTraveler = timeSinceLastTraveler;
        this.doKawoosh = doKawoosh;
    }

    public final void printConnection() {
        System.out.println("-[" + this.uuid + "]");
        System.out.println(" | From: " + this.dialingStargate.get9ChevronAddress().toString());
        System.out.println(" | To: " + this.dialedStargate.get9ChevronAddress().toString());
        System.out.println(" | Connection Time: " + this.connectionTime);
        System.out.println(" | Open Time: " + this.openTime);
    }

    public static final Type getType(MinecraftServer server, Stargate dialingStargate, Stargate dialedStargate) {
        SolarSystem.Serializable dialingSystem = dialingStargate.getSolarSystem(server);
        SolarSystem.Serializable dialedSystem = dialedStargate.getSolarSystem(server);
        if (dialingSystem != null && dialedSystem != null) {
            if (dialingSystem.equals(dialedSystem)) {
                return Type.SYSTEM_WIDE;
            }
            List dialingGalaxies = dialingSystem.getGalacticAddresses().entrySet().stream().toList();
            List dialedGalaxies = dialedSystem.getGalacticAddresses().entrySet().stream().toList();
            if (!dialingGalaxies.isEmpty() && !dialedGalaxies.isEmpty()) {
                for (int i = 0; i < dialingGalaxies.size(); ++i) {
                    for (int j = 0; j < dialedGalaxies.size(); ++j) {
                        Galaxy.Serializable dialedGalaxy;
                        Galaxy.Serializable dialingGalaxy = (Galaxy.Serializable)((Map.Entry)dialingGalaxies.get(i)).getKey();
                        if (!dialingGalaxy.equals(dialedGalaxy = (Galaxy.Serializable)((Map.Entry)dialedGalaxies.get(j)).getKey())) continue;
                        return Type.INTERSTELLAR;
                    }
                }
            }
        }
        return Type.INTERGALACTIC;
    }

    private StargateConnection(UUID uuid, Type connectionType, Stargate dialingStargate, Stargate dialedStargate, boolean doKawoosh) {
        this(uuid, connectionType, dialingStargate, dialedStargate, false, 0, 0, 0, doKawoosh);
    }

    public static final StargateConnection create(MinecraftServer server, Type connectionType, Stargate dialingStargate, Stargate dialedStargate, boolean doKawoosh) {
        UUID uuid = UUID.randomUUID();
        if (dialingStargate != null && dialedStargate != null) {
            dialedStargate.resetStargate(server, StargateInfo.Feedback.INTERRUPTED_BY_INCOMING_CONNECTION, true);
            dialingStargate.updateTimers(server, 0, 0, 0, 0);
            dialingStargate.updateClient(server);
            dialedStargate.updateTimers(server, 0, 0, 0, 0);
            dialedStargate.updateClient(server);
            StargateConnection stargateConnection = new StargateConnection(uuid, connectionType, dialingStargate, dialedStargate, doKawoosh);
            dialingStargate.connectStargate(server, stargateConnection, State.OUTGOING_CONNECTION);
            dialedStargate.connectStargate(server, stargateConnection, State.INCOMING_CONNECTION);
            return stargateConnection;
        }
        return null;
    }

    public final void terminate(MinecraftServer server, StargateInfo.Feedback feedback) {
        SGJourneyEvents.onConnectionTerminated(server, this, feedback);
        if (this.dialingStargate != null) {
            this.dialingStargate.updateInterfaceBlocks(server, null, EVENT_DISCONNECTED, feedback.getCode(), true);
            this.dialingStargate.resetStargate(server, feedback, true);
        }
        if (this.dialedStargate != null) {
            this.dialedStargate.updateInterfaceBlocks(server, null, EVENT_DISCONNECTED, feedback.getCode(), false);
            this.dialedStargate.resetStargate(server, feedback, true);
        }
        StargateNetwork.get(server).removeConnection(this.uuid);
    }

    public final boolean isStargateValid(MinecraftServer server, Stargate stargate) {
        if (stargate == null) {
            StargateJourney.LOGGER.error("Stargate does not exist");
            return false;
        }
        if (!stargate.isConnected(server)) {
            StargateJourney.LOGGER.info("Stargate is not connected");
            return false;
        }
        return true;
    }

    public final void tick(MinecraftServer server) {
        if (!this.isStargateValid(server, this.dialingStargate) || !this.isStargateValid(server, this.dialedStargate)) {
            this.terminate(server, StargateInfo.Feedback.COULD_NOT_REACH_TARGET_STARGATE);
            return;
        }
        if (this.connectionTime == 0) {
            this.dialedStargate.updateInterfaceBlocks(server, null, EVENT_INCOMING_CONNECTION, new Object[0]);
        }
        StargateInfo.ChevronLockSpeed chevronLockSpeed = !this.doKawoosh() ? StargateInfo.ChevronLockSpeed.FAST : this.dialedStargate.getChevronLockSpeed(server);
        int kawooshStartTicks = chevronLockSpeed.getKawooshStartTicks();
        int maxKawooshTicks = kawooshStartTicks + 40;
        int maxOpeningTicks = maxKawooshTicks + 20;
        this.increaseTicks(kawooshStartTicks, maxKawooshTicks, maxOpeningTicks);
        int kawooshTime = this.connectionTime - kawooshStartTicks;
        if (this.connectionTime <= kawooshStartTicks) {
            int addressLength = this.dialingStargate.getAddress(server).getLength();
            Address dialingAddress = this.dialingStargate.getConnectionAddress(server, this.dialedStargate.getSolarSystem(server), addressLength);
            this.dialedStargate.setChevronConfiguration(server, Dialing.getChevronConfiguration(dialingAddress.getLength()));
            this.dialingStargate.doWhileConnecting(server, false, this.doKawoosh(), kawooshStartTicks, this.connectionTime);
            this.dialedStargate.doWhileConnecting(server, true, this.doKawoosh(), kawooshStartTicks, this.connectionTime);
            this.dialedStargate.doWhileDialed(server, dialingAddress, kawooshStartTicks, chevronLockSpeed, this.connectionTime);
            if (this.connectionTime == kawooshStartTicks) {
                ArrayList emptyAddressList = new ArrayList();
                List<Integer> dialedAddressList = Arrays.stream(this.dialedStargate.getAddress(server).toArray()).boxed().toList();
                this.dialedStargate.updateInterfaceBlocks(server, AbstractInterfaceEntity.InterfaceType.BASIC, EVENT_INCOMING_WORMHOLE, emptyAddressList);
                this.dialedStargate.updateInterfaceBlocks(server, AbstractInterfaceEntity.InterfaceType.CRYSTAL, EVENT_INCOMING_WORMHOLE, emptyAddressList);
                this.dialedStargate.updateInterfaceBlocks(server, AbstractInterfaceEntity.InterfaceType.ADVANCED_CRYSTAL, EVENT_INCOMING_WORMHOLE, dialedAddressList);
                List<Integer> dialingAddressList = Arrays.stream(this.dialingStargate.getAddress(server).toArray()).boxed().toList();
                this.dialingStargate.updateInterfaceBlocks(server, null, EVENT_OUTGOING_WORMHOLE, dialingAddressList);
            }
            return;
        }
        if (this.connectionTime < maxOpeningTicks) {
            this.dialingStargate.doKawoosh(server, kawooshTime);
            this.dialedStargate.doKawoosh(server, kawooshTime);
        } else {
            this.dialingStargate.updateTimers(server, this.connectionTime, kawooshTime, this.openTime, this.timeSinceLastTraveler);
            this.dialingStargate.updateClient(server);
            this.dialedStargate.updateTimers(server, this.connectionTime, kawooshTime, this.openTime, this.timeSinceLastTraveler);
            this.dialedStargate.updateClient(server);
        }
        if (this.doKawoosh() && this.connectionTime < maxKawooshTicks) {
            return;
        }
        this.dialingStargate.doWhileConnected(server, false, this.connectionTime);
        this.dialedStargate.doWhileConnected(server, true, this.connectionTime);
        if (this.openTime >= maxOpenTime && !energyBypassEnabled) {
            this.terminate(server, StargateInfo.Feedback.EXCEEDED_CONNECTION_TIME);
            return;
        }
        if (requireEnergy) {
            long energyDraw = this.connectionType.getPowerDraw(this.openTime >= maxOpenTime);
            if (!this.dialingStargate.canExtractEnergy(server, energyDraw) && !this.dialedStargate.canExtractEnergy(server, energyDraw)) {
                this.terminate(server, StargateInfo.Feedback.RAN_OUT_OF_POWER);
                return;
            }
            if (((Boolean)CommonStargateConfig.can_draw_power_from_both_ends.get()).booleanValue() && this.dialedStargate.getEnergyStored(server) > this.dialingStargate.getEnergyStored(server)) {
                this.dialedStargate.depleteEnergy(server, energyDraw, false);
            } else {
                this.dialingStargate.depleteEnergy(server, energyDraw, false);
            }
        }
        if (this.used) {
            ++this.timeSinceLastTraveler;
        }
        this.dialingStargate.doWormhole(server, this, false, StargateInfo.WormholeTravel.ENABLED);
        this.dialedStargate.doWormhole(server, this, true, (StargateInfo.WormholeTravel)((Object)CommonStargateConfig.two_way_wormholes.get()));
        if (this.dialingStargate.autoclose(server) > 0 && this.timeSinceLastTraveler >= this.dialingStargate.autoclose(server)) {
            this.terminate(server, StargateInfo.Feedback.CONNECTION_ENDED_BY_AUTOCLOSE);
        }
        if (this.dialedStargate.autoclose(server) > 0 && this.timeSinceLastTraveler >= this.dialedStargate.autoclose(server)) {
            this.terminate(server, StargateInfo.Feedback.CONNECTION_ENDED_BY_AUTOCLOSE);
        }
    }

    private final void increaseTicks(int kawooshStartTicks, int maxKawooshTicks, int maxOpenTicks) {
        if (!this.doKawoosh() && this.connectionTime >= kawooshStartTicks && this.connectionTime < maxKawooshTicks) {
            this.connectionTime += 60;
        } else if (this.connectionTime < maxOpenTicks) {
            ++this.connectionTime;
        }
        if (this.connectionTime > maxKawooshTicks) {
            ++this.openTime;
        }
    }

    public void sendStargateMessage(MinecraftServer server, AbstractStargateEntity sendingStargate, String message) {
        if (sendingStargate.get9ChevronAddress().equals(this.dialingStargate.get9ChevronAddress())) {
            this.dialedStargate.receiveStargateMessage(server, message);
        } else {
            this.dialingStargate.receiveStargateMessage(server, message);
        }
    }

    public void sendStargateTransmission(MinecraftServer server, AbstractStargateEntity sendingStargate, int transmissionJumps, int frequency, String transmission) {
        if (sendingStargate.get9ChevronAddress().equals(this.dialingStargate.get9ChevronAddress())) {
            this.dialedStargate.forwardTransmission(server, transmissionJumps, frequency, transmission);
        } else {
            this.dialingStargate.forwardTransmission(server, transmissionJumps, frequency, transmission);
        }
    }

    public float checkStargateShieldingState(MinecraftServer server, AbstractStargateEntity sendingStargate) {
        if (sendingStargate.get9ChevronAddress().equals(this.dialingStargate.get9ChevronAddress())) {
            return this.dialedStargate.checkStargateShieldingState(server);
        }
        return this.dialingStargate.checkStargateShieldingState(server);
    }

    public UUID getID() {
        return this.uuid;
    }

    public Type getConnectionType() {
        return this.connectionType;
    }

    @Nullable
    public Stargate getDialingStargate() {
        return this.dialingStargate;
    }

    @Nullable
    public Stargate getDialedStargate() {
        return this.dialedStargate;
    }

    public int getConnectionTime() {
        return this.connectionTime;
    }

    public int getOpenTime() {
        return this.openTime;
    }

    public void setTimeSinceLastTraveler(int timeSinceLastTraveler) {
        this.timeSinceLastTraveler = timeSinceLastTraveler;
    }

    public int getTimeSinceLastTraveler() {
        return this.timeSinceLastTraveler;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public boolean used() {
        return this.used;
    }

    public boolean doKawoosh() {
        return this.doKawoosh;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(DIALING_STARGATE, (Tag)this.serializeStargate(this.dialingStargate));
        tag.m_128365_(DIALED_STARGATE, (Tag)this.serializeStargate(this.dialedStargate));
        tag.m_128379_(USED, this.used);
        tag.m_128405_(CONNECTION_TIME, this.connectionTime);
        tag.m_128405_(OPEN_TIME, this.openTime);
        tag.m_128405_(TIME_SINCE_LAST_TRAVELER, this.timeSinceLastTraveler);
        tag.m_128359_(CONNECTION_TYPE, this.connectionType.toString().toUpperCase());
        tag.m_128379_(DO_KAWOOSH, this.doKawoosh);
        return tag;
    }

    protected CompoundTag serializeStargate(Stargate stargate) {
        CompoundTag tag = new CompoundTag();
        tag.m_128385_(ADDRESS, stargate.get9ChevronAddress().toArray());
        return tag;
    }

    @Nullable
    public static StargateConnection deserialize(MinecraftServer server, UUID uuid, CompoundTag tag) {
        Type connectionType = Type.valueOf(tag.m_128461_(CONNECTION_TYPE));
        Stargate dialingStargate = StargateConnection.deserializeStargate(server, tag.m_128469_(DIALING_STARGATE));
        Stargate dialedStargate = StargateConnection.deserializeStargate(server, tag.m_128469_(DIALED_STARGATE));
        boolean used = tag.m_128471_(USED);
        int openTime = tag.m_128451_(CONNECTION_TIME);
        int connectionTime = tag.m_128451_(OPEN_TIME);
        int timeSinceLastTraveler = tag.m_128451_(TIME_SINCE_LAST_TRAVELER);
        boolean doKawoosh = tag.m_128471_(DO_KAWOOSH);
        return new StargateConnection(uuid, connectionType, dialingStargate, dialedStargate, used, openTime, connectionTime, timeSinceLastTraveler, doKawoosh);
    }

    private static Stargate deserializeStargate(MinecraftServer server, CompoundTag stargateInfo) {
        return BlockEntityList.get(server).getStargate(new Address.Immutable(stargateInfo.m_128465_(ADDRESS)));
    }

    public static enum Type {
        SYSTEM_WIDE(systemWideConnectionCost, systemWideConnectionDraw, systemWideConnectionBypassDraw),
        INTERSTELLAR(interstellarConnectionCost, interstellarConnectionDraw, interstellarConnectionBypassDraw),
        INTERGALACTIC(intergalacticConnectionCost, intergalacticConnectionDraw, intergalacticConnectionBypassDraw);

        private long establishingPowerCost;
        private long powerDraw;
        private long bypassPowerDraw;

        private Type(long establishingPowerCost, long powerDraw, long bypassPowerDraw) {
            this.establishingPowerCost = establishingPowerCost;
            this.powerDraw = powerDraw;
            this.bypassPowerDraw = bypassPowerDraw;
        }

        public long getEstablishingPowerCost() {
            return this.establishingPowerCost;
        }

        public long getPowerDraw(boolean energyBypass) {
            return energyBypass ? this.bypassPowerDraw : this.powerDraw;
        }
    }

    public static enum State {
        IDLE(0, false, false),
        OUTGOING_CONNECTION(1, true, true),
        INCOMING_CONNECTION(-1, true, false);

        private final byte value;
        private final boolean isConnected;
        private final boolean isDialingOut;

        private State(byte value, boolean isConnected, boolean isDialingOut) {
            this.value = value;
            this.isConnected = isConnected;
            this.isDialingOut = isDialingOut;
        }

        public byte byteValue() {
            return this.value;
        }

        public boolean isConnected() {
            return this.isConnected;
        }

        public boolean isDialingOut() {
            return this.isDialingOut;
        }

        public static State fromByte(byte value) {
            return switch (value) {
                case 1 -> OUTGOING_CONNECTION;
                case -1 -> INCOMING_CONNECTION;
                default -> IDLE;
            };
        }
    }
}

