/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney.stargate;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.povstalec.sgjourney.common.block_entities.tech_interface.AbstractInterfaceEntity;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.Galaxy;
import net.povstalec.sgjourney.common.sgjourney.SolarSystem;
import net.povstalec.sgjourney.common.sgjourney.StargateConnection;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;

public interface Stargate {
    public static final String DIMENSION = "Dimension";
    public static final String COORDINATES = "Coordinates";
    public static final String HAS_DHD = "HasDHD";
    public static final String GENERATION = "Generation";
    public static final String TIMES_OPENED = "TimesOpened";
    public static final String NETWORK = "Network";

    public Address.Immutable get9ChevronAddress();

    @Nullable
    public ResourceKey<Level> getDimension();

    @Nullable
    default public ServerLevel getLevel(MinecraftServer server) {
        ResourceKey<Level> dimension = this.getDimension();
        if (dimension == null) {
            return null;
        }
        return server.m_129880_(dimension);
    }

    @Nullable
    public Vec3 getPosition();

    @Nullable
    default public SolarSystem.Serializable getSolarSystem(MinecraftServer server) {
        ResourceKey<Level> dimension = this.getDimension();
        if (dimension == null) {
            return null;
        }
        return Universe.get(server).getSolarSystemFromDimension(dimension);
    }

    public boolean hasDHD();

    public StargateInfo.Gen getGeneration();

    public int getTimesOpened();

    default public int getNetwork() {
        return 0;
    }

    public Address getAddress(MinecraftServer var1);

    default public Address getConnectionAddress(MinecraftServer server, @Nullable SolarSystem.Serializable solarSystem, int addressLength) {
        SolarSystem.Serializable localSolarSystem = this.getSolarSystem(server);
        if (localSolarSystem != null) {
            if (addressLength == 6) {
                Address.Immutable address;
                Galaxy.Serializable galaxy = localSolarSystem.findCommonGalaxy(solarSystem);
                if (galaxy != null && (address = localSolarSystem.getAddressFromGalaxy(galaxy)) != null) {
                    return address.mutable();
                }
            } else if (addressLength == 7) {
                return localSolarSystem.getExtragalacticAddress().mutable();
            }
        }
        return this.get9ChevronAddress().mutable();
    }

    public StargateInfo.Feedback resetStargate(MinecraftServer var1, StargateInfo.Feedback var2, boolean var3);

    public boolean isConnected(MinecraftServer var1);

    public boolean isObstructed(MinecraftServer var1);

    default public boolean isPrimary(MinecraftServer server) {
        return false;
    }

    default public void update(MinecraftServer server) {
    }

    public boolean isValid(MinecraftServer var1);

    public boolean isLoaded(MinecraftServer var1);

    default public void setChevronConfiguration(MinecraftServer server, int[] chevronConfiguration) {
    }

    default public void updateClient(MinecraftServer server) {
    }

    default public void receiveStargateMessage(MinecraftServer server, String message) {
    }

    default public void forwardTransmission(MinecraftServer server, int transmissionJumps, int frequency, String transmission) {
    }

    public float checkStargateShieldingState(MinecraftServer var1);

    default public void updateInterfaceBlocks(MinecraftServer server, @Nullable AbstractInterfaceEntity.InterfaceType type, @Nullable String eventName, Object ... objects) {
    }

    public long getEnergyStored(MinecraftServer var1);

    public boolean canExtractEnergy(MinecraftServer var1, long var2);

    public long depleteEnergy(MinecraftServer var1, long var2, boolean var4);

    default public StargateInfo.ChevronLockSpeed getChevronLockSpeed(MinecraftServer server) {
        return StargateInfo.ChevronLockSpeed.SLOW;
    }

    public StargateInfo.Feedback tryConnect(MinecraftServer var1, Stargate var2, Address.Type var3, boolean var4);

    public void connectStargate(MinecraftServer var1, StargateConnection var2, StargateConnection.State var3);

    default public void doWhileConnecting(MinecraftServer server, boolean incoming, boolean doKawoosh, int kawooshStartTicks, int openTime) {
    }

    default public void doWhileDialed(MinecraftServer server, Address dialingAddress, int kawooshStartTicks, StargateInfo.ChevronLockSpeed chevronLockSpeed, int openTime) {
    }

    default public void updateTimers(MinecraftServer server, int connectionTime, int kawooshTime, int openTime, int timeSinceLastTraveler) {
    }

    default public void doKawoosh(MinecraftServer server, int kawooshTime) {
    }

    default public void doWhileConnected(MinecraftServer server, boolean incoming, int openTime) {
    }

    public void doWormhole(MinecraftServer var1, StargateConnection var2, boolean var3, StargateInfo.WormholeTravel var4);

    public boolean receiveTraveler(MinecraftServer var1, Stargate var2, Entity var3, Vec3 var4, Vec3 var5, Vec3 var6);

    public int autoclose(MinecraftServer var1);

    public CompoundTag serializeNBT();

    public void deserializeNBT(MinecraftServer var1, Address.Immutable var2, CompoundTag var3);

    public static int getMaxGateOpenTime() {
        return (Integer)CommonStargateConfig.max_wormhole_open_time.get() * 20;
    }
}

