/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.sgjourney.transporter;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.povstalec.sgjourney.common.block_entities.transporter.AbstractTransporterEntity;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.sgjourney.transporter.Transporter;

public class SGJourneyTransporter
implements Transporter {
    private UUID id;
    private ResourceKey<Level> dimension;
    private BlockPos blockPos;
    @Nullable
    private Component name;

    public SGJourneyTransporter() {
    }

    public SGJourneyTransporter(UUID id, ResourceKey<Level> dimension, BlockPos blockPos, Component name) {
        this.id = id;
        this.dimension = dimension;
        this.blockPos = blockPos;
        this.name = name;
    }

    public SGJourneyTransporter(AbstractTransporterEntity transporterEntity) {
        this(transporterEntity.getID(), (ResourceKey<Level>)transporterEntity.m_58904_().m_46472_(), transporterEntity.m_58899_(), transporterEntity.m_7770_());
    }

    @Override
    public UUID getID() {
        return this.id;
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    @Override
    public Component getName() {
        return this.name != null ? this.name : Component.m_237119_();
    }

    @Nullable
    public AbstractTransporterEntity getTransporterEntity(MinecraftServer server) {
        BlockEntity blockEntity;
        ServerLevel level = server.m_129880_(this.dimension);
        if (level != null && (blockEntity = level.m_7702_(this.blockPos)) instanceof AbstractTransporterEntity) {
            AbstractTransporterEntity transporter = (AbstractTransporterEntity)blockEntity;
            return transporter;
        }
        return null;
    }

    @Override
    public int getTimeOffset(MinecraftServer server) {
        AbstractTransporterEntity transporter = this.getTransporterEntity(server);
        if (transporter != null) {
            return transporter.getTimeOffset();
        }
        return 0;
    }

    @Override
    @Nullable
    public List<Entity> entitiesToTransport(MinecraftServer server) {
        AbstractTransporterEntity transporter = this.getTransporterEntity(server);
        if (transporter != null) {
            return transporter.entitiesToTransport();
        }
        return new ArrayList<Entity>();
    }

    @Override
    @Nullable
    public BlockPos transportPos(MinecraftServer server) {
        AbstractTransporterEntity transporter = this.getTransporterEntity(server);
        if (transporter != null) {
            return transporter.transportPos();
        }
        return null;
    }

    @Override
    public void connect(MinecraftServer server, UUID connectionID) {
        AbstractTransporterEntity transporter = this.getTransporterEntity(server);
        if (transporter != null) {
            transporter.connectTransporter(connectionID);
        }
    }

    @Override
    public void disconnect(MinecraftServer server) {
        AbstractTransporterEntity transporter = this.getTransporterEntity(server);
        if (transporter != null) {
            transporter.disconnectTransporter();
        }
    }

    @Override
    public void reset(MinecraftServer server) {
        AbstractTransporterEntity transporter = this.getTransporterEntity(server);
        if (transporter != null) {
            transporter.resetTransporter();
        }
    }

    @Override
    public boolean isConnected(MinecraftServer server) {
        AbstractTransporterEntity transporter = this.getTransporterEntity(server);
        if (transporter != null) {
            return transporter.isConnected();
        }
        return false;
    }

    @Override
    public void updateTicks(MinecraftServer server, int connectionTime) {
        AbstractTransporterEntity transporter = this.getTransporterEntity(server);
        if (transporter != null) {
            transporter.updateTicks(connectionTime);
        }
    }

    public String toString() {
        String nameString = this.name != null ? this.name.getString() : this.id.toString();
        return "[ " + nameString + " | Pos: " + this.blockPos.toString() + " ]";
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag transporterTag = new CompoundTag();
        ResourceKey<Level> level = this.getDimension();
        BlockPos pos = this.getBlockPos();
        transporterTag.m_128359_("Dimension", level.m_135782_().toString());
        transporterTag.m_128385_("Coordinates", new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
        if (this.name != null) {
            transporterTag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.name));
        }
        return transporterTag;
    }

    @Override
    public void deserializeNBT(MinecraftServer server, UUID uuid, CompoundTag tag) {
        this.dimension = Conversion.stringToDimension(tag.m_128461_("Dimension"));
        this.blockPos = Conversion.intArrayToBlockPos(tag.m_128465_("Coordinates"));
        if (tag.m_128425_("CustomName", 8)) {
            this.name = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
        this.id = uuid;
    }
}

