/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.toml.TomlParser;
import com.railwayteam.railways.config.CClient;
import com.railwayteam.railways.config.CCommon;
import com.railwayteam.railways.config.CServer;
import com.railwayteam.railways.util.Utils;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.createmod.catnip.config.ConfigBase;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

public class CRConfigs {
    @ApiStatus.Internal
    public static final Map<ModConfig.Type, ConfigBase> CONFIGS = new EnumMap<ModConfig.Type, ConfigBase>(ModConfig.Type.class);
    private static CClient client;
    private static CCommon common;
    private static CServer server;
    private static Boolean cachedDisableDatafixer;
    private static Boolean cachedRegisterMissingTracks;

    public static CClient client() {
        return client;
    }

    public static CCommon common() {
        return common;
    }

    public static CServer server() {
        return server;
    }

    public static ConfigBase byType(ModConfig.Type type) {
        return CONFIGS.get(type);
    }

    private static <T extends ConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            ConfigBase config = (ConfigBase)factory.get();
            config.registerAll(builder);
            return config;
        });
        ConfigBase config = (ConfigBase)specPair.getLeft();
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)config;
    }

    @ApiStatus.Internal
    public static void registerCommon() {
        client = CRConfigs.register(CClient::new, ModConfig.Type.CLIENT);
        common = CRConfigs.register(CCommon::new, ModConfig.Type.COMMON);
        server = CRConfigs.register(CServer::new, ModConfig.Type.SERVER);
    }

    public static void onLoad(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onLoad();
        }
    }

    public static void onReload(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onReload();
        }
    }

    public static String migrateClient(String contents) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("conductorSpyShader", "useConductorSpyShader");
        m.put("extendedCouplerDebug", "showExtendedCouplerDebug");
        m.put("trackOverlayOffset", "trackOverlayOffset");
        m.put("skipClientsideDerailing", "skipClientDerailing");
        m.put("trainSmokePercentage", "smoke.smokePercentage");
        m.put("trainSmokeLifetime", "smoke.smokeLifetime");
        m.put("smokeTextureQuality", "smoke.smokeQuality");
        m.put("journeymapObsolescenceCheckTicks", "journeymap.removeObsoleteRate");
        m.put("journeymapUpdateTicks", "journeymap.updateRate");
        HashMap<String, String> trueMap = new HashMap<String, String>();
        for (Map.Entry entry : m.entrySet()) {
            trueMap.put("general." + (String)entry.getKey(), "client." + (String)entry.getValue());
        }
        return CRConfigs.migrate(contents, trueMap);
    }

    public static String migrateCommon(String contents) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("registerMissingTracks", "registerMissingTracks");
        m.put("disableDatafixer", "disableDatafixer");
        HashMap<String, String> trueMap = new HashMap<String, String>();
        for (Map.Entry entry : m.entrySet()) {
            trueMap.put("general." + (String)entry.getKey(), (String)entry.getValue());
        }
        return CRConfigs.migrate(contents, trueMap);
    }

    @ApiStatus.Internal
    public static String migrate(String contents, Map<String, String> pathMap) {
        TomlGroup root = TomlGroup.root();
        Object keyPrefix = "";
        List<String> lines = contents.lines().toList();
        for (String line : lines) {
            String[] pieces;
            String key;
            if (line.isEmpty()) continue;
            int commentIdx = line.indexOf(35);
            if (commentIdx != -1) {
                line = line.substring(0, commentIdx);
            }
            if ((line = line.trim().replaceAll(" ", "")).isEmpty()) continue;
            if (line.startsWith("[") && line.endsWith("]")) {
                keyPrefix = line.substring(1, line.length() - 1) + ".";
                continue;
            }
            if (!line.contains("=") || !pathMap.containsKey(key = (String)keyPrefix + (pieces = line.split("=", 2))[0].trim())) continue;
            root.add(pathMap.get(key), pieces[1].trim());
        }
        return root.write();
    }

    private static void preloadValues() {
        Path configDir = Utils.configDir();
        Path commonConfig = configDir.resolve("railways-common.toml");
        try (FileReader reader = new FileReader(commonConfig.toFile());){
            CommentedConfig config = new TomlParser().parse((Reader)reader);
            cachedDisableDatafixer = (Boolean)config.getRaw("disableDatafixer");
            cachedRegisterMissingTracks = (Boolean)config.getRaw("registerMissingTracks");
        }
        catch (IOException e) {
            cachedDisableDatafixer = null;
            cachedRegisterMissingTracks = null;
        }
        if (cachedDisableDatafixer == null) {
            cachedDisableDatafixer = false;
        }
        if (cachedRegisterMissingTracks == null) {
            cachedRegisterMissingTracks = false;
        }
    }

    public static boolean getDisableDatafixer() {
        if (common != null) {
            return (Boolean)CRConfigs.common.disableDatafixer.get();
        }
        if (cachedDisableDatafixer == null) {
            CRConfigs.preloadValues();
        }
        return cachedDisableDatafixer;
    }

    public static boolean getRegisterMissingTracks() {
        if (common != null) {
            return (Boolean)CRConfigs.common.registerMissingTracks.get();
        }
        if (cachedRegisterMissingTracks == null) {
            CRConfigs.preloadValues();
        }
        return cachedRegisterMissingTracks;
    }

    private static class TomlGroup {
        private final Map<String, TomlGroup> subgroups = new HashMap<String, TomlGroup>();
        private final Map<String, String> entries = new HashMap<String, String>();
        private final String path;

        private static TomlGroup root() {
            return new TomlGroup("");
        }

        private TomlGroup(String path) {
            this.path = path;
        }

        public boolean isRoot() {
            return this.path.isEmpty();
        }

        public void add(String key, String value) {
            if (!this.isRoot()) {
                throw new NotImplementedException();
            }
            String[] pieces = key.split("\\.");
            String subKey = pieces[pieces.length - 1];
            TomlGroup targetedGroup = this;
            for (int i = 0; i < pieces.length - 1; ++i) {
                targetedGroup = targetedGroup.getOrCreateSubGroup(pieces[i]);
            }
            targetedGroup.entries.put(subKey, value);
        }

        private TomlGroup getOrCreateSubGroup(String subKey) {
            return this.subgroups.computeIfAbsent(subKey, sk -> new TomlGroup((String)(this.path.isEmpty() ? sk : this.path + "." + sk)));
        }

        private void write(StringBuilder b) {
            if (!this.isRoot()) {
                b.append("\n[").append(this.path).append("]");
            }
            for (Map.Entry<String, String> entry : this.entries.entrySet()) {
                b.append("\n").append(entry.getKey()).append(" = ").append(entry.getValue());
            }
            for (TomlGroup subGroup : this.subgroups.values()) {
                subGroup.write(b);
            }
        }

        private String write() {
            StringBuilder b = new StringBuilder();
            b.append("# Automatically written by a converter");
            this.write(b);
            b.append("\n");
            return b.toString();
        }
    }
}

