/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IPortable;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.UpgradeData;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemDrawers
extends BlockItem
implements IPortable {
    public ItemDrawers(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        MutableComponent textCapacity = Component.m_237110_((String)"tooltip.storagedrawers.drawers.capacity", (Object[])new Object[]{this.getCapacityForBlock(stack)});
        tooltip.add((Component)Component.m_237113_((String)"").m_7220_((Component)textCapacity).m_130940_(ChatFormatting.GRAY));
        CompoundTag tag = stack.m_41737_("tile");
        if (tag != null) {
            MutableComponent textSealed = Component.m_237115_((String)"tooltip.storagedrawers.drawers.sealed");
            tooltip.add((Component)Component.m_237113_((String)"").m_7220_((Component)textSealed).m_130940_(ChatFormatting.YELLOW));
        }
        if (((Boolean)ModCommonConfig.INSTANCE.DRAWERS.filled.heavyDrawers.get()).booleanValue() && this.isHeavy(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.storagedrawers.drawers.too_heavy").m_130940_(ChatFormatting.RED));
        }
    }

    public Component m_7626_(ItemStack stack) {
        BlockStandardDrawers drawers;
        String matKey;
        String fallback = null;
        Block block = Block.m_49814_((Item)stack.m_41720_());
        if (block instanceof BlockStandardDrawers && (matKey = (drawers = (BlockStandardDrawers)block).getMatKey()) != null) {
            String mat = Component.m_237115_((String)drawers.getNameMatKey()).getString();
            fallback = Component.m_237110_((String)drawers.getNameTypeKey(), (Object[])new Object[]{mat}).getString();
        }
        return Component.m_264568_((String)this.m_5671_(stack), fallback);
    }

    @NotNull
    public Component m_41466_() {
        return Component.m_237115_((String)(this.m_5524_() + ".desc"));
    }

    @Override
    public boolean isHeavy(@NotNull ItemStack stack) {
        if (stack.m_41720_() != this) {
            return false;
        }
        CompoundTag tile = stack.m_41737_("tile");
        if (tile == null || tile.m_128456_()) {
            return false;
        }
        UpgradeData x = new UpgradeData(7);
        try {
            x.read(tile);
        }
        catch (ClassCastException e) {
            return false;
        }
        return !x.hasPortabilityUpgrade();
    }

    private int getCapacityForBlock(@NotNull ItemStack itemStack) {
        Block block = Block.m_49814_((Item)itemStack.m_41720_());
        if (block instanceof BlockDrawers) {
            BlockDrawers blockDrawers = (BlockDrawers)block;
            return blockDrawers.getStorageUnits() * (Integer)ModCommonConfig.INSTANCE.DRAWERS.baseStackStorage.get();
        }
        return 0;
    }

    public boolean m_142095_() {
        return (Boolean)ModCommonConfig.INSTANCE.DRAWERS.filled.canStoreInContainers.get();
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        BlockDrawers bd;
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        return block instanceof BlockDrawers && (bd = (BlockDrawers)block).retrimType() != null;
    }
}

