/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book.content;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.client.book.content.AbstractMaterialContent;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

public class MeleeHarvestMaterialContent
extends AbstractMaterialContent {
    public static final ResourceLocation ID = TConstruct.getResource("melee_harvest_material");

    public MeleeHarvestMaterialContent(MaterialVariantId materialVariant, boolean detailed) {
        super(materialVariant, detailed);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    @Nullable
    protected MaterialStatsId getStatType(int index) {
        return switch (index) {
            case 0 -> HeadMaterialStats.ID;
            case 1 -> HandleMaterialStats.ID;
            case 2 -> StatlessMaterialStats.BINDING.getIdentifier();
            default -> null;
        };
    }

    @Override
    protected String getTextKey(MaterialId material) {
        return String.format(this.detailed ? "material.%s.%s.encyclopedia" : "material.%s.%s.flavor", material.m_135827_(), material.m_135815_());
    }

    @Override
    protected boolean supportsStatType(MaterialStatsId statsId) {
        return statsId.equals((Object)HeadMaterialStats.ID) || statsId.equals((Object)HandleMaterialStats.ID) || statsId.equals((Object)StatlessMaterialStats.BINDING.getIdentifier());
    }

    @Override
    protected void addCategory(List<ItemElement> displayTools, MaterialId material) {
        if (MaterialRegistry.getInstance().isInTag(material, TinkerTags.Materials.GENERAL)) {
            displayTools.add(MeleeHarvestMaterialContent.makeCategoryIcon(((ModifiableItem)TinkerTools.handAxe.get()).getRenderTool(), TConstruct.getResource("general")));
        } else if (MaterialRegistry.getInstance().isInTag(material, TinkerTags.Materials.MELEE)) {
            displayTools.add(MeleeHarvestMaterialContent.makeCategoryIcon(((ModifiableItem)TinkerTools.sword.get()).getRenderTool(), TConstruct.getResource("melee")));
        } else if (MaterialRegistry.getInstance().isInTag(material, TinkerTags.Materials.HARVEST)) {
            displayTools.add(MeleeHarvestMaterialContent.makeCategoryIcon(((ModifiableItem)TinkerTools.pickaxe.get()).getRenderTool(), TConstruct.getResource("harvest")));
        }
    }
}

