/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.recipe.casting.material.CompositeCastingRecipe;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class CompositeCastingRecipeBuilder
extends AbstractRecipeBuilder<CompositeCastingRecipeBuilder> {
    private final IMaterialItem result;
    private final int itemCost;
    private MaterialStatsId castingStatConflict = null;
    private final TypeAwareRecipeSerializer<? extends CompositeCastingRecipe> serializer;

    public static CompositeCastingRecipeBuilder basin(IMaterialItem result, int itemCost) {
        return CompositeCastingRecipeBuilder.composite(result, itemCost, (TypeAwareRecipeSerializer<? extends CompositeCastingRecipe>)((TypeAwareRecipeSerializer)TinkerSmeltery.basinCompositeSerializer.get()));
    }

    public static CompositeCastingRecipeBuilder table(IMaterialItem result, int itemCost) {
        return CompositeCastingRecipeBuilder.composite(result, itemCost, (TypeAwareRecipeSerializer<? extends CompositeCastingRecipe>)((TypeAwareRecipeSerializer)TinkerSmeltery.tableCompositeSerializer.get()));
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, BuiltInRegistries.f_257033_.m_7981_((Object)this.result.m_5456_()));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "casting");
        consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new CompositeCastingRecipe(this.serializer, id, this.group, this.result, this.itemCost, this.castingStatConflict), CompositeCastingRecipe.LOADER, advancementId));
    }

    private CompositeCastingRecipeBuilder(IMaterialItem result, int itemCost, TypeAwareRecipeSerializer<? extends CompositeCastingRecipe> serializer) {
        this.result = result;
        this.itemCost = itemCost;
        this.serializer = serializer;
    }

    public static CompositeCastingRecipeBuilder composite(IMaterialItem result, int itemCost, TypeAwareRecipeSerializer<? extends CompositeCastingRecipe> serializer) {
        return new CompositeCastingRecipeBuilder(result, itemCost, serializer);
    }

    public CompositeCastingRecipeBuilder castingStatConflict(MaterialStatsId castingStatConflict) {
        this.castingStatConflict = castingStatConflict;
        return this;
    }

    private class Finished
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Finished(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)CompositeCastingRecipeBuilder.this, ID, advancementID);
        }

        public void m_7917_(JsonObject json) {
            if (!CompositeCastingRecipeBuilder.this.group.isEmpty()) {
                json.addProperty("group", CompositeCastingRecipeBuilder.this.group);
            }
            json.addProperty("result", BuiltInRegistries.f_257033_.m_7981_((Object)CompositeCastingRecipeBuilder.this.result.m_5456_()).toString());
            json.addProperty("item_cost", (Number)CompositeCastingRecipeBuilder.this.itemCost);
        }

        public RecipeSerializer<?> m_6637_() {
            return CompositeCastingRecipeBuilder.this.serializer;
        }
    }
}

