/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.util.WeakConsumerWrapper;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.FaucetBlock;
import slimeknights.tconstruct.smeltery.network.FaucetActivationPacket;

public class FaucetBlockEntity
extends MantleBlockEntity {
    public static final int PACKET_SIZE = 90;
    public static final int MB_PER_TICK = 10;
    public static final BlockEntityTicker<FaucetBlockEntity> SERVER_TICKER = (level, pos, world, self) -> self.tick();
    private static final String TAG_DRAINED = "drained";
    private static final String TAG_RENDER_FLUID = "render_fluid";
    private static final String TAG_STOP = "stop";
    private static final String TAG_STATE = "state";
    private static final String TAG_LAST_REDSTONE = "lastRedstone";
    private FaucetState faucetState = FaucetState.OFF;
    private boolean stopPouring = false;
    private FluidStack drained = FluidStack.EMPTY;
    private FluidStack renderFluid = FluidStack.EMPTY;
    private boolean lastRedstoneState = false;
    private LazyOptional<IFluidHandler> inputHandler;
    private LazyOptional<IFluidHandler> outputHandler;
    private final NonNullConsumer<LazyOptional<IFluidHandler>> inputListener = new WeakConsumerWrapper((Object)this, (self, handler) -> {
        self.inputHandler = null;
    });
    private final NonNullConsumer<LazyOptional<IFluidHandler>> outputListener = new WeakConsumerWrapper((Object)this, (self, handler) -> {
        self.outputHandler = null;
    });

    public FaucetBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TinkerSmeltery.faucet.get(), pos, state);
    }

    protected FaucetBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    private LazyOptional<IFluidHandler> findFluidHandler(Direction side) {
        LazyOptional handler;
        assert (this.f_58857_ != null);
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(side));
        if (te != null && (handler = te.getCapability(ForgeCapabilities.FLUID_HANDLER, side.m_122424_())).isPresent()) {
            return handler;
        }
        return LazyOptional.empty();
    }

    private LazyOptional<IFluidHandler> getInputHandler() {
        if (this.inputHandler == null) {
            this.inputHandler = this.findFluidHandler(((Direction)this.m_58900_().m_61143_((Property)FaucetBlock.FACING)).m_122424_());
            if (this.inputHandler.isPresent()) {
                this.inputHandler.addListener(this.inputListener);
            }
        }
        return this.inputHandler;
    }

    private LazyOptional<IFluidHandler> getOutputHandler() {
        if (this.outputHandler == null) {
            this.outputHandler = this.findFluidHandler(Direction.DOWN);
            if (this.outputHandler.isPresent()) {
                this.outputHandler.addListener(this.outputListener);
            }
        }
        return this.outputHandler;
    }

    public void neighborChanged(BlockPos neighbor) {
        if (this.f_58858_.equals((Object)neighbor.m_7494_())) {
            this.outputHandler = null;
        } else if (this.f_58858_.equals((Object)neighbor.m_121945_((Direction)this.m_58900_().m_61143_((Property)FaucetBlock.FACING)))) {
            this.inputHandler = null;
        }
    }

    public boolean isPouring() {
        return this.faucetState != FaucetState.OFF;
    }

    public void activate() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        switch (this.faucetState) {
            case OFF: {
                this.stopPouring = false;
                this.doTransfer(true);
                break;
            }
            case POWERED: {
                this.faucetState = FaucetState.OFF;
                this.syncToClient(FluidStack.EMPTY, false);
                break;
            }
            case POURING: {
                this.stopPouring = true;
            }
        }
    }

    public void handleRedstone(boolean hasSignal) {
        if (hasSignal != this.lastRedstoneState) {
            this.lastRedstoneState = hasSignal;
            if (hasSignal) {
                if (this.f_58857_ != null) {
                    this.f_58857_.m_186460_(this.f_58858_, this.m_58900_().m_60734_(), 2);
                }
            } else if (this.faucetState == FaucetState.POWERED) {
                this.faucetState = FaucetState.OFF;
                this.syncToClient(FluidStack.EMPTY, false);
            }
        }
    }

    private void tick() {
        if (this.faucetState == FaucetState.OFF) {
            return;
        }
        if (this.faucetState == FaucetState.POWERED && this.doTransfer(false)) {
            this.faucetState = FaucetState.POURING;
            return;
        }
        if (!this.drained.isEmpty()) {
            this.pour();
        } else if (this.stopPouring) {
            this.reset();
        } else {
            this.doTransfer(true);
        }
    }

    private boolean doTransfer(boolean execute) {
        LazyOptional<IFluidHandler> inputOptional = this.getInputHandler();
        LazyOptional<IFluidHandler> outputOptional = this.getOutputHandler();
        if (inputOptional.isPresent() && outputOptional.isPresent()) {
            IFluidHandler output;
            int filled;
            IFluidHandler input = (IFluidHandler)inputOptional.orElse((Object)EmptyFluidHandler.INSTANCE);
            FluidStack drained = input.drain(90, IFluidHandler.FluidAction.SIMULATE);
            if (!drained.isEmpty() && (filled = (output = (IFluidHandler)outputOptional.orElse((Object)EmptyFluidHandler.INSTANCE)).fill(drained, IFluidHandler.FluidAction.SIMULATE)) > 0) {
                if (execute) {
                    this.drained = input.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                    if (this.faucetState == FaucetState.OFF || !this.renderFluid.isFluidEqual(drained)) {
                        this.syncToClient(this.drained, true);
                    }
                    this.faucetState = FaucetState.POURING;
                    this.pour();
                }
                return true;
            }
            if (this.lastRedstoneState) {
                if (execute && (this.faucetState == FaucetState.OFF || !this.renderFluid.isFluidEqual(FluidStack.EMPTY))) {
                    this.syncToClient(FluidStack.EMPTY, true);
                }
                this.faucetState = FaucetState.POWERED;
                return false;
            }
        }
        if (execute) {
            this.reset();
        }
        return false;
    }

    private void pour() {
        if (this.drained.isEmpty()) {
            return;
        }
        LazyOptional<IFluidHandler> outputOptional = this.getOutputHandler();
        if (outputOptional.isPresent()) {
            FluidStack fillStack = this.drained.copy();
            fillStack.setAmount(Math.min(this.drained.getAmount(), 10));
            IFluidHandler output = (IFluidHandler)outputOptional.orElse((Object)EmptyFluidHandler.INSTANCE);
            int filled = output.fill(fillStack, IFluidHandler.FluidAction.SIMULATE);
            if (filled > 0) {
                if (!this.renderFluid.isFluidEqual(this.drained)) {
                    this.syncToClient(this.drained, true);
                }
                this.drained.shrink(filled);
                fillStack.setAmount(filled);
                output.fill(fillStack, IFluidHandler.FluidAction.EXECUTE);
            }
        } else {
            this.reset();
        }
    }

    private void reset() {
        this.stopPouring = false;
        this.drained = FluidStack.EMPTY;
        if (this.faucetState != FaucetState.OFF || !this.renderFluid.isFluidEqual(this.drained)) {
            this.faucetState = FaucetState.OFF;
            this.syncToClient(FluidStack.EMPTY, false);
        }
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)this.f_58858_.m_123341_(), (double)(this.f_58858_.m_123342_() - 1), (double)this.f_58858_.m_123343_(), (double)(this.f_58858_.m_123341_() + 1), (double)(this.f_58858_.m_123342_() + 1), (double)(this.f_58858_.m_123343_() + 1));
    }

    private void syncToClient(FluidStack fluid, boolean isPouring) {
        this.renderFluid = fluid.copy();
        if (this.f_58857_ instanceof ServerLevel) {
            TinkerNetwork.getInstance().sendToClientsAround(new FaucetActivationPacket(this.f_58858_, fluid, isPouring), (ServerLevel)this.f_58857_, this.m_58899_());
        }
    }

    public void onActivationPacket(FluidStack fluid, boolean isPouring) {
        this.faucetState = isPouring ? FaucetState.POURING : FaucetState.OFF;
        this.renderFluid = fluid;
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    protected void saveSynced(CompoundTag compound) {
        super.saveSynced(compound);
        compound.m_128344_(TAG_STATE, (byte)this.faucetState.ordinal());
        if (!this.renderFluid.isEmpty()) {
            compound.m_128365_(TAG_RENDER_FLUID, (Tag)this.renderFluid.writeToNBT(new CompoundTag()));
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128379_(TAG_STOP, this.stopPouring);
        compound.m_128379_(TAG_LAST_REDSTONE, this.lastRedstoneState);
        if (!this.drained.isEmpty()) {
            compound.m_128365_(TAG_DRAINED, (Tag)this.drained.writeToNBT(new CompoundTag()));
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.faucetState = FaucetState.fromIndex(compound.m_128445_(TAG_STATE));
        this.stopPouring = compound.m_128471_(TAG_STOP);
        this.lastRedstoneState = compound.m_128471_(TAG_LAST_REDSTONE);
        this.drained = compound.m_128425_(TAG_DRAINED, 10) ? FluidStack.loadFluidStackFromNBT((CompoundTag)compound.m_128469_(TAG_DRAINED)) : FluidStack.EMPTY;
        this.renderFluid = compound.m_128425_(TAG_RENDER_FLUID, 10) ? FluidStack.loadFluidStackFromNBT((CompoundTag)compound.m_128469_(TAG_RENDER_FLUID)) : FluidStack.EMPTY;
    }

    public FluidStack getRenderFluid() {
        return this.renderFluid;
    }

    private static enum FaucetState {
        OFF,
        POURING,
        POWERED;


        public static FaucetState fromIndex(int index) {
            switch (index) {
                case 1: {
                    return POURING;
                }
                case 2: {
                    return POWERED;
                }
            }
            return OFF;
        }
    }
}

