/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.menu;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import slimeknights.mantle.fluid.FluidTransferHelper;
import slimeknights.mantle.fluid.transfer.IFluidContainerTransfer;
import slimeknights.mantle.inventory.SmartItemHandlerSlot;
import slimeknights.mantle.util.sync.ValidZeroDataSlot;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.shared.inventory.TriggeringBaseContainerMenu;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.entity.controller.MelterBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.module.MeltingModuleInventory;

public class MelterContainerMenu
extends TriggeringBaseContainerMenu<MelterBlockEntity> {
    public static final ResourceLocation TOOLTIP_FORMAT = TConstruct.getResource("melter");
    private final Slot[] inputs;
    private boolean hasFuelSlot = false;

    public MelterContainerMenu(int id, @Nullable Inventory inv, @Nullable MelterBlockEntity melter) {
        super((MenuType)TinkerSmeltery.melterContainer.get(), id, inv, melter);
        if (melter != null) {
            BlockEntity te;
            MeltingModuleInventory inventory = melter.getItemHandler();
            this.inputs = new Slot[inventory.getSlots()];
            for (int i = 0; i < this.inputs.length; ++i) {
                this.inputs[i] = this.m_38897_((Slot)new SmartItemHandlerSlot((IItemHandler)inventory, i, 22, 16 + i * 18));
            }
            Level world = melter.m_58904_();
            BlockPos down = melter.m_58899_().m_7495_();
            if (world != null && world.m_8055_(down).m_204336_(TinkerTags.Blocks.FUEL_TANKS) && (te = world.m_7702_(down)) != null) {
                this.hasFuelSlot = te.getCapability(ForgeCapabilities.ITEM_HANDLER).filter(handler -> {
                    this.m_38897_((Slot)new SmartItemHandlerSlot(handler, 0, 151, 32));
                    return true;
                }).isPresent();
            }
            this.addInventorySlots();
            Consumer<DataSlot> referenceConsumer = x$0 -> this.m_38895_((DataSlot)x$0);
            ValidZeroDataSlot.trackIntArray(referenceConsumer, (ContainerData)melter.getFuelModule());
            inventory.trackInts(array -> ValidZeroDataSlot.trackIntArray((Consumer)referenceConsumer, (ContainerData)array));
        } else {
            this.inputs = new Slot[0];
        }
    }

    public MelterContainerMenu(int id, Inventory inv, FriendlyByteBuf buf) {
        this(id, inv, (MelterBlockEntity)MelterContainerMenu.getTileEntityFromBuf((FriendlyByteBuf)buf, MelterBlockEntity.class));
    }

    public boolean m_6366_(Player player, int id) {
        ItemStack held;
        if (0 <= id && id <= 3 && !player.m_5833_() && !(held = this.m_142621_()).m_41619_()) {
            if (!player.m_9236_().f_46443_ && this.tile != null) {
                FluidTankAnimated tank = id < 2 ? ((MelterBlockEntity)this.tile).getTank() : ((MelterBlockEntity)this.tile).getFuelModule().getTank();
                IFluidContainerTransfer.TransferResult result = (id & 1) == 0 ? FluidTransferHelper.fillStack((IFluidHandler)tank, (ItemStack)held, (FluidStack)tank.getFluidInTank(0)) : FluidTransferHelper.interactWithStack((IFluidHandler)tank, (ItemStack)held, (IFluidContainerTransfer.TransferDirection)IFluidContainerTransfer.TransferDirection.EMPTY_ITEM);
                this.m_142503_(FluidTransferHelper.handleUIResult((Player)player, (ItemStack)held, (IFluidContainerTransfer.TransferResult)result));
            }
            return true;
        }
        return false;
    }

    public Slot[] getInputs() {
        return this.inputs;
    }

    public boolean isHasFuelSlot() {
        return this.hasFuelSlot;
    }
}

