/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.gas;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.IGasHandlerItem;
import voltaic.registers.VoltaicCapabilities;

public class GasHandlerItemStack
implements IGasHandlerItem,
ICapabilityProvider {
    public static final String GAS_NBT_KEY = "Gas";
    private final LazyOptional<IGasHandlerItem> lazyOptional = LazyOptional.of(() -> this);
    private Predicate<GasStack> isGasValid = gas -> true;
    protected ItemStack container;
    protected int capacity;
    protected int maxTemperature;
    protected int maxPressure;

    public GasHandlerItemStack(ItemStack container, int capacity, int maxTemperature, int maxPressure) {
        this.container = container;
        this.capacity = capacity;
        this.maxTemperature = maxTemperature;
        this.maxPressure = maxPressure;
    }

    public GasHandlerItemStack setPredicate(Predicate<GasStack> predicate) {
        this.isGasValid = predicate;
        return this;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM) {
            return this.lazyOptional.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public int getTanks() {
        return 1;
    }

    public void setGas(GasStack gas) {
        GasStack.CODEC.encode((Object)gas, (DynamicOps)NbtOps.f_128958_, (Object)NbtOps.f_128958_.empty()).result().ifPresent(tag -> this.container.m_41784_().m_128365_(GAS_NBT_KEY, tag));
    }

    @Override
    public GasStack getGasInTank(int tank) {
        return (GasStack)GasStack.CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)this.container.m_41784_().m_128423_(GAS_NBT_KEY)).result().orElseGet(() -> Pair.of((Object)GasStack.EMPTY, (Object)new CompoundTag())).getFirst();
    }

    @Override
    public int getTankCapacity(int tank) {
        return this.capacity;
    }

    @Override
    public int getTankMaxTemperature(int tank) {
        return this.maxTemperature;
    }

    @Override
    public int getTankMaxPressure(int tank) {
        return this.maxPressure;
    }

    @Override
    public boolean isGasValid(int tank, GasStack gas) {
        return this.isGasValid.test(gas);
    }

    @Override
    public int fill(GasStack resource, GasAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        if (!this.isGasValid(0, resource)) {
            return 0;
        }
        if (this.isEmpty()) {
            int accepted = Math.min(resource.getAmount(), this.capacity);
            if (action == GasAction.EXECUTE) {
                this.setGas(new GasStack(resource.getGas(), accepted, resource.getTemperature(), resource.getPressure()));
                if (resource.getTemperature() > this.maxTemperature) {
                    this.onOverheat();
                }
                if (resource.getPressure() > this.maxPressure) {
                    this.onOverpressure();
                }
            }
            return accepted;
        }
        GasStack gas = this.getGasInTank(0);
        if (!gas.isSameGas(resource)) {
            return 0;
        }
        int canTake = GasStack.getMaximumAcceptance(gas, resource, this.capacity);
        if (canTake == 0) {
            return 0;
        }
        if (action == GasAction.EXECUTE) {
            GasStack accepted = resource.copy();
            accepted.setAmount(canTake);
            GasStack equalized = GasStack.equalizePresrsureAndTemperature(gas, accepted);
            this.setGas(equalized);
            if (gas.getTemperature() > this.maxTemperature) {
                this.onOverheat();
            }
            if (gas.getPressure() > this.maxPressure) {
                this.onOverpressure();
            }
        }
        return canTake;
    }

    @Override
    public GasStack drain(GasStack resource, GasAction action) {
        GasStack gas = this.getGasInTank(0);
        if (resource.isEmpty() || !gas.isSameGas(resource) || !gas.isSamePressure(resource) || !gas.isSameTemperature(resource)) {
            return GasStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @Override
    public GasStack drain(int amount, GasAction action) {
        if (this.isEmpty() || amount == 0) {
            return GasStack.EMPTY;
        }
        GasStack gas = this.getGasInTank(0);
        int taken = Math.min(gas.getAmount(), amount);
        GasStack takenStack = new GasStack(gas.getGas(), taken, gas.getTemperature(), gas.getPressure());
        if (action == GasAction.EXECUTE) {
            gas.shrink(taken);
            if (gas.getAmount() == 0) {
                this.setContainerToEmpty();
            } else {
                this.setGas(gas);
            }
        }
        return takenStack;
    }

    @Override
    public int heat(int tank, int deltaTemperature, GasAction action) {
        GasStack gas = this.getGasInTank(0);
        if (gas.isAbsoluteZero() && deltaTemperature < 0) {
            return -1;
        }
        GasStack updated = gas.copy();
        updated.heat(deltaTemperature);
        if (updated.getAmount() > this.capacity) {
            return -1;
        }
        if (action == GasAction.EXECUTE) {
            this.setGas(updated);
            if (gas.getTemperature() > this.maxTemperature) {
                this.onOverheat();
            }
        }
        return this.capacity - updated.getAmount();
    }

    @Override
    public int bringPressureTo(int tank, int atm, GasAction action) {
        GasStack gas = this.getGasInTank(0);
        if (gas.isVacuum() && atm < 1) {
            return -1;
        }
        GasStack updated = gas.copy();
        updated.bringPressureTo(atm);
        if (updated.getAmount() > this.capacity) {
            return -1;
        }
        if (action == GasAction.EXECUTE) {
            this.setGas(updated);
            if (gas.getPressure() > this.maxPressure) {
                this.onOverpressure();
            }
        }
        return this.capacity - updated.getAmount();
    }

    @Override
    public ItemStack getContainer() {
        return this.container;
    }

    public void onOverheat() {
        this.container.m_41774_(1);
    }

    public void onOverpressure() {
        this.container.m_41774_(1);
    }

    public boolean isEmpty() {
        return this.getGasInTank(0).isEmpty();
    }

    public void setContainerToEmpty() {
        this.container.m_41784_().m_128473_(GAS_NBT_KEY);
    }

    public static class SwapEmpty
    extends GasHandlerItemStack {
        protected final ItemStack emptyContainer;

        public SwapEmpty(ItemStack container, ItemStack emptyContainer, int capacity, int maxTemperature, int maxPressure) {
            super(container, capacity, maxTemperature, maxPressure);
            this.emptyContainer = emptyContainer;
        }

        @Override
        public void setContainerToEmpty() {
            super.setContainerToEmpty();
            this.container = this.emptyContainer;
        }
    }

    public static class Consumable
    extends GasHandlerItemStack {
        public Consumable(ItemStack container, int capacity, int maxTemperature, int maxPressure) {
            super(container, capacity, maxTemperature, maxPressure);
        }

        @Override
        public void setContainerToEmpty() {
            super.setContainerToEmpty();
            this.container.m_41774_(1);
        }
    }
}

