/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.gas;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.IGasHandler;
import voltaic.api.gas.utils.IGasTank;

public class GasTank
implements IGasTank,
IGasHandler {
    protected Predicate<GasStack> isGasValid;
    private int capacity;
    private int maxTemperature;
    private int maxPressure;
    @Nonnull
    private GasStack gas = GasStack.EMPTY;

    public GasTank(int capacity, int maxTemperature, int maxPressure) {
        this(capacity, maxTemperature, maxPressure, gas -> true);
    }

    public GasTank(int capacity, int maxTemperature, int maxPressure, Predicate<GasStack> isGasValid) {
        this.capacity = capacity;
        this.maxTemperature = maxTemperature;
        this.maxPressure = maxPressure;
        this.isGasValid = isGasValid;
    }

    public GasTank setValidator(Predicate<GasStack> predicate) {
        this.isGasValid = predicate;
        return this;
    }

    public void setGas(GasStack gas) {
        this.gas = gas;
    }

    @Override
    public GasStack getGas() {
        return this.gas;
    }

    @Override
    public int getGasAmount() {
        return this.getGas().getAmount();
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public void setMaxTemperature(int temperature) {
        this.maxTemperature = temperature;
    }

    @Override
    public int getMaxTemperature() {
        return this.maxTemperature;
    }

    public void setMaxPressure(int pressure) {
        this.maxPressure = pressure;
    }

    @Override
    public int getMaxPressure() {
        return this.maxPressure;
    }

    @Override
    public boolean isGasValid(GasStack other) {
        return this.isGasValid.test(other);
    }

    @Override
    public int fill(GasStack resource, GasAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        if (!this.isGasValid(resource)) {
            return 0;
        }
        if (this.isEmpty()) {
            int accepted;
            int n = accepted = resource.getAmount() > this.getCapacity() ? this.getCapacity() : resource.getAmount();
            if (action == GasAction.EXECUTE) {
                GasStack taken = resource.copy();
                taken.setAmount(accepted);
                this.setGas(taken);
                this.onChange();
                if (this.getGas().getTemperature() > this.getMaxTemperature()) {
                    this.onOverheat();
                }
                if (this.getGas().getPressure() > this.getMaxPressure()) {
                    this.onOverpressure();
                }
                if (this.getGas().isCondensed()) {
                    this.onGasCondensed();
                }
            }
            return accepted;
        }
        if (!this.getGas().isSameGas(resource)) {
            return 0;
        }
        int canTake = GasStack.getMaximumAcceptance(this.getGas(), resource, this.getCapacity());
        if (canTake == 0) {
            return 0;
        }
        if (action == GasAction.EXECUTE) {
            GasStack accepted = resource.copy();
            accepted.setAmount(canTake);
            GasStack equalized = GasStack.equalizePresrsureAndTemperature(this.getGas().copy(), accepted);
            this.setGas(equalized);
            this.onChange();
            if (this.getGas().getTemperature() > this.getMaxTemperature()) {
                this.onOverheat();
            }
            if (this.getGas().getPressure() > this.getMaxPressure()) {
                this.onOverpressure();
            }
            if (this.getGas().isCondensed()) {
                this.onGasCondensed();
            }
        }
        return canTake;
    }

    @Override
    public GasStack drain(int amount, GasAction action) {
        if (this.isEmpty() || amount == 0) {
            return GasStack.EMPTY;
        }
        int taken = Math.min(this.getGas().getAmount(), amount);
        GasStack takenStack = new GasStack(this.getGas().getGas(), taken, this.getGas().getTemperature(), this.getGas().getPressure());
        if (action == GasAction.EXECUTE) {
            GasStack newStack = this.getGas().copy();
            newStack.shrink(taken);
            if (newStack.getAmount() == 0) {
                this.setGas(GasStack.EMPTY);
            } else {
                this.setGas(newStack);
            }
            this.onChange();
        }
        return takenStack;
    }

    @Override
    public GasStack drain(GasStack resource, GasAction action) {
        if (resource.isEmpty() || !this.getGas().isSameGas(resource) || !this.getGas().isSamePressure(resource) || !this.getGas().isSameTemperature(resource)) {
            return GasStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @Override
    public int heat(int tank, int deltaTemperature, GasAction action) {
        if (this.getGas().isAbsoluteZero() && deltaTemperature < 0) {
            return -1;
        }
        GasStack updated = this.getGas().copy();
        updated.heat(deltaTemperature);
        if (updated.getAmount() > this.getCapacity()) {
            return -1;
        }
        if (action == GasAction.EXECUTE) {
            this.setGas(updated);
            this.onChange();
            if (this.getGas().getTemperature() > this.getMaxTemperature()) {
                this.onOverheat();
            } else if (this.getGas().isCondensed()) {
                this.onGasCondensed();
            }
        }
        return this.getCapacity() - updated.getAmount();
    }

    @Override
    public int bringPressureTo(int tank, int atm, GasAction action) {
        if (this.getGas().isVacuum() && atm < 1) {
            return -1;
        }
        GasStack updated = this.getGas().copy();
        updated.bringPressureTo(atm);
        if (updated.getAmount() > this.getCapacity()) {
            return -1;
        }
        if (action == GasAction.EXECUTE) {
            this.setGas(updated);
            this.onChange();
            if (this.getGas().getPressure() > this.getMaxPressure()) {
                this.onOverpressure();
            }
        }
        return this.getCapacity() - updated.getAmount();
    }

    public int getSpace() {
        return Math.max(this.getCapacity() - this.getGasAmount(), 0);
    }

    public void onChange() {
    }

    public void onOverheat() {
    }

    public void onOverpressure() {
    }

    public void onGasCondensed() {
    }

    public boolean isEmpty() {
        return this.getGas().isEmpty();
    }

    public CompoundTag writeToNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("gasstack", (Tag)this.getGas().writeToNbt());
        tag.m_128405_("capacity", this.getCapacity());
        tag.m_128405_("maxtemp", this.getMaxTemperature());
        tag.m_128405_("maxpres", this.getMaxPressure());
        return tag;
    }

    public static GasTank readFromNbt(CompoundTag tag) {
        GasStack stack = GasStack.readFromNbt(tag.m_128469_("gasstack"));
        GasTank tank = new GasTank(tag.m_128451_("capacity"), tag.m_128451_("maxtemp"), tag.m_128451_("maxpres"));
        tank.setGas(stack);
        return tank;
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        GasStack.STREAM_CODEC.encode(buffer, this.getGas());
        buffer.writeDouble((double)this.getCapacity());
        buffer.writeDouble((double)this.getMaxTemperature());
        buffer.writeInt(this.getMaxPressure());
    }

    public static GasTank readFromBuffer(FriendlyByteBuf buffer) {
        GasStack stack = GasStack.STREAM_CODEC.decode(buffer);
        GasTank tank = new GasTank(buffer.readInt(), buffer.readInt(), buffer.readInt());
        tank.setGas(stack);
        return tank;
    }

    public String toString() {
        return "Gas: " + this.getGas().toString() + ", Capacity: " + this.getCapacity() + " mB, Max Temp: " + this.getMaxTemperature() + " K, Max Pressure: " + this.getMaxPressure() + " ATM";
    }

    public boolean equals(Object obj) {
        if (obj instanceof GasTank) {
            GasTank other = (GasTank)obj;
            return this.getGas().equals(obj) && this.getCapacity() == other.getCapacity() && this.getMaxTemperature() == other.getMaxTemperature() && this.getMaxPressure() == other.getMaxPressure();
        }
        return false;
    }

    @Override
    public int getTanks() {
        return 1;
    }

    @Override
    public GasStack getGasInTank(int tank) {
        return this.getGas();
    }

    @Override
    public int getTankCapacity(int tank) {
        return this.getCapacity();
    }

    @Override
    public int getTankMaxTemperature(int tank) {
        return this.getMaxTemperature();
    }

    @Override
    public int getTankMaxPressure(int tank) {
        return this.getMaxPressure();
    }

    @Override
    public boolean isGasValid(int tank, GasStack gas) {
        return this.isGasValid(gas);
    }

    public int getRoom() {
        return this.getCapacity() - this.getGasAmount();
    }
}

