/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.radiation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.AABB;
import voltaic.api.codec.StreamCodec;
import voltaic.api.radiation.util.IRadiationSource;
import voltaic.prefab.utilities.BlockEntityUtils;

public class SimpleRadiationSource
implements IRadiationSource {
    public static final SimpleRadiationSource NONE = new SimpleRadiationSource(0.0, 0.0, 0, false, 0, BlockEntityUtils.OUT_OF_REACH, false, false);
    public static final Codec<SimpleRadiationSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("amount").forGetter(SimpleRadiationSource::amount), (App)Codec.DOUBLE.fieldOf("strength").forGetter(SimpleRadiationSource::strength), (App)Codec.INT.fieldOf("spread").forGetter(SimpleRadiationSource::getDistanceSpread), (App)Codec.BOOL.fieldOf("temporary").forGetter(SimpleRadiationSource::isTemporary), (App)Codec.INT.fieldOf("persistanceticks").forGetter(SimpleRadiationSource::getPersistanceTicks), (App)BlockPos.f_121852_.optionalFieldOf("location", (Object)BlockEntityUtils.OUT_OF_REACH).forGetter(SimpleRadiationSource::location), (App)Codec.BOOL.fieldOf("lingers").forGetter(SimpleRadiationSource::shouldLinger), (App)Codec.BOOL.fieldOf("shouldcombine").forGetter(SimpleRadiationSource::shouldCombine)).apply((Applicative)instance, SimpleRadiationSource::new));
    public static final StreamCodec<ByteBuf, SimpleRadiationSource> STREAM_CODEC = new StreamCodec<ByteBuf, SimpleRadiationSource>(){

        @Override
        public void encode(ByteBuf buffer, SimpleRadiationSource value) {
            StreamCodec.DOUBLE.encode(buffer, value.amount);
            StreamCodec.DOUBLE.encode(buffer, value.strength);
            StreamCodec.INT.encode(buffer, value.distance);
            StreamCodec.BOOL.encode(buffer, value.isTemporary);
            StreamCodec.INT.encode(buffer, value.ticks);
            StreamCodec.BLOCK_POS.encode(buffer, value.location);
            StreamCodec.BOOL.encode(buffer, value.shouldLinger);
            StreamCodec.BOOL.encode(buffer, value.shouldCombine);
        }

        @Override
        public SimpleRadiationSource decode(ByteBuf buffer) {
            return new SimpleRadiationSource(StreamCodec.DOUBLE.decode(buffer), StreamCodec.DOUBLE.decode(buffer), StreamCodec.INT.decode(buffer), StreamCodec.BOOL.decode(buffer), StreamCodec.INT.decode(buffer), StreamCodec.BLOCK_POS.decode(buffer), StreamCodec.BOOL.decode(buffer), StreamCodec.BOOL.decode(buffer));
        }
    };
    private final double amount;
    private final double strength;
    private final int distance;
    private final boolean isTemporary;
    private final int ticks;
    private final BlockPos location;
    private final boolean shouldLinger;
    private final boolean shouldCombine;
    private final AABB boundingBox;
    public final ChunkPos chunkPos;

    public SimpleRadiationSource(double amount, double strength, int distance, boolean isTemporary, int ticks, BlockPos location, boolean shouldLinger, boolean shouldCombine) {
        this.amount = amount;
        this.strength = strength;
        this.distance = distance;
        this.isTemporary = isTemporary;
        this.ticks = ticks;
        this.location = location;
        this.shouldLinger = shouldLinger;
        this.shouldCombine = shouldCombine;
        this.boundingBox = new AABB(location).m_82400_((double)distance);
        this.chunkPos = new ChunkPos(location);
    }

    @Override
    public double getRadiationAmount() {
        return this.amount();
    }

    @Override
    public double getRadiationStrength() {
        return this.strength();
    }

    @Override
    public int getDistanceSpread() {
        return this.distance();
    }

    @Override
    public boolean isTemporary() {
        return this.isTemporary;
    }

    @Override
    public int getPersistanceTicks() {
        return this.ticks();
    }

    @Override
    public BlockPos getSourceLocation() {
        return this.location();
    }

    @Override
    public boolean shouldLeaveLingeringSource() {
        return this.shouldLinger();
    }

    public double amount() {
        return this.amount;
    }

    public double strength() {
        return this.strength;
    }

    public int distance() {
        return this.distance;
    }

    public int ticks() {
        return this.ticks;
    }

    public BlockPos location() {
        return this.location;
    }

    public boolean shouldLinger() {
        return this.shouldLinger;
    }

    public boolean shouldCombine() {
        return this.shouldCombine;
    }

    public AABB getBoundingBox() {
        return this.boundingBox;
    }
}

