/*
 * Decompiled with CFR 0.152.
 */
package voltaic.client;

import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import voltaic.Voltaic;
import voltaic.client.guidebook.ReloadListenerResetGuidebook;
import voltaic.client.guidebook.ScreenGuidebook;
import voltaic.client.model.block.bakerytypes.CableModelLoader;
import voltaic.client.particle.fluiddrop.ParticleFluidDrop;
import voltaic.client.particle.lavawithphysics.ParticleLavaWithPhysics;
import voltaic.client.particle.plasmaball.ParticlePlasmaBall;
import voltaic.client.screen.ScreenDO2OProcessor;
import voltaic.client.screen.ScreenO2OProcessor;
import voltaic.client.screen.ScreenO2OProcessorDouble;
import voltaic.client.screen.ScreenO2OProcessorTriple;
import voltaic.client.texture.atlas.AtlasHolderVoltaicCustom;
import voltaic.registers.VoltaicMenuTypes;
import voltaic.registers.VoltaicParticles;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="voltaic", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class VoltaicClientRegister {
    public static final ResourceLocation ON = Voltaic.vanillarl("on");
    public static final ResourceLocation TEXTURE_WHITE = Voltaic.forgerl("white");
    public static final ResourceLocation TEXTURE_MERCURY = Voltaic.rl("block/custom/mercury");
    public static final ResourceLocation TEXTURE_GAS = Voltaic.rl("block/custom/gastexture");
    public static final ResourceLocation TEXTURE_MULTISUBNODE = Voltaic.rl("block/multisubnode");
    private static final String MULTIBLOCK_API_MODEL_FOLDER = "multiblockmodels";
    private static final HashMap<ResourceLocation, TextureAtlasSprite> CACHED_TEXTUREATLASSPRITES = new HashMap();
    private static final List<ResourceLocation> CUSTOM_TEXTURES = List.of(TEXTURE_WHITE, TEXTURE_MERCURY, TEXTURE_GAS, TEXTURE_MULTISUBNODE);

    public static void setup() {
        MenuScreens.m_96206_((MenuType)((MenuType)VoltaicMenuTypes.CONTAINER_GUIDEBOOK.get()), ScreenGuidebook::new);
        MenuScreens.m_96206_((MenuType)((MenuType)VoltaicMenuTypes.CONTAINER_O2OPROCESSOR.get()), ScreenO2OProcessor::new);
        MenuScreens.m_96206_((MenuType)((MenuType)VoltaicMenuTypes.CONTAINER_O2OPROCESSORDOUBLE.get()), ScreenO2OProcessorDouble::new);
        MenuScreens.m_96206_((MenuType)((MenuType)VoltaicMenuTypes.CONTAINER_O2OPROCESSORTRIPLE.get()), ScreenO2OProcessorTriple::new);
        MenuScreens.m_96206_((MenuType)((MenuType)VoltaicMenuTypes.CONTAINER_DO2OPROCESSOR.get()), ScreenDO2OProcessor::new);
    }

    @SubscribeEvent
    public static void onModelEvent(ModelEvent.RegisterAdditional event) {
        ResourceManager manager = Minecraft.m_91087_().m_91098_();
        FileToIdConverter converter = FileToIdConverter.m_246568_((String)"models/multiblockmodels");
        converter.m_247457_(manager).forEach((location, resource) -> event.register(converter.m_245273_(location).m_246208_("multiblockmodels/")));
    }

    @SubscribeEvent
    public static void cacheCustomTextureAtlases(TextureStitchEvent.Post event) {
        if (event.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            CACHED_TEXTUREATLASSPRITES.clear();
            for (ResourceLocation loc : CUSTOM_TEXTURES) {
                CACHED_TEXTUREATLASSPRITES.put(loc, event.getAtlas().m_118316_(loc));
            }
        }
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)VoltaicParticles.PARTICLE_PLASMA_BALL.get(), ParticlePlasmaBall.Factory::new);
        event.registerSpriteSet((ParticleType)VoltaicParticles.PARTICLE_LAVAWITHPHYSICS.get(), ParticleLavaWithPhysics.Factory::new);
        event.registerSpriteSet((ParticleType)VoltaicParticles.PARTICLE_FLUIDDROP.get(), ParticleFluidDrop.Factory::new);
    }

    @SubscribeEvent
    public static void registerClientReloadListeners(RegisterClientReloadListenersEvent event) {
        AtlasHolderVoltaicCustom.INSTANCE = new AtlasHolderVoltaicCustom(Minecraft.m_91087_().m_91097_());
        event.registerReloadListener((PreparableReloadListener)AtlasHolderVoltaicCustom.INSTANCE);
        event.registerReloadListener((PreparableReloadListener)new ReloadListenerResetGuidebook());
    }

    @SubscribeEvent
    public static void registerGeometryLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("voltaiccableloader", (IGeometryLoader)CableModelLoader.INSTANCE);
    }

    public static TextureAtlasSprite getSprite(ResourceLocation sprite) {
        return CACHED_TEXTUREATLASSPRITES.getOrDefault(sprite, CACHED_TEXTUREATLASSPRITES.get(TEXTURE_WHITE));
    }

    public static final TextureAtlasSprite whiteSprite() {
        return CACHED_TEXTUREATLASSPRITES.get(TEXTURE_WHITE);
    }
}

