/*
 * Decompiled with CFR 0.152.
 */
package voltaic.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import voltaic.prefab.tile.GenericTile;

public abstract class AbstractTileRenderer<T extends GenericTile>
implements BlockEntityRenderer<T> {
    protected BlockEntityRendererProvider.Context context;
    protected final Random random;

    public AbstractTileRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
        this.random = new Random();
    }

    public long getGameTime() {
        return this.minecraft().f_91073_.m_46467_();
    }

    public Minecraft minecraft() {
        return Minecraft.m_91087_();
    }

    public ClientLevel level() {
        return this.minecraft().f_91073_;
    }

    public BakedModel getModel(ResourceLocation model) {
        return Minecraft.m_91087_().m_91304_().getModel(model);
    }

    public void renderItem(ItemStack stack, ItemDisplayContext context, int light, int overlay, PoseStack poseStack, MultiBufferSource bufferSource, @Nullable Level world, int seed) {
        Minecraft.m_91087_().m_91291_().m_269128_(stack, context, light, overlay, poseStack, bufferSource, world, seed);
    }

    public abstract void render(@NotNull T var1, float var2, @NotNull PoseStack var3, @NotNull MultiBufferSource var4, int var5, int var6);

    public AABB aabb(double x0, double y0, double z0, double x1, double y1, double z1) {
        return new AABB(x0 / 16.0, y0 / 16.0, z0 / 16.0, x1 / 16.0, y1 / 16.0, z1 / 16.0);
    }
}

