/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.blockitem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.common.blockitem.BlockItemVoltaic;
import voltaic.prefab.utilities.VoltaicTextUtils;

public class BlockItemDescriptable
extends BlockItemVoltaic {
    private static final HashMap<Supplier<Block>, ArrayList<MutableComponent>> DESCRIPTION_MAPPINGS = new HashMap();
    private static final HashMap<Block, ArrayList<MutableComponent>> PROCESSED_DESCRIPTION_MAPPINGS = new HashMap();
    private static boolean initialized = false;

    public BlockItemDescriptable(Block block, Item.Properties properties, Supplier<CreativeModeTab> creativeTab) {
        super(block, properties, creativeTab);
    }

    public void m_7373_(ItemStack stack, Level context, List<Component> tooltip, TooltipFlag flagIn) {
        double joules;
        ArrayList<MutableComponent> gotten;
        super.m_7373_(stack, context, tooltip, flagIn);
        if (!initialized) {
            initialized = true;
            DESCRIPTION_MAPPINGS.forEach((supplier, set) -> PROCESSED_DESCRIPTION_MAPPINGS.put((Block)supplier.get(), (ArrayList<MutableComponent>)set));
        }
        if ((gotten = PROCESSED_DESCRIPTION_MAPPINGS.get(this.m_40614_())) != null) {
            tooltip.addAll(gotten);
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("joules") && (joules = stack.m_41783_().m_128459_("joules")) > 0.0) {
            tooltip.add((Component)VoltaicTextUtils.gui("machine.stored", ChatFormatter.getChatDisplayShort(joules, DisplayUnits.JOULES)));
        }
    }

    public int getMaxStackSize(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128459_("joules") > 0.0 ? 1 : super.getMaxStackSize(stack);
    }

    public static void addDescription(Supplier<Block> block, MutableComponent description) {
        ArrayList<MutableComponent> set = DESCRIPTION_MAPPINGS.getOrDefault(block, new ArrayList());
        set.add(description);
        DESCRIPTION_MAPPINGS.put(block, set);
    }
}

