/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.event;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import voltaic.Voltaic;
import voltaic.api.radiation.CapabilityRadiationRecipient;
import voltaic.api.radiation.RadiationManager;
import voltaic.common.command.CommandWipeRadiationSources;
import voltaic.common.reloadlistener.RadiationShieldingRegister;
import voltaic.common.reloadlistener.RadioactiveBlockRegister;
import voltaic.common.reloadlistener.RadioactiveFluidRegister;
import voltaic.common.reloadlistener.RadioactiveGasRegister;
import voltaic.common.reloadlistener.RadioactiveItemRegister;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.registers.VoltaicCapabilities;

@Mod.EventBusSubscriber(modid="voltaic", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerEventHandler {
    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)RadioactiveItemRegister.INSTANCE);
        event.addListener((PreparableReloadListener)RadioactiveFluidRegister.INSTANCE);
        event.addListener((PreparableReloadListener)RadioactiveGasRegister.INSTANCE);
        event.addListener((PreparableReloadListener)RadiationShieldingRegister.INSTANCE);
        event.addListener((PreparableReloadListener)RadioactiveBlockRegister.INSTANCE);
    }

    @SubscribeEvent
    public static void serverStartedHandler(ServerStartedEvent event) {
        RadioactiveItemRegister.INSTANCE.generateTagValues();
        RadioactiveFluidRegister.INSTANCE.generateTagValues();
        RadioactiveGasRegister.INSTANCE.generateTagValues();
        RadiationShieldingRegister.INSTANCE.generateTagValues();
        RadioactiveBlockRegister.INSTANCE.generateTagValues();
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandWipeRadiationSources.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void registerEntityCaps(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof LivingEntity && entity.getCapability(VoltaicCapabilities.CAPABILITY_RADIATIONRECIPIENT).orElse((Object)CapabilityUtils.EMPTY_RADIATION_REPIPIENT) == CapabilityUtils.EMPTY_RADIATION_REPIPIENT) {
            event.addCapability(Voltaic.rl("radiationrecipient"), (ICapabilityProvider)new CapabilityRadiationRecipient());
        }
    }

    @SubscribeEvent
    public static void registerLevelCaps(AttachCapabilitiesEvent<Level> event) {
        Level world = (Level)event.getObject();
        if (world != null && world.getCapability(VoltaicCapabilities.CAPABILITY_RADIATIONMANAGER).orElse((Object)CapabilityUtils.EMPTY_MANAGER) == CapabilityUtils.EMPTY_MANAGER) {
            event.addCapability(Voltaic.rl("radiationmanager"), (ICapabilityProvider)new RadiationManager());
        }
    }
}

