/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.reloadlistener;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.Logger;
import voltaic.Voltaic;
import voltaic.api.radiation.util.RadioactiveObject;
import voltaic.common.packet.types.client.PacketSetClientRadioactiveFluids;

public class RadioactiveFluidRegister
extends SimplePreparableReloadListener<JsonObject> {
    public static RadioactiveFluidRegister INSTANCE = null;
    public static final String FOLDER = "radiation";
    public static final String FILE_NAME = "radioactive_fluids";
    protected static final String JSON_EXTENSION = ".json";
    protected static final int JSON_EXTENSION_LENGTH = ".json".length();
    private static final Gson GSON = new Gson();
    private final HashMap<TagKey<Fluid>, RadioactiveObject> tags = new HashMap();
    private final HashMap<Fluid, RadioactiveObject> radioactiveFluidMap = new HashMap();
    private final Logger logger = Voltaic.LOGGER;

    protected JsonObject prepare(ResourceManager manager, ProfilerFiller profiler) {
        JsonObject combined = new JsonObject();
        ArrayList resources = new ArrayList(manager.m_214159_(FOLDER, RadioactiveFluidRegister::isJson).entrySet());
        Collections.reverse(resources);
        for (Map.Entry entry : resources) {
            ResourceLocation loc = (ResourceLocation)entry.getKey();
            String namespace = loc.m_135827_();
            String filePath = loc.m_135815_();
            String dataPath = filePath.substring(FOLDER.length() + 1, filePath.length() - JSON_EXTENSION_LENGTH);
            ResourceLocation jsonFile = new ResourceLocation(namespace, dataPath);
            Resource resource = (Resource)entry.getValue();
            try {
                InputStream inputStream = resource.m_215507_();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                    JsonObject json = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonElement.class);
                    json.entrySet().forEach(set -> {
                        if (combined.has((String)set.getKey())) {
                            combined.remove((String)set.getKey());
                        }
                        combined.add((String)set.getKey(), (JsonElement)set.getValue());
                    });
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException | RuntimeException exception) {
                this.logger.error("Data loader for {} could not read data {} from file {} in data pack {}", (Object)FOLDER, (Object)jsonFile, (Object)loc, (Object)resource.m_215506_(), (Object)exception);
            }
        }
        return combined;
    }

    protected void apply(JsonObject json, ResourceManager manager, ProfilerFiller profiler) {
        this.tags.clear();
        json.entrySet().forEach(set -> {
            String key = (String)set.getKey();
            RadioactiveObject value = (RadioactiveObject)((Pair)RadioactiveObject.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)set.getValue())).result().get()).getFirst();
            if (key.contains("#")) {
                key = key.substring(1);
                this.tags.put((TagKey<Fluid>)FluidTags.create((ResourceLocation)new ResourceLocation(key)), value);
            } else {
                this.radioactiveFluidMap.put((Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(key)), value);
            }
        });
    }

    public void generateTagValues() {
        this.tags.forEach((tag, value) -> ((HolderSet.Named)BuiltInRegistries.f_257020_.m_203431_(tag).get()).forEach(gas -> this.radioactiveFluidMap.put((Fluid)gas.m_203334_(), (RadioactiveObject)value)));
        this.tags.clear();
    }

    public RadioactiveFluidRegister subscribeAsSyncable(SimpleChannel channel) {
        MinecraftForge.EVENT_BUS.addListener(this.getDatapackSyncListener(channel));
        return this;
    }

    private Consumer<OnDatapackSyncEvent> getDatapackSyncListener(SimpleChannel channel) {
        return event -> {
            this.generateTagValues();
            ServerPlayer player = event.getPlayer();
            PacketSetClientRadioactiveFluids packet = new PacketSetClientRadioactiveFluids(this.radioactiveFluidMap);
            PacketDistributor.PacketTarget target = player == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> player);
            channel.send(target, (Object)packet);
        };
    }

    public void setClientValues(HashMap<Fluid, RadioactiveObject> mappedValues) {
        this.radioactiveFluidMap.clear();
        this.radioactiveFluidMap.putAll(mappedValues);
    }

    public static HashMap<Fluid, RadioactiveObject> getValues() {
        return RadioactiveFluidRegister.INSTANCE.radioactiveFluidMap;
    }

    public static RadioactiveObject getValue(Fluid fluid) {
        return RadioactiveFluidRegister.INSTANCE.radioactiveFluidMap.getOrDefault(fluid, RadioactiveObject.ZERO);
    }

    private static boolean isJson(ResourceLocation filename) {
        return filename.m_135815_().contains("radioactive_fluids.json");
    }
}

