/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import voltaic.api.network.ITickableNetwork;
import voltaic.api.network.util.AbstractNetworkFinder;
import voltaic.common.network.NetworkRegistry;
import voltaic.prefab.tile.types.GenericRefreshingConnectTile;

public abstract class AbstractNetwork<C extends GenericRefreshingConnectTile<T, C, TYPE>, T, P, TYPE extends AbstractNetwork<C, T, P, TYPE>>
implements ITickableNetwork {
    private final UUID id = UUID.randomUUID();
    public final HashSet<C> conductorSet = new HashSet();
    public final HashSet<BlockEntity> acceptorSet = new HashSet();
    public final HashMap<BlockEntity, HashSet<Direction>> acceptorInputMap = new HashMap();
    public double networkMaxTransfer;
    public double transmittedLastTick;
    public double transmittedThisTick;

    public void updateRecievers(List<GenericRefreshingConnectTile.UpdatedReceiver> receivers) {
        boolean updateRecieverStatistics = false;
        for (GenericRefreshingConnectTile.UpdatedReceiver receiver : receivers) {
            if (receiver.reciever() == null) continue;
            updateRecieverStatistics = this.updateReceiver(receiver.reciever(), receiver.removed(), receiver.dir());
        }
        if (updateRecieverStatistics) {
            this.resetReceiverStatistics();
            for (BlockEntity entity : this.acceptorSet) {
                for (Direction dir : this.acceptorInputMap.getOrDefault(entity, new HashSet())) {
                    this.updateRecieverStatistics(entity, dir);
                }
            }
        }
    }

    private boolean updateReceiver(BlockEntity entity, boolean remove, Direction dir) {
        if (remove) {
            if (!entity.m_58901_() && this.acceptorInputMap.containsKey(entity)) {
                HashSet<Direction> dirs = this.acceptorInputMap.get(entity);
                dirs.remove(dir.m_122424_());
                this.acceptorInputMap.put(entity, dirs);
            } else if (entity.m_58901_()) {
                this.acceptorSet.remove(entity);
                this.acceptorInputMap.remove(entity);
                return true;
            }
        } else {
            this.acceptorSet.add(entity);
            HashSet<Direction> dirs = this.acceptorInputMap.getOrDefault(entity, new HashSet());
            dirs.add(dir.m_122424_());
            this.acceptorInputMap.put(entity, dirs);
            this.updateRecieverStatistics(entity, dir);
        }
        return false;
    }

    public void updateConductors(List<GenericRefreshingConnectTile.UpdatedConductor<C>> conductors) {
        boolean updateConductorStatistics = false;
        for (GenericRefreshingConnectTile.UpdatedConductor<C> conductor : conductors) {
            if (conductor.conductor() == null) continue;
            updateConductorStatistics = this.updateConductor((GenericRefreshingConnectTile)conductor.conductor(), conductor.removed());
        }
        if (updateConductorStatistics) {
            this.resetConductorStatistics();
            for (GenericRefreshingConnectTile.UpdatedConductor<C> conductor : this.conductorSet) {
                this.updateConductorStatistics(conductor, false);
            }
        }
    }

    public boolean updateConductor(C conductor, boolean remove) {
        boolean updateConductorStatistics = false;
        if (remove) {
            updateConductorStatistics = true;
        } else {
            this.conductorSet.add(conductor);
            ((GenericRefreshingConnectTile)conductor).setNetwork((AbstractNetwork)this);
            this.updateConductorStatistics(conductor, false);
        }
        int index = 0;
        ArrayList<GenericRefreshingConnectTile.UpdatedReceiver> receivers = new ArrayList<GenericRefreshingConnectTile.UpdatedReceiver>();
        for (BlockEntity entity : ((GenericRefreshingConnectTile)conductor).getConectedRecievers()) {
            if (entity == null) {
                ++index;
                continue;
            }
            receivers.add(new GenericRefreshingConnectTile.UpdatedReceiver(entity, remove, Direction.values()[index]));
            ++index;
        }
        this.updateRecievers(receivers);
        return updateConductorStatistics;
    }

    public void refreshNewNetwork() {
        Iterator<C> it = this.conductorSet.iterator();
        this.acceptorSet.clear();
        this.acceptorInputMap.clear();
        while (it.hasNext()) {
            GenericRefreshingConnectTile conductor = (GenericRefreshingConnectTile)it.next();
            if (conductor == null || conductor.m_58901_()) {
                it.remove();
                continue;
            }
            conductor.setNetwork(this);
            int i = 0;
            for (BlockEntity acceptor : conductor.getConectedRecievers()) {
                if (acceptor == null) {
                    ++i;
                    continue;
                }
                Direction dir = Direction.values()[i];
                this.acceptorSet.add(acceptor);
                this.updateRecieverStatistics(acceptor, dir);
                HashSet<Direction> directions = this.acceptorInputMap.getOrDefault(acceptor, new HashSet());
                directions.add(dir.m_122424_());
                this.acceptorInputMap.put(acceptor, directions);
                ++i;
            }
        }
        this.updateNewNetworkStatistics();
    }

    public void updateNewNetworkStatistics() {
        for (GenericRefreshingConnectTile wire : this.conductorSet) {
            this.networkMaxTransfer = this.networkMaxTransfer == 0.0 ? wire.getMaxTransfer() : Math.min(this.networkMaxTransfer, wire.getMaxTransfer());
            this.updateConductorStatistics(wire, false);
        }
        for (BlockEntity reciever : this.acceptorSet) {
            for (Direction dir : this.acceptorInputMap.getOrDefault(reciever, new HashSet())) {
                this.updateRecieverStatistics(reciever, dir);
            }
        }
    }

    public void updateConductorStatistics(C cable, boolean remove) {
    }

    public void resetReceiverStatistics() {
    }

    public void resetConductorStatistics() {
    }

    public void updateRecieverStatistics(BlockEntity reciever, Direction dir) {
    }

    public void split(@Nonnull C splitPoint) {
        this.removeFromNetwork(splitPoint);
        BlockEntity[] connectedTiles = new BlockEntity[6];
        boolean[] dealtWith = new boolean[]{false, false, false, false, false, false};
        Level world = splitPoint.m_58904_();
        for (Direction direction : Direction.values()) {
            BlockEntity sideTile;
            int ordinal = direction.ordinal();
            BlockPos relative = splitPoint.m_58899_().m_121945_(direction);
            if (!world.m_46805_(relative) || (sideTile = world.m_7702_(relative)) == null) continue;
            connectedTiles[ordinal] = sideTile;
        }
        for (int index = 0; index < 6; ++index) {
            BlockEntity tile = connectedTiles[index];
            if (tile == null || !this.isConductor(tile, splitPoint) || dealtWith[index]) continue;
            HashSet explored = new AbstractNetworkFinder(world, tile.m_58899_(), this, splitPoint.m_58899_()).exploreNetwork();
            for (int i = index + 1; i < 6; ++i) {
                BlockEntity connection = connectedTiles[i];
                if (!this.isConductor(connection, (GenericRefreshingConnectTile)tile) || dealtWith[i] || !explored.contains(connection)) continue;
                dealtWith[i] = true;
            }
            explored.remove(splitPoint);
            TYPE newNetwork = this.createInstanceConductor(explored);
            ((AbstractNetwork)newNetwork).refreshNewNetwork();
        }
        this.deregister();
    }

    public void removeFromNetwork(C conductor) {
        this.conductorSet.remove(conductor);
        this.updateConductorStatistics(conductor, true);
        if (this.conductorSet.isEmpty()) {
            this.deregister();
        }
    }

    public void deregister() {
        this.conductorSet.clear();
        this.acceptorSet.clear();
        this.acceptorInputMap.clear();
        NetworkRegistry.deregister(this);
    }

    @Override
    public int getSize() {
        return this.conductorSet.size();
    }

    @Override
    public void tick() {
        this.transmittedLastTick = this.transmittedThisTick;
        this.transmittedThisTick = 0.0;
    }

    public double getActiveTransmitted() {
        return this.transmittedLastTick;
    }

    public double getNetworkMaxTransfer() {
        return this.networkMaxTransfer;
    }

    public abstract P emit(P var1, ArrayList<BlockEntity> var2, boolean var3);

    public abstract boolean isConductor(BlockEntity var1, C var2);

    public abstract TYPE createInstanceConductor(Set<C> var1);

    public boolean equals(Object obj) {
        if (obj instanceof AbstractNetwork) {
            AbstractNetwork network = (AbstractNetwork)obj;
            return network.id.equals(this.id);
        }
        return false;
    }

    @Override
    public UUID getId() {
        return this.id;
    }
}

