/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.properties.types;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import voltaic.api.codec.StreamCodec;
import voltaic.prefab.properties.types.IPropertyType;

public class ArrayPropertyType<TYPE, BUFFERTYPE extends ByteBuf>
implements IPropertyType<TYPE[], BUFFERTYPE> {
    private final BiPredicate<TYPE, TYPE> singleComparison;
    private final BiPredicate<TYPE[], TYPE[]> comparison;
    private final StreamCodec<BUFFERTYPE, TYPE[]> packetCodec;
    private final Consumer<IPropertyType.TagWriter<TYPE[]>> writeToNbt;
    private final Function<IPropertyType.TagReader<TYPE[]>, TYPE[]> readFromNbt;

    public ArrayPropertyType(@Nonnull BiPredicate<TYPE, TYPE> singleComparison, final StreamCodec<BUFFERTYPE, TYPE> singlePacketCodec, Codec<TYPE> singleNbtCodec, final TYPE[] defaultArr, final TYPE defaultValue) {
        this.singleComparison = singleComparison;
        this.comparison = (arr1, arr2) -> {
            if (arr1 == null || arr2 == null) {
                return false;
            }
            if (((Object[])arr1).length != ((Object[])arr2).length) {
                return false;
            }
            for (int i = 0; i < ((Object[])arr1).length; ++i) {
                if (singleComparison.test(arr1[i], arr2[i])) continue;
                return false;
            }
            return true;
        };
        this.packetCodec = new StreamCodec<BUFFERTYPE, TYPE[]>(){

            @Override
            public TYPE[] decode(BUFFERTYPE buffer) {
                int size = buffer.readInt();
                Object[] newArr = Arrays.copyOf(defaultArr, size);
                Arrays.fill(newArr, defaultValue);
                for (int i = 0; i < size; ++i) {
                    newArr[i] = singlePacketCodec.decode(buffer);
                }
                return newArr;
            }

            @Override
            public void encode(BUFFERTYPE buffer, TYPE[] value) {
                buffer.writeInt(value.length);
                for (int i = 0; i < value.length; ++i) {
                    singlePacketCodec.encode(buffer, value[i]);
                }
            }
        };
        this.writeToNbt = writer -> {
            CompoundTag tag = new CompoundTag();
            Object[] arr = (Object[])writer.prop().getValue();
            tag.m_128405_("size", arr.length);
            for (int i = 0; i < arr.length; ++i) {
                int index = i;
                singleNbtCodec.encode(arr[i], (DynamicOps)NbtOps.f_128958_, (Object)NbtOps.f_128958_.empty()).result().ifPresent(nbt -> tag.m_128365_("" + index, nbt));
            }
            writer.tag().m_128365_(writer.prop().getName(), (Tag)tag);
        };
        this.readFromNbt = reader -> {
            CompoundTag data = reader.tag().m_128469_(reader.prop().getName());
            if (!data.m_128441_("size")) {
                return (Object[])reader.prop().getValue();
            }
            int size = data.m_128451_("size");
            if (size <= 0) {
                return Arrays.copyOf(defaultArr, defaultArr.length);
            }
            Object[] newArr = Arrays.copyOf(defaultArr, size);
            Arrays.fill(newArr, defaultValue);
            for (int i = 0; i < size; ++i) {
                int index = i;
                singleNbtCodec.decode((DynamicOps)NbtOps.f_128958_, (Object)data.m_128423_("" + i)).result().ifPresent(pair -> {
                    newArr[index] = pair.getFirst();
                });
            }
            return newArr;
        };
    }

    @Override
    public StreamCodec<BUFFERTYPE, TYPE[]> getPacketCodec() {
        return this.packetCodec;
    }

    @Override
    public void writeToTag(IPropertyType.TagWriter<TYPE[]> writer) {
        this.writeToNbt.accept(writer);
    }

    @Override
    public TYPE[] readFromTag(IPropertyType.TagReader<TYPE[]> reader) {
        return this.readFromNbt.apply(reader);
    }

    @Override
    public boolean isEqual(TYPE[] currentValue, TYPE[] newValue) {
        return this.comparison.test(currentValue, newValue);
    }

    public boolean isSingleEqual(TYPE val1, TYPE val2) {
        return this.singleComparison.test(val1, val2);
    }
}

