/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.screen.component.types.gauges;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import voltaic.Voltaic;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.IGasHandlerItem;
import voltaic.api.gas.PropertyGasTank;
import voltaic.api.gas.utils.IGasTank;
import voltaic.api.screen.ITexture;
import voltaic.client.VoltaicClientRegister;
import voltaic.common.packet.NetworkHandler;
import voltaic.common.packet.types.server.PacketUpdateCarriedItemServer;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.inventory.container.types.GenericContainerBlockEntity;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.ScreenComponentGeneric;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.VoltaicTextUtils;
import voltaic.registers.VoltaicCapabilities;
import voltaic.registers.VoltaicSounds;

public class ScreenComponentGasGauge
extends ScreenComponentGeneric {
    public static final ResourceLocation TEXTURE = Voltaic.rl("textures/screen/component/gas.png");
    public final Supplier<IGasTank> gasTank;

    public ScreenComponentGasGauge(Supplier<IGasTank> gasStack, int x, int y) {
        super(GasGaugeTextures.BACKGROUND_DEFAULT, x, y);
        this.gasTank = gasStack;
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        super.renderBackground(graphics, xAxis, yAxis, guiWidth, guiHeight);
        IGasTank tank = this.gasTank.get();
        if (tank != null) {
            ScreenComponentGasGauge.renderMercuryTexture(graphics, guiWidth + this.xLocation + 1, guiHeight + this.yLocation + 1, (float)tank.getGasAmount() / (float)tank.getCapacity());
        }
        GasGaugeTextures texture = GasGaugeTextures.LEVEL_DEFAULT;
        graphics.m_280163_(texture.getLocation(), guiWidth + this.xLocation, guiHeight + this.yLocation + 1, (float)texture.textureU(), (float)texture.textureV(), texture.textureWidth(), texture.textureHeight(), texture.imageWidth(), texture.imageHeight());
    }

    @Override
    public void renderForeground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        if (this.isPointInRegion(this.xLocation, this.yLocation, xAxis, yAxis, this.texture.textureWidth(), this.texture.textureHeight())) {
            IGasTank tank = this.gasTank.get();
            ArrayList<FormattedCharSequence> tooltips = new ArrayList<FormattedCharSequence>();
            if (tank == null) {
                return;
            }
            GasStack gas = tank.getGas();
            if (gas.isEmpty()) {
                tooltips.add(VoltaicTextUtils.ratio((Component)Component.m_237113_((String)"0"), (Component)ChatFormatter.formatFluidMilibuckets(tank.getCapacity())).m_130940_(ChatFormatting.GRAY).m_7532_());
            } else {
                tooltips.add(gas.getGas().getDescription().m_7532_());
                tooltips.add(VoltaicTextUtils.ratio((Component)ChatFormatter.formatFluidMilibuckets(tank.getGasAmount()), (Component)ChatFormatter.formatFluidMilibuckets(tank.getCapacity())).m_130940_(ChatFormatting.GRAY).m_7532_());
                tooltips.add(ChatFormatter.getChatDisplayShort(gas.getTemperature(), DisplayUnits.TEMPERATURE_KELVIN).m_130940_(ChatFormatting.GRAY).m_7532_());
                tooltips.add(ChatFormatter.getChatDisplayShort(gas.getPressure(), DisplayUnits.PRESSURE_ATM).m_130940_(ChatFormatting.GRAY).m_7532_());
            }
            graphics.m_280245_(this.gui.getFontRenderer(), tooltips, xAxis, yAxis);
        }
    }

    public static void renderMercuryTexture(GuiGraphics graphics, int x, int y, float progress) {
        TextureAtlasSprite mercury = VoltaicClientRegister.getSprite(VoltaicClientRegister.TEXTURE_MERCURY);
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        RenderingUtils.bindTexture(mercury.m_247685_());
        int height = (int)(progress * 47.0f);
        int x1 = x;
        int x2 = x1 + 12;
        int y1 = y + 47 - height;
        int y2 = y1 + height;
        float minU = mercury.m_118409_();
        float maxU = mercury.m_118410_();
        float minV = mercury.m_118411_();
        float maxV = mercury.m_118412_();
        float deltaV = maxV - minV;
        minV = maxV - deltaV * progress;
        RenderSystem.setShader(GameRenderer::m_172817_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix, (float)x1, (float)y2, 0.0f).m_7421_(minU, maxV).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)x2, (float)y2, 0.0f).m_7421_(maxU, maxV).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)x2, (float)y1, 0.0f).m_7421_(maxU, minV).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)x1, (float)y1, 0.0f).m_7421_(minU, minV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isActiveAndVisible() && this.isValidClick(button) && this.isInClickRegion(mouseX, mouseY)) {
            this.onMouseClick(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.isValidClick(button)) {
            this.onMouseRelease(mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Override
    public void onMouseClick(double mouseX, double mouseY) {
        PropertyGasTank tank = (PropertyGasTank)this.gasTank.get();
        if (tank == null) {
            return;
        }
        GenericScreen screen = (GenericScreen)this.gui;
        GenericTile owner = (GenericTile)((GenericContainerBlockEntity)screen.m_6262_()).getSafeHost();
        if (owner == null) {
            return;
        }
        ItemStack stack = ((GenericContainer)screen.m_6262_()).m_142621_();
        if (stack.m_41619_() || stack.m_41784_().m_128471_("hasclickedonfluidgauge")) {
            return;
        }
        GasStack drainedGasSource = tank.getGas().copy();
        IGasHandlerItem handler = stack.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).resolve().orElse(CapabilityUtils.EMPTY_GAS_ITEM);
        if (handler == CapabilityUtils.EMPTY_GAS_ITEM) {
            return;
        }
        int taken = handler.fill(drainedGasSource, GasAction.EXECUTE);
        if (taken > 0) {
            tank.drain(taken, GasAction.EXECUTE);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)VoltaicSounds.SOUND_PRESSURERELEASE.get()), (float)1.0f));
            stack = handler.getContainer();
            stack.m_41784_().m_128379_("hasclickedonfluidgauge", true);
            NetworkHandler.CHANNEL.sendToServer((Object)new PacketUpdateCarriedItemServer(stack.m_41777_(), ((GenericContainerBlockEntity)screen.m_6262_()).getSafeHost().m_58899_(), Minecraft.m_91087_().f_91074_.m_20148_()));
            ((GenericContainer)screen.m_6262_()).m_142503_(stack);
            return;
        }
        for (int i = 0; i < handler.getTanks(); ++i) {
            drainedGasSource = handler.getGasInTank(i);
            taken = tank.fill(drainedGasSource, GasAction.EXECUTE);
            if (taken <= 0) continue;
            handler.drain(taken, GasAction.EXECUTE);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)VoltaicSounds.SOUND_PRESSURERELEASE.get()), (float)1.0f));
            stack = handler.getContainer();
            stack.m_41784_().m_128379_("hasclickedonfluidgauge", true);
            NetworkHandler.CHANNEL.sendToServer((Object)new PacketUpdateCarriedItemServer(stack.m_41777_(), ((GenericContainerBlockEntity)screen.m_6262_()).getSafeHost().m_58899_(), Minecraft.m_91087_().f_91074_.m_20148_()));
            ((GenericContainer)screen.m_6262_()).m_142503_(stack);
            return;
        }
    }

    public static enum GasGaugeTextures implements ITexture
    {
        BACKGROUND_DEFAULT(14, 49, 0, 0, 256, 256, TEXTURE),
        LEVEL_DEFAULT(14, 49, 14, 0, 256, 256, TEXTURE);

        private final int textureWidth;
        private final int textureHeight;
        private final int textureU;
        private final int textureV;
        private final int imageWidth;
        private final int imageHeight;
        private final ResourceLocation loc;

        private GasGaugeTextures(int textureWidth, int textureHeight, int textureU, int textureV, int imageWidth, int imageHeight, ResourceLocation loc) {
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.textureU = textureU;
            this.textureV = textureV;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.loc = loc;
        }

        @Override
        public ResourceLocation getLocation() {
            return this.loc;
        }

        @Override
        public int imageHeight() {
            return this.imageHeight;
        }

        @Override
        public int imageWidth() {
            return this.imageWidth;
        }

        @Override
        public int textureHeight() {
            return this.textureHeight;
        }

        @Override
        public int textureU() {
            return this.textureU;
        }

        @Override
        public int textureV() {
            return this.textureV;
        }

        @Override
        public int textureWidth() {
            return this.textureWidth;
        }
    }
}

