/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.tile.components.type;

import java.util.HashSet;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;
import voltaic.api.electricity.ICapabilityElectrodynamic;
import voltaic.api.item.IItemElectric;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.CapabilityInputType;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.TransferPack;

public class ComponentElectrodynamic
implements IComponent,
ICapabilityElectrodynamic {
    protected GenericTile holder;
    protected BiFunction<TransferPack, Boolean, TransferPack> functionReceivePower = (x$0, x$1) -> ICapabilityElectrodynamic.super.receivePower((TransferPack)x$0, (boolean)x$1);
    protected BiFunction<TransferPack, Boolean, TransferPack> functionExtractPower = (x$0, x$1) -> ICapabilityElectrodynamic.super.extractPower((TransferPack)x$0, (boolean)x$1);
    protected BiFunction<ICapabilityElectrodynamic.LoadProfile, Direction, TransferPack> connectedLoadFunction = (profile, dir) -> TransferPack.joulesVoltage(this.getMaxJoulesStored() - this.getJoulesStored(), this.getVoltage());
    protected Supplier<Double> ampacityFunction = () -> ICapabilityElectrodynamic.super.getAmpacity();
    protected Supplier<Double> minimumVoltageFunction = () -> ICapabilityElectrodynamic.super.getMinimumVoltage();
    protected Supplier<Double> maximumVoltageFunction = () -> ICapabilityElectrodynamic.super.getMaximumVoltage();
    protected Consumer<Double> setJoules = null;
    protected HashSet<Direction> relativeOutputDirections = new HashSet();
    protected HashSet<Direction> relativeInputDirections = new HashSet();
    protected SingleProperty<Double> voltage;
    protected SingleProperty<Double> maxJoules;
    protected SingleProperty<Double> joules;
    protected DoubleSupplier getJoules = () -> (Double)this.joules.getValue();
    protected BooleanSupplier hasCapability = () -> true;
    private boolean producesEnergy = false;
    private boolean acceptsEnergy = true;
    private boolean isSided = false;
    private ICapabilityElectrodynamic[] sidedOptionals = new ICapabilityElectrodynamic[6];
    @Nullable
    private ICapabilityElectrodynamic inputOptional = null;
    @Nullable
    private ICapabilityElectrodynamic outputOptional = null;

    public ComponentElectrodynamic(GenericTile source, boolean isProducer, boolean isReceiver) {
        this.producesEnergy = isProducer;
        this.acceptsEnergy = isReceiver;
        this.holder(source);
        this.voltage = source.property(new SingleProperty<Double>(PropertyTypes.DOUBLE, "voltage", Double.valueOf(120.0)));
        this.maxJoules = source.property(new SingleProperty<Double>(PropertyTypes.DOUBLE, "maxJoules", Double.valueOf(0.0)));
        this.joules = source.property(new SingleProperty<Double>(PropertyTypes.DOUBLE, "joules", Double.valueOf(0.0)));
    }

    @Override
    public void holder(GenericTile holder) {
        this.holder = holder;
    }

    @Override
    public GenericTile getHolder() {
        return this.holder;
    }

    @Override
    public double getVoltage() {
        return (Double)this.voltage.getValue();
    }

    @Override
    public double getMinimumVoltage() {
        return this.minimumVoltageFunction.get();
    }

    @Override
    public double getMaximumVoltage() {
        return this.maximumVoltageFunction.get();
    }

    @Override
    public boolean isEnergyProducer() {
        return this.producesEnergy;
    }

    @Override
    public boolean isEnergyReceiver() {
        return this.acceptsEnergy;
    }

    @Override
    @Deprecated(forRemoval=false, since="This is only if you need to force the internal joules count and is overriden in classes where you can do this.")
    public void setJoulesStored(double joules) {
        this.joules(joules);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side, CapabilityInputType inputType) {
        if (!this.isSided) {
            return LazyOptional.of(() -> this).cast();
        }
        if (side == null) {
            return LazyOptional.empty();
        }
        ICapabilityElectrodynamic cap = this.sidedOptionals[side.ordinal()];
        return cap == null ? LazyOptional.empty() : LazyOptional.of(() -> cap).cast();
    }

    @Override
    public void refreshIfUpdate(BlockState oldState, BlockState newState) {
        if (this.isSided && oldState.m_61138_((Property)VoltaicBlockStates.FACING) && newState.m_61138_((Property)VoltaicBlockStates.FACING) && oldState.m_61143_((Property)VoltaicBlockStates.FACING) != newState.m_61143_((Property)VoltaicBlockStates.FACING)) {
            this.defineOptionals((Direction)newState.m_61143_((Property)VoltaicBlockStates.FACING));
        }
    }

    @Override
    public void refresh() {
        this.defineOptionals(this.holder.getFacing());
    }

    private void defineOptionals(Direction facing) {
        this.holder.invalidateCaps();
        this.sidedOptionals = new ICapabilityElectrodynamic[6];
        this.inputOptional = null;
        this.outputOptional = null;
        if (this.isSided) {
            if (!this.relativeInputDirections.isEmpty()) {
                this.inputOptional = new InputCapabilityDispatcher(this);
                for (Direction dir : this.relativeInputDirections) {
                    this.sidedOptionals[BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)dir).ordinal()] = this.inputOptional;
                }
            }
            if (!this.relativeOutputDirections.isEmpty()) {
                this.outputOptional = new OutputCapabilityDispatcher(this);
                for (Direction dir : this.relativeOutputDirections) {
                    this.sidedOptionals[BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)dir).ordinal()] = this.outputOptional;
                }
            }
        }
    }

    @Override
    public TransferPack extractPower(TransferPack transfer, boolean debug) {
        if (this.isEnergyProducer()) {
            return this.functionExtractPower.apply(transfer, debug);
        }
        return TransferPack.EMPTY;
    }

    @Override
    public TransferPack receivePower(TransferPack transfer, boolean debug) {
        if (this.isEnergyReceiver()) {
            return this.functionReceivePower.apply(transfer, debug);
        }
        return TransferPack.EMPTY;
    }

    @Override
    public TransferPack getConnectedLoad(ICapabilityElectrodynamic.LoadProfile loadProfile, Direction dir) {
        if (this.isEnergyReceiver()) {
            return this.connectedLoadFunction.apply(loadProfile, dir);
        }
        return TransferPack.EMPTY;
    }

    public ComponentElectrodynamic joules(double joules) {
        if (this.setJoules != null) {
            this.setJoules.accept(joules);
        } else {
            this.joules.setValue(Math.max(0.0, Math.min((Double)this.maxJoules.getValue(), joules)));
        }
        if (joules != 0.0) {
            this.onChange();
        }
        return this;
    }

    public ComponentElectrodynamic maxJoules(double maxJoules) {
        this.maxJoules.setValue(Math.max(maxJoules, 0.0));
        if ((Double)this.joules.getValue() > maxJoules) {
            this.joules.setValue(maxJoules);
        }
        return this;
    }

    public ComponentElectrodynamic setInputDirections(BlockEntityUtils.MachineDirection ... dirs) {
        this.isSided = true;
        for (BlockEntityUtils.MachineDirection dir : dirs) {
            this.relativeInputDirections.add(dir.mappedDir);
        }
        return this;
    }

    public ComponentElectrodynamic setOutputDirections(BlockEntityUtils.MachineDirection ... dirs) {
        this.isSided = true;
        for (BlockEntityUtils.MachineDirection dir : dirs) {
            this.relativeOutputDirections.add(dir.mappedDir);
        }
        return this;
    }

    public ComponentElectrodynamic receivePower(BiFunction<TransferPack, Boolean, TransferPack> receivePower) {
        this.functionReceivePower = receivePower;
        return this;
    }

    public ComponentElectrodynamic extractPower(BiFunction<TransferPack, Boolean, TransferPack> extractPower) {
        this.functionExtractPower = extractPower;
        return this;
    }

    public ComponentElectrodynamic getConnectedLoad(BiFunction<ICapabilityElectrodynamic.LoadProfile, Direction, TransferPack> supplier) {
        this.connectedLoadFunction = supplier;
        return this;
    }

    public ComponentElectrodynamic getAmpacity(Supplier<Double> supplier) {
        this.ampacityFunction = supplier;
        return this;
    }

    public ComponentElectrodynamic getMinimumVoltage(Supplier<Double> supplier) {
        this.minimumVoltageFunction = supplier;
        return this;
    }

    public ComponentElectrodynamic getMaximumVoltage(Supplier<Double> supplier) {
        this.maximumVoltageFunction = supplier;
        return this;
    }

    public ComponentElectrodynamic setJoules(Consumer<Double> setJoules) {
        this.setJoules = setJoules;
        return this;
    }

    public ComponentElectrodynamic getJoules(DoubleSupplier getJoules) {
        this.getJoules = getJoules;
        return this;
    }

    public ComponentElectrodynamic voltage(double voltage) {
        this.voltage.setValue(voltage);
        return this;
    }

    public ComponentElectrodynamic drainElectricItem(int slot) {
        IItemElectric electric;
        TransferPack pack;
        ComponentInventory inventory;
        ItemStack stack;
        Item item;
        if (this.holder.hasComponent(IComponentType.Inventory) && (item = (stack = (inventory = (ComponentInventory)this.holder.getComponent(IComponentType.Inventory)).m_8020_(slot)).m_41720_()) instanceof IItemElectric && (pack = this.functionReceivePower.apply((electric = (IItemElectric)item).extractPower(stack, (Double)this.maxJoules.getValue() - (Double)this.joules.getValue(), false), false)) != TransferPack.EMPTY) {
            this.onChange();
        }
        return this;
    }

    public ComponentElectrodynamic fillElectricItem(int slot) {
        ComponentInventory inventory;
        ItemStack stack;
        Item item;
        if (this.holder.hasComponent(IComponentType.Inventory) && (item = (stack = (inventory = (ComponentInventory)this.holder.getComponent(IComponentType.Inventory)).m_8020_(slot)).m_41720_()) instanceof IItemElectric) {
            IItemElectric electric = (IItemElectric)item;
            this.functionExtractPower.apply(electric.receivePower(stack, TransferPack.joulesVoltage((Double)this.joules.getValue(), (Double)this.voltage.getValue()), false), false);
        }
        return this;
    }

    @Override
    public double getJoulesStored() {
        return this.getJoules.getAsDouble();
    }

    @Override
    public double getMaxJoulesStored() {
        return (Double)this.maxJoules.getValue();
    }

    @Override
    public double getAmpacity() {
        return this.ampacityFunction.get();
    }

    @Override
    public void overVoltage(TransferPack transfer) {
        Level world = this.holder.m_58904_();
        BlockPos pos = this.holder.m_58899_();
        world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        world.m_254849_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (float)Math.log10(10.0 + transfer.getVoltage() / this.getVoltage()), Level.ExplosionInteraction.BLOCK);
    }

    @Override
    public IComponentType getType() {
        return IComponentType.Electrodynamic;
    }

    public ComponentElectrodynamic setCapabilityTest(BooleanSupplier test) {
        this.hasCapability = test;
        return this;
    }

    @Override
    public void onChange() {
        if (this.holder != null) {
            this.holder.onEnergyChange(this);
        }
    }

    private static class InputCapabilityDispatcher
    implements ICapabilityElectrodynamic {
        private ComponentElectrodynamic parent;

        public InputCapabilityDispatcher(ComponentElectrodynamic parent) {
            this.parent = parent;
        }

        @Override
        public double getJoulesStored() {
            return this.parent.getJoulesStored();
        }

        @Override
        public double getMaxJoulesStored() {
            return this.parent.getMaxJoulesStored();
        }

        @Override
        public void setJoulesStored(double joules) {
            this.parent.setJoulesStored(joules);
        }

        @Override
        public double getVoltage() {
            return this.parent.getVoltage();
        }

        @Override
        public double getMinimumVoltage() {
            return this.parent.getMinimumVoltage();
        }

        @Override
        public double getMaximumVoltage() {
            return this.parent.getMaximumVoltage();
        }

        @Override
        public double getAmpacity() {
            return this.parent.getAmpacity();
        }

        @Override
        public boolean isEnergyReceiver() {
            return true;
        }

        @Override
        public boolean isEnergyProducer() {
            return false;
        }

        @Override
        public TransferPack extractPower(TransferPack transfer, boolean debug) {
            return TransferPack.EMPTY;
        }

        @Override
        public TransferPack receivePower(TransferPack transfer, boolean debug) {
            return this.parent.receivePower(transfer, debug);
        }

        @Override
        public void overVoltage(TransferPack transfer) {
            this.parent.overVoltage(transfer);
        }

        @Override
        public void onChange() {
            this.parent.onChange();
        }

        @Override
        public TransferPack getConnectedLoad(ICapabilityElectrodynamic.LoadProfile loadProfile, Direction dir) {
            return this.parent.getConnectedLoad(loadProfile, dir);
        }
    }

    private static class OutputCapabilityDispatcher
    implements ICapabilityElectrodynamic {
        private ComponentElectrodynamic parent;

        public OutputCapabilityDispatcher(ComponentElectrodynamic parent) {
            this.parent = parent;
        }

        @Override
        public double getJoulesStored() {
            return this.parent.getJoulesStored();
        }

        @Override
        public double getMaxJoulesStored() {
            return this.parent.getMaxJoulesStored();
        }

        @Override
        public void setJoulesStored(double joules) {
            this.parent.setJoulesStored(joules);
        }

        @Override
        public double getVoltage() {
            return this.parent.getVoltage();
        }

        @Override
        public double getMinimumVoltage() {
            return this.parent.getMinimumVoltage();
        }

        @Override
        public double getMaximumVoltage() {
            return this.parent.getMaximumVoltage();
        }

        @Override
        public double getAmpacity() {
            return this.parent.getAmpacity();
        }

        @Override
        public boolean isEnergyReceiver() {
            return false;
        }

        @Override
        public boolean isEnergyProducer() {
            return true;
        }

        @Override
        public TransferPack extractPower(TransferPack transfer, boolean debug) {
            return this.parent.extractPower(transfer, debug);
        }

        @Override
        public TransferPack receivePower(TransferPack transfer, boolean debug) {
            return TransferPack.EMPTY;
        }

        @Override
        public void overVoltage(TransferPack transfer) {
            this.parent.overVoltage(transfer);
        }

        @Override
        public void onChange() {
            this.parent.onChange();
        }

        @Override
        public TransferPack getConnectedLoad(ICapabilityElectrodynamic.LoadProfile loadProfile, Direction dir) {
            return TransferPack.EMPTY;
        }
    }
}

