/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.tile.components.type;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import voltaic.api.fluid.PropertyFluidTank;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.common.recipe.VoltaicRecipe;
import voltaic.common.recipe.recipeutils.AbstractMaterialRecipe;
import voltaic.common.recipe.recipeutils.FluidIngredient;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.CapabilityInputType;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.utils.IComponentFluidHandler;
import voltaic.prefab.utilities.BlockEntityUtils;

public class ComponentFluidHandlerMulti
implements IComponentFluidHandler {
    private GenericTile holder;
    @Nullable
    public Direction[] inputDirections;
    @Nullable
    public Direction[] outputDirections;
    private boolean isSided = false;
    private PropertyFluidTank[] inputTanks = new PropertyFluidTank[0];
    private PropertyFluidTank[] outputTanks = new PropertyFluidTank[0];
    @Nullable
    private RecipeType<? extends AbstractMaterialRecipe> recipeType;
    @Nullable
    private TagKey<Fluid>[] validInputFluidTags;
    @Nullable
    private Fluid[] validInputFluids;
    private HashSet<Fluid> inputValidatorFluids = new HashSet();
    @Nullable
    private TagKey<Fluid>[] validOutputFluidTags;
    @Nullable
    private Fluid[] validOutputFluids;
    private HashSet<Fluid> outputValidatorFluids = new HashSet();
    private IFluidHandler[] sidedOptionals = new IFluidHandler[6];
    @Nullable
    private IFluidHandler inputOptional = null;
    @Nullable
    private IFluidHandler outputOptional = null;

    public ComponentFluidHandlerMulti(GenericTile holder) {
        this.holder = holder;
        if (!holder.m_58900_().m_61138_((Property)VoltaicBlockStates.FACING)) {
            throw new UnsupportedOperationException("The tile " + holder + " must have the FACING direction property!");
        }
    }

    public ComponentFluidHandlerMulti setInputTanks(int count, int ... capacity) {
        this.inputTanks = new PropertyFluidTank[count];
        if (capacity.length < count) {
            throw new UnsupportedOperationException("The number of capacities does not match the number of input tanks");
        }
        for (int i = 0; i < count; ++i) {
            this.inputTanks[i] = new PropertyFluidTank(capacity[i], this.holder, "input" + i);
        }
        return this;
    }

    public ComponentFluidHandlerMulti setOutputTanks(int count, int ... capacity) {
        this.outputTanks = new PropertyFluidTank[count];
        if (capacity.length < count) {
            throw new UnsupportedOperationException("The number of capacities does not match the number of output tanks");
        }
        for (int i = 0; i < count; ++i) {
            this.outputTanks[i] = new PropertyFluidTank(capacity[i], this.holder, "output" + i);
        }
        return this;
    }

    public ComponentFluidHandlerMulti setTanks(int inputCount, int outputCount, int[] inputCapacity, int[] outputCapacity) {
        return this.setInputTanks(inputCount, inputCapacity).setOutputTanks(outputCount, outputCapacity);
    }

    public ComponentFluidHandlerMulti setInputFluids(Fluid ... fluids) {
        this.validInputFluids = fluids;
        return this;
    }

    public ComponentFluidHandlerMulti setInputFluidTags(TagKey<Fluid> ... fluids) {
        this.validInputFluidTags = fluids;
        return this;
    }

    public ComponentFluidHandlerMulti setOutputFluids(Fluid ... fluids) {
        this.validOutputFluids = fluids;
        return this;
    }

    public ComponentFluidHandlerMulti setOutputFluidTags(TagKey<Fluid> ... fluids) {
        this.validOutputFluidTags = fluids;
        return this;
    }

    public ComponentFluidHandlerMulti setInputDirections(BlockEntityUtils.MachineDirection ... directions) {
        this.inputDirections = BlockEntityUtils.MachineDirection.toDirectionArray(directions);
        this.isSided = true;
        return this;
    }

    public ComponentFluidHandlerMulti setOutputDirections(BlockEntityUtils.MachineDirection ... directions) {
        this.outputDirections = BlockEntityUtils.MachineDirection.toDirectionArray(directions);
        this.isSided = true;
        return this;
    }

    public ComponentFluidHandlerMulti setRecipeType(RecipeType<? extends AbstractMaterialRecipe> recipeType) {
        this.recipeType = recipeType;
        return this;
    }

    public int tankCount(boolean input) {
        if (input) {
            return this.inputTanks == null ? 0 : this.inputTanks.length;
        }
        return this.outputTanks == null ? 0 : this.outputTanks.length;
    }

    public FluidStack getFluidInTank(int tank, boolean input) {
        if (input) {
            return this.inputTanks[tank].getFluid();
        }
        return this.outputTanks[tank].getFluid();
    }

    @Nullable
    public PropertyFluidTank getTankFromFluid(Fluid fluid, boolean isInput) {
        if (isInput) {
            for (PropertyFluidTank tank : this.inputTanks) {
                if (!tank.getFluid().getFluid().m_6212_(fluid)) continue;
                return tank;
            }
            for (PropertyFluidTank tank : this.inputTanks) {
                if (!tank.isEmpty()) continue;
                return tank;
            }
        }
        for (PropertyFluidTank tank : this.outputTanks) {
            if (!tank.getFluid().getFluid().m_6212_(fluid)) continue;
            return tank;
        }
        for (PropertyFluidTank tank : this.outputTanks) {
            if (!tank.isEmpty()) continue;
            return tank;
        }
        return null;
    }

    public int getTankCapacity(int tank, boolean input) {
        if (input) {
            return this.inputTanks[tank].getCapacity();
        }
        return this.outputTanks[tank].getCapacity();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack, boolean input) {
        if (input) {
            return this.inputTanks[tank].isFluidValid(stack);
        }
        return this.outputTanks[tank].isFluidValid(stack);
    }

    public int fill(int tank, FluidStack resource, IFluidHandler.FluidAction action, boolean input) {
        if (input) {
            return this.inputTanks[tank].fill(resource, action);
        }
        return this.outputTanks[tank].fill(resource, action);
    }

    @NotNull
    public FluidStack drain(int tank, FluidStack resource, IFluidHandler.FluidAction action, boolean input) {
        if (input) {
            return this.inputTanks[tank].drain(resource, action);
        }
        return this.outputTanks[tank].drain(resource, action);
    }

    @NotNull
    public FluidStack drain(int tank, int maxDrain, IFluidHandler.FluidAction action, boolean input) {
        if (input) {
            return this.inputTanks[tank].drain(maxDrain, action);
        }
        return this.outputTanks[tank].drain(maxDrain, action);
    }

    @Override
    public IComponentType getType() {
        return IComponentType.FluidHandler;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side, CapabilityInputType inputType) {
        if (side == null || !this.isSided) {
            return LazyOptional.empty();
        }
        IFluidHandler cap = this.sidedOptionals[side.ordinal()];
        return cap == null ? LazyOptional.empty() : LazyOptional.of(() -> cap).cast();
    }

    @Override
    public void refreshIfUpdate(BlockState oldState, BlockState newState) {
        if (this.isSided && oldState.m_61138_((Property)VoltaicBlockStates.FACING) && newState.m_61138_((Property)VoltaicBlockStates.FACING) && oldState.m_61143_((Property)VoltaicBlockStates.FACING) != newState.m_61143_((Property)VoltaicBlockStates.FACING)) {
            this.defineOptionals((Direction)newState.m_61143_((Property)VoltaicBlockStates.FACING));
        }
    }

    @Override
    public void refresh() {
        this.defineOptionals(this.holder.getFacing());
    }

    private void defineOptionals(Direction facing) {
        this.holder.invalidateCaps();
        this.sidedOptionals = new IFluidHandler[6];
        this.inputOptional = null;
        this.outputOptional = null;
        if (this.inputDirections != null) {
            this.inputOptional = new InputTankDispatcher(this.inputTanks);
            for (Direction dir : this.inputDirections) {
                this.sidedOptionals[BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)dir).ordinal()] = this.inputOptional;
            }
        }
        if (this.outputDirections != null) {
            this.outputOptional = new OutputTankDispatcher(this.outputTanks);
            for (Direction dir : this.outputDirections) {
                this.sidedOptionals[BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)dir).ordinal()] = this.outputOptional;
            }
        }
    }

    @Override
    public void holder(GenericTile holder) {
        this.holder = holder;
    }

    @Override
    public GenericTile getHolder() {
        return this.holder;
    }

    @Override
    public void onLoad() {
        IComponentFluidHandler.super.onLoad();
        if (this.recipeType != null) {
            int n;
            List<VoltaicRecipe> list = VoltaicRecipe.findRecipesbyType(this.recipeType, this.holder.m_58904_());
            ArrayList inputFluidHolder = new ArrayList();
            ArrayList<Fluid> outputFluidHohlder = new ArrayList<Fluid>();
            boolean bl = false;
            int maxFluidOutput = 0;
            int maxFluidBiproduct = 0;
            for (VoltaicRecipe iRecipe : list) {
                AbstractMaterialRecipe recipe = (AbstractMaterialRecipe)iRecipe;
                if (this.inputTanks != null) {
                    for (FluidIngredient ing : recipe.getFluidIngredients()) {
                        ing.getMatchingFluids().forEach(h -> inputFluidHolder.add(h.getFluid()));
                        if (ing.getFluidStack().getAmount() <= n) continue;
                        n = ing.getFluidStack().getAmount();
                    }
                }
                if (this.outputTanks == null) continue;
                outputFluidHohlder.add(recipe.getFluidRecipeOutput().getFluid());
                if (recipe.getFluidRecipeOutput().getAmount() > maxFluidOutput) {
                    maxFluidOutput = recipe.getFluidRecipeOutput().getAmount();
                }
                if (!recipe.hasFluidBiproducts()) continue;
                for (FluidStack stack : recipe.getFullFluidBiStacks()) {
                    outputFluidHohlder.add(stack.getFluid());
                    if (stack.getAmount() <= maxFluidBiproduct) continue;
                    maxFluidBiproduct = stack.getAmount();
                }
            }
            this.inputValidatorFluids.addAll(inputFluidHolder);
            this.outputValidatorFluids.addAll(outputFluidHohlder);
            if (n > 0) {
                void var4_22 = n / 1000 * 1000 + 1000;
                for (PropertyFluidTank tank : this.inputTanks) {
                    if (tank.getCapacity() >= var4_22) continue;
                    tank.setCapacity((int)var4_22);
                }
            }
            int offset = 0;
            if (maxFluidOutput > 0) {
                maxFluidOutput = maxFluidOutput / 1000 * 1000 + 1000;
                if (this.outputTanks[0].getCapacity() < maxFluidOutput) {
                    this.outputTanks[0].setCapacity(maxFluidOutput);
                }
                offset = 1;
            }
            if (maxFluidBiproduct > 0) {
                maxFluidBiproduct = maxFluidBiproduct / 1000 * 1000 + 1000;
                for (int i = 0; i < this.outputTanks.length - offset; ++i) {
                    if (this.outputTanks[i + offset].getCapacity() >= maxFluidBiproduct) continue;
                    this.outputTanks[i + offset].setCapacity(maxFluidBiproduct);
                }
            }
        } else {
            if (this.validInputFluids != null) {
                for (Fluid fluid : this.validInputFluids) {
                    this.inputValidatorFluids.add(fluid);
                }
            }
            if (this.validInputFluidTags != null) {
                for (TagKey<Fluid> tagKey : this.validInputFluidTags) {
                    ((HolderSet.Named)BuiltInRegistries.f_257020_.m_203431_(tagKey).get()).m_203614_().forEach(holder -> this.inputValidatorFluids.add((Fluid)holder.m_203334_()));
                }
            }
            if (this.validOutputFluids != null) {
                for (Fluid fluid : this.validOutputFluids) {
                    this.outputValidatorFluids.add(fluid);
                }
            }
            if (this.validOutputFluidTags != null) {
                for (TagKey<Fluid> tagKey : this.validOutputFluidTags) {
                    ((HolderSet.Named)BuiltInRegistries.f_257020_.m_203431_(tagKey).get()).m_203614_().forEach(holder -> this.outputValidatorFluids.add((Fluid)holder.m_203334_()));
                }
            }
        }
        if (!this.inputValidatorFluids.isEmpty()) {
            for (PropertyFluidTank propertyFluidTank : this.inputTanks) {
                propertyFluidTank.setValidator(fluidStack -> this.inputValidatorFluids.contains(fluidStack.getFluid()));
            }
        }
        if (!this.outputValidatorFluids.isEmpty()) {
            for (PropertyFluidTank propertyFluidTank : this.outputTanks) {
                propertyFluidTank.setValidator(fluidStack -> this.outputValidatorFluids.contains(fluidStack.getFluid()));
            }
        }
    }

    @Override
    public PropertyFluidTank[] getInputTanks() {
        return this.inputTanks;
    }

    @Override
    public PropertyFluidTank[] getOutputTanks() {
        return this.outputTanks;
    }

    private class InputTankDispatcher
    implements IFluidHandler {
        private PropertyFluidTank[] tanks;

        public InputTankDispatcher(PropertyFluidTank[] tanks) {
            this.tanks = tanks;
        }

        public int getTanks() {
            return this.tanks.length;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            if (tank >= this.getTanks()) {
                return FluidStack.EMPTY;
            }
            return this.tanks[tank].getFluid();
        }

        public int getTankCapacity(int tank) {
            if (tank >= this.getTanks()) {
                return 0;
            }
            return this.tanks[tank].getCapacity();
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            if (tank >= this.getTanks()) {
                return false;
            }
            return this.tanks[tank].isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            for (PropertyFluidTank tank : this.tanks) {
                if (!tank.getFluid().isFluidEqual(resource)) continue;
                return tank.fill(resource, action);
            }
            for (PropertyFluidTank tank : this.tanks) {
                if (!tank.isEmpty()) continue;
                return tank.fill(resource, action);
            }
            return 0;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }

    private class OutputTankDispatcher
    implements IFluidHandler {
        private PropertyFluidTank[] tanks;

        public OutputTankDispatcher(PropertyFluidTank[] tanks) {
            this.tanks = tanks;
        }

        public int getTanks() {
            return this.tanks.length;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            if (tank >= this.getTanks()) {
                return FluidStack.EMPTY;
            }
            return this.tanks[tank].getFluid();
        }

        public int getTankCapacity(int tank) {
            if (tank >= this.getTanks()) {
                return 0;
            }
            return this.tanks[tank].getCapacity();
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            for (PropertyFluidTank tank : this.tanks) {
                if (!tank.getFluid().isFluidEqual(resource)) continue;
                return tank.drain(resource, action);
            }
            return FluidStack.EMPTY;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }

    public static class ComponentFluidHandlerMultiBiDirec
    extends ComponentFluidHandlerMulti {
        private IFluidHandler[] inputSidedOptionals = new IFluidHandler[6];
        private IFluidHandler[] outputSidedOptionals = new IFluidHandler[6];

        public ComponentFluidHandlerMultiBiDirec(GenericTile holder) {
            super(holder);
        }

        @Override
        public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side, CapabilityInputType inputType) {
            if (side == null || this.inputDirections == null && this.outputDirections == null) {
                return LazyOptional.empty();
            }
            if (inputType == CapabilityInputType.INPUT) {
                return LazyOptional.of(() -> this.inputSidedOptionals[side.ordinal()]).cast();
            }
            return LazyOptional.of(() -> this.outputSidedOptionals[side.ordinal()]).cast();
        }

        @Override
        public void refresh() {
            this.holder.invalidateCaps();
            this.inputSidedOptionals = new IFluidHandler[6];
            this.outputSidedOptionals = new IFluidHandler[6];
            Direction facing = this.holder.getFacing();
            if (this.inputDirections != null) {
                this.inputOptional = new InputTankDispatcher(this.inputTanks);
                for (Direction dir : this.inputDirections) {
                    this.inputSidedOptionals[BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)dir).ordinal()] = this.inputOptional;
                }
            }
            if (this.outputDirections != null) {
                this.outputOptional = new OutputTankDispatcher(this.outputTanks);
                for (Direction dir : this.outputDirections) {
                    this.outputSidedOptionals[BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)dir).ordinal()] = this.outputOptional;
                }
            }
        }
    }
}

