/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.client.config.screen;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.client.ZetaClient;
import org.violetmoon.zeta.client.config.screen.AbstractInputScreen;
import org.violetmoon.zeta.config.ChangeSet;
import org.violetmoon.zeta.config.ValueDefinition;

public abstract class AbstractEditBoxInputScreen<T>
extends AbstractInputScreen<T> {
    protected EditBox input;
    protected int VALID_COLOR = 0xE0E0E0;
    protected int INVALID_COLOR = 0xDD3322;

    public AbstractEditBoxInputScreen(ZetaClient zc, Screen parent, ChangeSet changes, ValueDefinition<T> valueDef) {
        super(zc, parent, changes, valueDef);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)this.def.getTranslatedDisplayName(x$0 -> I18n.m_118938_((String)x$0, (Object[])new Object[0]))).m_130940_(ChatFormatting.BOLD), this.f_96543_ / 2, 20, 0xFFFFFF);
        guiGraphics.m_280137_(this.f_96547_, I18n.m_118938_((String)"quark.gui.config.defaultvalue", (Object[])new Object[]{this.def.defaultValue}), this.f_96543_ / 2, 30, 0xFFFFFF);
        this.input.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.input = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, 60, 200, 20, (Component)Component.m_237113_((String)""));
        this.input.m_94199_(this.maxStringLength());
        this.input.m_94151_(this::onEdit);
        this.forceUpdateWidgetsTo(this.get());
        this.m_264313_((GuiEventListener)this.input);
        this.m_7787_((GuiEventListener)this.input);
    }

    protected void onEdit(String newString) {
        T parsed = this.fromString(newString);
        if (parsed != null && this.def.validate(parsed) && newString.length() < this.maxStringLength()) {
            this.set(parsed);
            this.input.m_94202_(this.VALID_COLOR);
            this.updateButtonStatus(true);
        } else {
            this.input.m_94202_(this.INVALID_COLOR);
            this.updateButtonStatus(false);
        }
    }

    @Override
    protected void forceUpdateWidgetsTo(T value) {
        String asString = this.toString(value);
        T roundtrip = this.fromString(asString);
        if (roundtrip == null) {
            this.input.m_94144_(this.toString(this.def.defaultValue));
        } else {
            this.input.m_94144_(asString);
        }
        this.m_264313_((GuiEventListener)this.input);
    }

    protected String toString(T thing) {
        return thing.toString();
    }

    protected int maxStringLength() {
        return 256;
    }

    @Nullable
    protected abstract T fromString(String var1);
}

