/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.teamresourceful.resourcefullib.client.scissor.ClosingScissorBox;
import com.teamresourceful.resourcefullib.client.utils.RenderUtils;
import com.teamresourceful.resourcefullib.client.utils.ScreenUtils;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.utils.ClientFluidHooks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;

public class GuiUtils {
    public static final ResourceLocation ENERGY_BAR = new ResourceLocation("ad_astra", "textures/gui/sprites/energy_bar.png");
    public static final int ENERGY_BAR_WIDTH = 13;
    public static final int ENERGY_BAR_HEIGHT = 46;
    public static final ResourceLocation FLUID_BAR = new ResourceLocation("ad_astra", "textures/gui/sprites/fluid_bar.png");
    public static final int FLUID_BAR_WIDTH = 12;
    public static final int FLUID_BAR_HEIGHT = 46;
    public static final ResourceLocation BUTTON = new ResourceLocation("ad_astra", "textures/gui/sprites/button.png");
    public static final ResourceLocation SQUARE_BUTTON = new ResourceLocation("ad_astra", "textures/gui/sprites/square_button.png");
    public static final ResourceLocation SETTINGS_BUTTON = new ResourceLocation("ad_astra", "textures/gui/sprites/settings_button.png");
    public static final ResourceLocation RESET_BUTTON = new ResourceLocation("ad_astra", "textures/gui/sprites/reset_button.png");
    public static final ResourceLocation SHOW_BUTTON = new ResourceLocation("ad_astra", "textures/gui/sprites/show_button.png");
    public static final ResourceLocation HIDE_BUTTON = new ResourceLocation("ad_astra", "textures/gui/sprites/hide_button.png");
    public static final ResourceLocation CRAFTING_BUTTON = new ResourceLocation("ad_astra", "textures/gui/sprites/crafting_button.png");
    public static final ResourceLocation FURNACE_BUTTON = new ResourceLocation("ad_astra", "textures/gui/sprites/furnace_button.png");
    public static final ResourceLocation NONE_BUTTON = new ResourceLocation("ad_astra", "textures/gui/sprites/side_config/none.png");
    public static final ResourceLocation PUSH_BUTTON = new ResourceLocation("ad_astra", "textures/gui/sprites/side_config/push.png");
    public static final ResourceLocation PULL_BUTTON = new ResourceLocation("ad_astra", "textures/gui/sprites/side_config/pull.png");
    public static final ResourceLocation PUSH_PULL_BUTTON = new ResourceLocation("ad_astra", "textures/gui/sprites/side_config/push_pull.png");
    public static final ResourceLocation REDSTONE_ALWAYS_ON = new ResourceLocation("ad_astra", "textures/gui/sprites/redstone/always_on_button.png");
    public static final ResourceLocation REDSTONE_ON_WHEN_POWERED = new ResourceLocation("ad_astra", "textures/gui/sprites/redstone/on_when_powered_button.png");
    public static final ResourceLocation REDSTONE_ON_WHEN_NOT_POWERED = new ResourceLocation("ad_astra", "textures/gui/sprites/redstone/on_when_not_powered_button.png");
    public static final ResourceLocation REDSTONE_NEVER_ON = new ResourceLocation("ad_astra", "textures/gui/sprites/redstone/never_on_button.png");
    public static final ResourceLocation HAMMER = new ResourceLocation("ad_astra", "textures/gui/sprites/hammer.png");
    public static final ResourceLocation SNOWFLAKE = new ResourceLocation("ad_astra", "textures/gui/sprites/snowflake.png");
    public static final ResourceLocation SUN = new ResourceLocation("ad_astra", "textures/gui/sprites/sun.png");
    public static final ResourceLocation FIRE = new ResourceLocation("ad_astra", "textures/gui/sprites/fire.png");
    public static final ResourceLocation ARROW = new ResourceLocation("ad_astra", "textures/gui/sprites/arrow.png");
    public static final ResourceLocation SLIDER = new ResourceLocation("ad_astra", "textures/gui/sprites/slider.png");

    public static void drawEnergyBar(GuiGraphics graphics, int mouseX, int mouseY, int x, int y, long energy, long capacity, Component ... tooltips) {
        float ratio = (float)energy / (float)capacity;
        try (ClosingScissorBox ignored = RenderUtils.createScissorBox((Minecraft)Minecraft.m_91087_(), (PoseStack)graphics.m_280168_(), (int)(x + 6), (int)(y - 31 + 46 - (int)(46.0f * ratio)), (int)13, (int)46);){
            graphics.m_280163_(ENERGY_BAR, x + 6, y - 31, 0.0f, 0.0f, 13, 46, 13, 46);
        }
        GuiUtils.drawTooltips(mouseX, mouseY, x + 6, x + 19, y - 31, y + 15, list -> {
            list.add(TooltipUtils.getEnergyComponent(energy, capacity));
            Collections.addAll(list, tooltips);
            return list;
        });
    }

    public static void drawFluidBar(GuiGraphics graphics, int mouseX, int mouseY, int x, int y, FluidHolder fluid, long capacity, Component ... tooltips) {
        if (!fluid.isEmpty()) {
            float ratio = (float)fluid.getFluidAmount() / (float)capacity;
            TextureAtlasSprite sprite = ClientFluidHooks.getFluidSprite((FluidHolder)fluid);
            int color = ClientFluidHooks.getFluidColor((FluidHolder)fluid);
            float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
            float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
            float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
            try (ClosingScissorBox ignored = RenderUtils.createScissorBox((Minecraft)Minecraft.m_91087_(), (PoseStack)graphics.m_280168_(), (int)(x + 6), (int)(y - 31 + 46 - (int)(46.0f * ratio)), (int)12, (int)46);){
                for (int i = 1; i < 5; ++i) {
                    graphics.m_280565_(x + 7, y - 34 + 46 - i * 12, 0, 14, 14, sprite, r, g, b, 1.0f);
                }
            }
        }
        RenderSystem.enableBlend();
        graphics.m_280163_(FLUID_BAR, x + 6, y - 31, 0.0f, 0.0f, 12, 46, 12, 46);
        RenderSystem.disableBlend();
        GuiUtils.drawTooltips(mouseX, mouseY, x + 6, x + 18, y - 31, y + 15, list -> {
            list.add(TooltipUtils.getFluidComponent(fluid, capacity));
            Collections.addAll(list, tooltips);
            return list;
        });
    }

    public static void drawHorizontalProgressBar(GuiGraphics graphics, ResourceLocation texture, int mouseX, int mouseY, int x, int y, int width, int height, int progress, int maxProgress, boolean reverse, Component ... tooltips) {
        int widthProgress = (int)((float)width * ((float)progress / (float)maxProgress));
        if (reverse) {
            widthProgress = width - widthProgress;
        }
        graphics.m_280163_(texture, x, y, 0.0f, 0.0f, widthProgress, height, width, height);
        GuiUtils.drawTooltips(mouseX, mouseY, x, x + width, y, y + height, list -> {
            Collections.addAll(list, tooltips);
            return list;
        });
    }

    public static void drawVerticalProgressBar(GuiGraphics graphics, ResourceLocation texture, int mouseX, int mouseY, int x, int y, int width, int height, int progress, int maxProgress, Component ... tooltips) {
        int heightProgress = (int)((float)height * ((float)progress / (float)maxProgress));
        heightProgress = height - heightProgress;
        graphics.m_280163_(texture, x, y + heightProgress, 0.0f, (float)heightProgress, width, height - heightProgress, width, height);
        GuiUtils.drawTooltips(mouseX, mouseY, x, x + width, y, y + height, list -> {
            Collections.addAll(list, tooltips);
            return list;
        });
    }

    public static void drawTooltips(int mouseX, int mouseY, int minX, int maxX, int minY, int maxY, Function<List<Component>, List<Component>> tooltips) {
        if (mouseX >= minX && mouseX <= maxX && mouseY >= minY && mouseY <= maxY) {
            List<Component> lines = tooltips.apply(new ArrayList());
            lines.removeIf(c -> c.getString().isEmpty());
            ScreenUtils.setTooltip(lines);
        }
    }

    public static void drawColoredShadowCenteredString(GuiGraphics graphics, Font font, Component text, int x, int y, int color, int shadowColor) {
        FormattedCharSequence formattedCharSequence = text.m_7532_();
        graphics.m_280649_(font, formattedCharSequence, x - font.m_92724_(formattedCharSequence) / 2 - 1, y + 1, shadowColor, false);
        graphics.m_280649_(font, formattedCharSequence, x - font.m_92724_(formattedCharSequence) / 2, y, color, false);
    }

    public static void drawColoredShadowString(GuiGraphics graphics, Font font, Component text, int x, int y, int color, int shadowColor) {
        graphics.m_280614_(font, text, x - 1, y + 1, shadowColor, false);
        graphics.m_280614_(font, text, x, y, color, false);
    }
}

