/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.implementations;

import dev.uncandango.alltheleaks.exceptions.ATLUnsupportedOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ATLUnmodifiable<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = -1034234728574286014L;
    private final Map<? extends K, ? extends V> m;
    private transient Set<K> keySet;
    private transient Set<Map.Entry<K, V>> entrySet;
    private transient Collection<V> values;

    public static <K, V> Map<K, V> unmodifiableMap(Map<? extends K, ? extends V> m) {
        if (m.getClass() == ATLUnmodifiable.class) {
            return m;
        }
        return new ATLUnmodifiable<K, V>(m);
    }

    private ATLUnmodifiable(Map<? extends K, ? extends V> m) {
        if (m == null) {
            throw new NullPointerException();
        }
        this.m = m;
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m.containsKey(key);
    }

    @Override
    public boolean containsValue(Object val) {
        return this.m.containsValue(val);
    }

    @Override
    public V get(Object key) {
        return this.m.get(key);
    }

    @Override
    public V put(K key, V value) {
        throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
    }

    @Override
    public V remove(Object key) {
        throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
    }

    @Override
    public void clear() {
        throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = ATLUnmodifiable.unmodifiableSet(this.m.keySet());
        }
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new ATLUnmodifiableEntrySet<K, V>(this.m.entrySet());
        }
        return this.entrySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = ATLUnmodifiable.unmodifiableCollection(this.m.values());
        }
        return this.values;
    }

    @Override
    public boolean equals(Object o) {
        return o == this || this.m.equals(o);
    }

    @Override
    public int hashCode() {
        return this.m.hashCode();
    }

    public String toString() {
        return this.m.toString();
    }

    @Override
    public V getOrDefault(Object k, V defaultValue) {
        return this.m.getOrDefault(k, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.m.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
    }

    @Override
    public V putIfAbsent(K key, V value) {
        throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
    }

    @Override
    public V replace(K key, V value) {
        throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
    }

    public static <T> Collection<T> unmodifiableCollection(Collection<? extends T> c) {
        if (c.getClass() == ATLUnmodifiableCollection.class) {
            return c;
        }
        return new ATLUnmodifiableCollection<T>(c);
    }

    static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static <T> Set<T> unmodifiableSet(Set<? extends T> s) {
        if (s.getClass() == ATLUnmodifiableSet.class) {
            return s;
        }
        return new ATLUnmodifiableSet<T>(s);
    }

    public static <T> List<T> unmodifiableList(List<? extends T> list) {
        if (list.getClass() == ATLUnmodifiableList.class || list.getClass() == ATLUnmodifiableRandomAccessList.class) {
            return list;
        }
        return list instanceof RandomAccess ? new ATLUnmodifiableRandomAccessList<T>(list) : new ATLUnmodifiableList<T>(list);
    }

    static class ATLUnmodifiableEntrySet<K, V>
    extends ATLUnmodifiableSet<Map.Entry<K, V>> {
        private static final long serialVersionUID = 7854390611657943733L;

        ATLUnmodifiableEntrySet(Set<? extends Map.Entry<? extends K, ? extends V>> s) {
            super(s);
        }

        static <K, V> Consumer<Map.Entry<? extends K, ? extends V>> entryConsumer(Consumer<? super Map.Entry<K, V>> action) {
            return e -> action.accept(new ATLUnmodifiableEntry(e));
        }

        @Override
        public void forEach(Consumer<? super Map.Entry<K, V>> action) {
            Objects.requireNonNull(action);
            this.c.forEach(ATLUnmodifiableEntrySet.entryConsumer(action));
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            return new ATLUnmodifiableEntrySetSpliterator(this.c.spliterator());
        }

        @Override
        public Stream<Map.Entry<K, V>> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        @Override
        public Stream<Map.Entry<K, V>> parallelStream() {
            return StreamSupport.stream(this.spliterator(), true);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private final Iterator<? extends Map.Entry<? extends K, ? extends V>> i;
                {
                    this.i = c.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    return new ATLUnmodifiableEntry(this.i.next());
                }

                @Override
                public void remove() {
                    throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
                }

                @Override
                public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
                    this.i.forEachRemaining(ATLUnmodifiableEntrySet.entryConsumer(action));
                }
            };
        }

        @Override
        public Object[] toArray() {
            Object[] a = this.c.toArray();
            for (int i = 0; i < a.length; ++i) {
                a[i] = new ATLUnmodifiableEntry((Map.Entry)a[i]);
            }
            return a;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] arr = this.c.toArray(a.length == 0 ? a : Arrays.copyOf(a, 0));
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = new ATLUnmodifiableEntry((Map.Entry)arr[i]);
            }
            if (arr.length > a.length) {
                return arr;
            }
            System.arraycopy(arr, 0, a, 0, arr.length);
            if (a.length > arr.length) {
                a[arr.length] = null;
            }
            return a;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            return this.c.contains(new ATLUnmodifiableEntry((Map.Entry)o));
        }

        @Override
        public boolean containsAll(Collection<?> coll) {
            for (Object e : coll) {
                if (this.contains(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(Object o) {
            Set s;
            if (o == this) {
                return true;
            }
            return o instanceof Set && (s = (Set)o).size() == this.c.size() && this.containsAll(s);
        }

        static final class ATLUnmodifiableEntrySetSpliterator<K, V>
        implements Spliterator<Map.Entry<K, V>> {
            final Spliterator<Map.Entry<K, V>> s;

            ATLUnmodifiableEntrySetSpliterator(Spliterator<Map.Entry<K, V>> s) {
                this.s = s;
            }

            @Override
            public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> action) {
                Objects.requireNonNull(action);
                return this.s.tryAdvance(ATLUnmodifiableEntrySet.entryConsumer(action));
            }

            @Override
            public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
                Objects.requireNonNull(action);
                this.s.forEachRemaining(ATLUnmodifiableEntrySet.entryConsumer(action));
            }

            @Override
            public Spliterator<Map.Entry<K, V>> trySplit() {
                Spliterator<Map.Entry<K, V>> split = this.s.trySplit();
                return split == null ? null : new ATLUnmodifiableEntrySetSpliterator<K, V>(split);
            }

            @Override
            public long estimateSize() {
                return this.s.estimateSize();
            }

            @Override
            public long getExactSizeIfKnown() {
                return this.s.getExactSizeIfKnown();
            }

            @Override
            public int characteristics() {
                return this.s.characteristics();
            }

            @Override
            public boolean hasCharacteristics(int characteristics) {
                return this.s.hasCharacteristics(characteristics);
            }

            @Override
            public Comparator<? super Map.Entry<K, V>> getComparator() {
                return this.s.getComparator();
            }
        }

        private static class ATLUnmodifiableEntry<K, V>
        implements Map.Entry<K, V> {
            private Map.Entry<? extends K, ? extends V> e;

            ATLUnmodifiableEntry(Map.Entry<? extends K, ? extends V> e) {
                this.e = Objects.requireNonNull(e);
            }

            @Override
            public K getKey() {
                return this.e.getKey();
            }

            @Override
            public V getValue() {
                return this.e.getValue();
            }

            @Override
            public V setValue(V value) {
                throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
            }

            @Override
            public int hashCode() {
                return this.e.hashCode();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Map.Entry)) return false;
                Map.Entry t = (Map.Entry)o;
                if (!ATLUnmodifiable.eq(this.e.getKey(), t.getKey())) return false;
                if (!ATLUnmodifiable.eq(this.e.getValue(), t.getValue())) return false;
                return true;
            }

            public String toString() {
                return this.e.toString();
            }
        }
    }

    static class ATLUnmodifiableCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 1820017752578914078L;
        final Collection<? extends E> c;

        ATLUnmodifiableCollection(Collection<? extends E> c) {
            if (c == null) {
                throw new NullPointerException();
            }
            this.c = c;
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.c.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.c.toArray(a);
        }

        @Override
        public <T> T[] toArray(IntFunction<T[]> f) {
            return this.c.toArray(f);
        }

        public String toString() {
            return this.c.toString();
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private final Iterator<? extends E> i;
                {
                    this.i = c.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    return this.i.next();
                }

                @Override
                public void remove() {
                    throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    this.i.forEachRemaining(action);
                }
            };
        }

        @Override
        public boolean add(E e) {
            throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
        }

        @Override
        public boolean remove(Object o) {
            throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
        }

        @Override
        public boolean containsAll(Collection<?> coll) {
            return this.c.containsAll(coll);
        }

        @Override
        public boolean addAll(Collection<? extends E> coll) {
            throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
        }

        @Override
        public void clear() {
            throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            this.c.forEach(action);
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.c.spliterator();
        }

        @Override
        public Stream<E> stream() {
            return this.c.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.c.parallelStream();
        }
    }

    static class ATLUnmodifiableSet<E>
    extends ATLUnmodifiableCollection<E>
    implements Set<E>,
    Serializable {
        private static final long serialVersionUID = -9215047833775013803L;

        ATLUnmodifiableSet(Set<? extends E> s) {
            super(s);
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.c.equals(o);
        }

        @Override
        public int hashCode() {
            return this.c.hashCode();
        }
    }

    static class ATLUnmodifiableList<E>
    extends ATLUnmodifiableCollection<E>
    implements List<E> {
        private static final long serialVersionUID = -283967356065247728L;
        final List<? extends E> list;

        ATLUnmodifiableList(List<? extends E> list) {
            super(list);
            this.list = list;
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.list.equals(o);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public E get(int index) {
            return this.list.get(index);
        }

        @Override
        public E set(int index, E element) {
            throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
        }

        @Override
        public void add(int index, E element) {
            throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
        }

        @Override
        public E remove(int index) {
            throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
        }

        @Override
        public void sort(Comparator<? super E> c) {
            throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(final int index) {
            return new ListIterator<E>(){
                private final ListIterator<? extends E> i;
                {
                    this.i = list.listIterator(index);
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    return this.i.next();
                }

                @Override
                public boolean hasPrevious() {
                    return this.i.hasPrevious();
                }

                @Override
                public E previous() {
                    return this.i.previous();
                }

                @Override
                public int nextIndex() {
                    return this.i.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return this.i.previousIndex();
                }

                @Override
                public void remove() {
                    throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
                }

                @Override
                public void set(E e) {
                    throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
                }

                @Override
                public void add(E e) {
                    throw new ATLUnsupportedOperation("Modification of this object is not allowed!");
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    this.i.forEachRemaining(action);
                }
            };
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return new ATLUnmodifiableList<E>(this.list.subList(fromIndex, toIndex));
        }

        private Object readResolve() {
            return this.list instanceof RandomAccess ? new ATLUnmodifiableRandomAccessList<E>(this.list) : this;
        }
    }

    static class ATLUnmodifiableRandomAccessList<E>
    extends ATLUnmodifiableList<E>
    implements RandomAccess {
        private static final long serialVersionUID = -2542308836966382001L;

        ATLUnmodifiableRandomAccessList(List<? extends E> list) {
            super(list);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return new ATLUnmodifiableRandomAccessList(this.list.subList(fromIndex, toIndex));
        }

        private Object writeReplace() {
            return new ATLUnmodifiableList(this.list);
        }
    }
}

