/*
 * Decompiled with CFR 0.152.
 */
package com.nanaios.AppliedAmmoBox.item;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.features.IGridLinkableHandler;
import appeng.api.implementations.blockentities.IWirelessAccessPoint;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.util.DimensionalBlockPos;
import appeng.blockentity.networking.WirelessAccessPointBlockEntity;
import appeng.core.localization.PlayerMessages;
import appeng.core.localization.Tooltips;
import appeng.util.Platform;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.nanaios.AppliedAmmoBox.AppliedAmmoBox;
import com.nanaios.AppliedAmmoBox.item.ILinkableItem;
import com.nanaios.AppliedAmmoBox.item.InfBooster;
import com.nanaios.AppliedAmmoBox.item.LinkableHandler;
import com.nanaios.AppliedAmmoBox.item.WirelessAmmoBoxItem;
import com.tacz.guns.item.AmmoBoxItem;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.function.DoubleSupplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.Logger;

public class WirelessAmmoBoxBase
extends AmmoBoxItem
implements IAEItemPowerStorage,
ILinkableItem {
    private static final String CURRENT_POWER_NBT_KEY = "internalCurrentPower";
    public static final IGridLinkableHandler LINKABLE_HANDLER = new LinkableHandler();
    public static String TAG_ACCESS_POINT_POS = "accessPoint";
    public double currentDistanceFromGrid;
    public IGrid targetGrid;
    public IWirelessAccessPoint myWap;
    public Player player;
    private static final double MIN_POWER = 1.0E-4;
    private static final String MAX_POWER_NBT_KEY = "internalMaxPower";
    private final DoubleSupplier powerCapacity;

    public WirelessAmmoBoxBase(DoubleSupplier powerCapacity) {
        this.powerCapacity = powerCapacity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isLinked(ItemStack stack) {
        GlobalPos pos = this.getLinkedPosition(stack);
        double power = this.extractAEPower(stack, 500.0, Actionable.SIMULATE);
        return pos != null && power >= 500.0;
    }

    public GlobalPos getLinkedPosition(ItemStack item) {
        CompoundTag tag = item.m_41783_();
        if (tag != null && tag.m_128425_(TAG_ACCESS_POINT_POS, 10)) {
            return GlobalPos.f_122633_.decode((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_(TAG_ACCESS_POINT_POS)).resultOrPartial(Util.m_137489_((String)"Linked position", arg_0 -> ((Logger)AppliedAmmoBox.LOGGER).error(arg_0))).map(Pair::getFirst).orElse(null);
        }
        return null;
    }

    public Component m_7626_(ItemStack stack) {
        return Component.m_237115_((String)"item.applied_ammo_box.ammo_box");
    }

    public boolean rangeCheck() {
        this.currentDistanceFromGrid = Double.MAX_VALUE;
        if (this.targetGrid != null) {
            WirelessAccessPointBlockEntity bestWap = null;
            double bestSqDistance = Double.MAX_VALUE;
            for (WirelessAccessPointBlockEntity wap : this.targetGrid.getMachines(WirelessAccessPointBlockEntity.class)) {
                double sqDistance = this.getWapSqDistance(wap);
                if (ModList.get().isLoaded("aeinfinitybooster")) {
                    sqDistance = Math.min(sqDistance, InfBooster.infWap(wap, this.player));
                }
                if (!(sqDistance < bestSqDistance)) continue;
                bestSqDistance = sqDistance;
                bestWap = wap;
            }
            this.myWap = bestWap;
            this.currentDistanceFromGrid = Math.sqrt(bestSqDistance);
            return this.myWap != null;
        }
        return false;
    }

    protected double getWapSqDistance(WirelessAccessPointBlockEntity wap) {
        double offZ;
        double offY;
        double offX;
        double r;
        if (this.player == null) {
            return Double.MAX_VALUE;
        }
        double rangeLimit = wap.getRange();
        rangeLimit *= rangeLimit;
        DimensionalBlockPos dc = wap.getLocation();
        if (dc.getLevel() == this.player.m_9236_() && (r = (offX = (double)dc.getPos().m_123341_() - this.player.m_20185_()) * offX + (offY = (double)dc.getPos().m_123342_() - this.player.m_20186_()) * offY + (offZ = (double)dc.getPos().m_123343_() - this.player.m_20189_()) * offZ) < rangeLimit && wap.isActive()) {
            return r;
        }
        return Double.MAX_VALUE;
    }

    public IGridNode getActionableNode() {
        this.rangeCheck();
        if (this.myWap != null) {
            return this.myWap.getActionableNode();
        }
        return null;
    }

    public IGrid getGrid(ItemStack item) {
        if (this.player == null) {
            return null;
        }
        Level level = this.player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        GlobalPos linkedPos = this.getLinkedPosition(item);
        if (linkedPos == null) {
            this.player.m_5661_((Component)PlayerMessages.DeviceNotLinked.text(), true);
            return null;
        }
        ServerLevel linkedLevel = serverLevel.m_7654_().m_129880_(linkedPos.m_122640_());
        if (linkedLevel == null) {
            this.player.m_5661_((Component)PlayerMessages.LinkedNetworkNotFound.text(), true);
            return null;
        }
        BlockEntity be = Platform.getTickingBlockEntity((Level)linkedLevel, (BlockPos)linkedPos.m_122646_());
        if (!(be instanceof IWirelessAccessPoint)) {
            this.player.m_5661_((Component)PlayerMessages.LinkedNetworkNotFound.text(), true);
            return null;
        }
        IWirelessAccessPoint accessPoint = (IWirelessAccessPoint)be;
        IGrid grid = accessPoint.getGrid();
        if (grid == null) {
            this.player.m_5661_((Component)PlayerMessages.LinkedNetworkNotFound.text(), true);
            return null;
        }
        this.targetGrid = grid;
        return grid;
    }

    @Override
    public IGridLinkableHandler getLinkableHandler() {
        return WirelessAmmoBoxItem.LINKABLE_HANDLER;
    }

    public boolean m_142305_(ItemStack stack, ItemStack pOther, Slot slot, ClickAction action, Player player, SlotAccess access) {
        return false;
    }

    public boolean m_142207_(ItemStack ammoBox, Slot slot, ClickAction action, Player player) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> lines, TooltipFlag advancedTooltips) {
        CompoundTag tag = stack.m_41783_();
        double internalCurrentPower = 0.0;
        double internalMaxPower = this.getAEMaxPower(stack);
        if (tag != null) {
            internalCurrentPower = tag.m_128459_(CURRENT_POWER_NBT_KEY);
        }
        lines.add(Tooltips.energyStorageComponent((double)internalCurrentPower, (double)internalMaxPower));
    }

    public void addToMainCreativeTab(CreativeModeTab.Output output) {
        output.m_246326_((ItemLike)this);
        ItemStack charged = new ItemStack((ItemLike)this, 1);
        this.injectAEPower(charged, this.getAEMaxPower(charged), Actionable.MODULATE);
        output.m_246342_(charged);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        double filled = this.getAECurrentPower(stack) / this.getAEMaxPower(stack);
        return Mth.m_14045_((int)((int)(filled * 13.0)), (int)0, (int)13);
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)0.33333334f, (float)1.0f, (float)1.0f);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !ItemStack.m_41656_((ItemStack)oldStack, (ItemStack)newStack);
    }

    public double injectAEPower(ItemStack stack, double amount, Actionable mode) {
        double maxStorage = this.getAEMaxPower(stack);
        double currentStorage = this.getAECurrentPower(stack);
        double required = maxStorage - currentStorage;
        double overflow = Math.max(0.0, Math.min(amount - required, amount));
        if (mode == Actionable.MODULATE) {
            double toAdd = Math.min(amount, required);
            this.setAECurrentPower(stack, currentStorage + toAdd);
        }
        return overflow;
    }

    public double extractAEPower(ItemStack stack, double amount, Actionable mode) {
        double currentStorage = this.getAECurrentPower(stack);
        double fulfillable = Math.min(amount, currentStorage);
        if (mode == Actionable.MODULATE) {
            this.setAECurrentPower(stack, currentStorage - fulfillable);
        }
        return fulfillable;
    }

    public double getAEMaxPower(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(MAX_POWER_NBT_KEY, 6)) {
            return tag.m_128459_(MAX_POWER_NBT_KEY);
        }
        return this.powerCapacity.getAsDouble();
    }

    protected final void setAEMaxPower(ItemStack stack, double maxPower) {
        double defaultCapacity = this.powerCapacity.getAsDouble();
        if (Math.abs(maxPower - defaultCapacity) < 1.0E-4) {
            stack.m_41749_(MAX_POWER_NBT_KEY);
            maxPower = defaultCapacity;
        } else {
            stack.m_41784_().m_128347_(MAX_POWER_NBT_KEY, maxPower);
        }
        double currentPower = this.getAECurrentPower(stack);
        if (currentPower > maxPower) {
            this.setAECurrentPower(stack, maxPower);
        }
    }

    protected final void setAEMaxPowerMultiplier(ItemStack stack, int multiplier) {
        multiplier = Mth.m_14045_((int)multiplier, (int)1, (int)100);
        this.setAEMaxPower(stack, (double)multiplier * this.powerCapacity.getAsDouble());
    }

    protected final void resetAEMaxPower(ItemStack stack) {
        this.setAEMaxPower(stack, this.powerCapacity.getAsDouble());
    }

    public double getAECurrentPower(ItemStack is) {
        CompoundTag tag = is.m_41783_();
        if (tag != null) {
            return tag.m_128459_(CURRENT_POWER_NBT_KEY);
        }
        return 0.0;
    }

    protected final void setAECurrentPower(ItemStack stack, double power) {
        if (power < 1.0E-4) {
            stack.m_41749_(CURRENT_POWER_NBT_KEY);
        } else {
            stack.m_41784_().m_128347_(CURRENT_POWER_NBT_KEY, power);
        }
    }

    public AccessRestriction getPowerFlow(ItemStack is) {
        return AccessRestriction.WRITE;
    }

    public double getChargeRate(ItemStack stack) {
        return 800.0;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        try {
            Class<?> target = Class.forName("appeng.items.tools.powered.powersink.PoweredItemCapabilities");
            Class<?> iFaceType = Class.forName("appeng.api.implementations.items.IAEItemPowerStorage");
            Constructor<?> constructor = target.getDeclaredConstructor(ItemStack.class, iFaceType);
            constructor.setAccessible(true);
            Object instance = constructor.newInstance(stack, this);
            return (ICapabilityProvider)instance;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

