/*
 * Decompiled with CFR 0.152.
 */
package com.nanaios.AppliedAmmoBox.jei;

import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import com.nanaios.AppliedAmmoBox.AppliedAmmoBox;
import com.nanaios.AppliedAmmoBox.registries.AppliedAmmoBoxItems;
import com.tacz.guns.init.ModItems;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class AppliedAmmoBoxJeiPlugin
implements IModPlugin {
    private static final ResourceLocation ID = AppliedAmmoBox.rl("jei_plugin");
    private IJeiRuntime runtime;
    private Map<IRecipeCategory, Collection<ResourceLocation>> recipesRemoved;
    private Map<ResourceLocation, IRecipeCategory> categoryById;

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ItemStack output = new ItemStack((ItemLike)AppliedAmmoBoxItems.AMMO_BOX.get());
        NonNullList inputs = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
        ItemStack ammoBox = new ItemStack((ItemLike)ModItems.AMMO_BOX.get());
        CompoundTag tag = ammoBox.m_41784_();
        tag.m_128405_("Level", 2);
        inputs.set(0, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{AEItems.FLUIX_PEARL}));
        inputs.set(1, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{AEItems.WIRELESS_RECEIVER}));
        inputs.set(2, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{AEItems.FLUIX_PEARL}));
        inputs.set(3, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{AEBlocks.CONTROLLER}));
        inputs.set(4, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{ammoBox}));
        inputs.set(5, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{AEBlocks.DENSE_ENERGY_CELL}));
        inputs.set(6, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{AEItems.FLUIX_PEARL}));
        inputs.set(7, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{AEItems.SINGULARITY}));
        inputs.set(8, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{AEItems.FLUIX_PEARL}));
        ShapedRecipe shaped = new ShapedRecipe(AppliedAmmoBox.rl("wireless_ammo_box"), "", CraftingBookCategory.EQUIPMENT, 3, 3, inputs, output);
        registration.addRecipes(RecipeTypes.CRAFTING, List.of(shaped));
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        ResourceLocation[] recipesToRemove;
        this.runtime = jeiRuntime;
        this.recipesRemoved = new HashMap<IRecipeCategory, Collection<ResourceLocation>>();
        this.categoryById = this.runtime.getRecipeManager().createRecipeCategoryLookup().get().collect(Collectors.toMap(cat -> cat.getRecipeType().getUid(), Function.identity()));
        ResourceLocation category = AppliedAmmoBox.rl("minecraft", "crafting");
        for (ResourceLocation toRemove : recipesToRemove = new ResourceLocation[]{AppliedAmmoBox.rl("applied_ammo_box", "wireless_ammo_box")}) {
            if (!this.categoryById.containsKey(category)) continue;
            this.recipesRemoved.computeIfAbsent(this.categoryById.get(category), _0 -> new HashSet()).add(toRemove);
        }
        IRecipeManager rm = this.runtime.getRecipeManager();
        for (IRecipeCategory cat2 : this.recipesRemoved.keySet()) {
            RecipeType type = cat2.getRecipeType();
            List allRecipes = rm.createRecipeLookup(cat2.getRecipeType()).get().toList();
            Collection<ResourceLocation> ids = this.recipesRemoved.get(cat2);
            HashSet recipesHidden = new HashSet(ids.size());
            for (ResourceLocation id : ids) {
                boolean found = false;
                for (Object recipe : allRecipes) {
                    ResourceLocation recipeId = cat2.getRegistryName(recipe);
                    if (recipeId == null) {
                        AppliedAmmoBox.LOGGER.warn("Failed to remove recipe {} for type {}: Category does not support removal by id!", (Object)id, (Object)type);
                        break;
                    }
                    if (!recipeId.equals((Object)id)) continue;
                    found = true;
                    recipesHidden.add(recipe);
                    break;
                }
                if (found) continue;
                AppliedAmmoBox.LOGGER.warn("Failed to remove recipe {} for type {}: Recipe doesn't exist!", (Object)id, (Object)type);
            }
            rm.hideRecipes(type, recipesHidden);
        }
    }
}

