/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testplots;

import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEItemKey;
import appeng.blockentity.misc.InscriberBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.server.testplots.TestPlotCollection;
import appeng.server.testplots.TestPlotGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public final class InscriberTestPlots {
    private InscriberTestPlots() {
    }

    @TestPlotGenerator
    public static void generateInscriberRecipePlots(TestPlotCollection tests) {
        ItemStack namePlate = AEItems.NAME_PRESS.stack();
        namePlate.m_41700_("InscribeName", (Tag)StringTag.m_129297_((String)"HELLO WORLD"));
        ItemStack ironIngots = new ItemStack((ItemLike)Items.f_42416_, 2);
        ItemStack namedIngots = ironIngots.m_41777_();
        namedIngots.m_41714_((Component)Component.m_237113_((String)"HELLO WORLD"));
        InscriberTestPlots.addTest("nameplate", tests, namePlate, ironIngots, ItemStack.f_41583_, namePlate, ItemStack.f_41583_, ItemStack.f_41583_, namedIngots);
        InscriberTestPlots.addPrintTest(tests, AEItems.SILICON, AEItems.SILICON_PRESS, AEItems.SILICON_PRINT);
        InscriberTestPlots.addPrintTest(tests, (ItemLike)Items.f_42417_, AEItems.LOGIC_PROCESSOR_PRESS, AEItems.LOGIC_PROCESSOR_PRINT);
        InscriberTestPlots.addPrintTest(tests, (ItemLike)Items.f_42415_, AEItems.ENGINEERING_PROCESSOR_PRESS, AEItems.ENGINEERING_PROCESSOR_PRINT);
        InscriberTestPlots.addPrintTest(tests, AEItems.CERTUS_QUARTZ_CRYSTAL, AEItems.CALCULATION_PROCESSOR_PRESS, AEItems.CALCULATION_PROCESSOR_PRINT);
    }

    private static void addPrintTest(TestPlotCollection tests, ItemLike ingredient, ItemLike press, ItemLike expectedResult) {
        String suffix = AEItemKey.of(ingredient).getId().m_135815_() + "_print";
        InscriberTestPlots.addTest("inscriber_" + suffix, tests, new ItemStack(press), new ItemStack(ingredient, 2), ItemStack.f_41583_, new ItemStack(press), ItemStack.f_41583_, ItemStack.f_41583_, new ItemStack(expectedResult, 2));
    }

    private static void addTest(String suffix, TestPlotCollection tests, ItemStack topSlot, ItemStack middleSlot, ItemStack bottomSlot, ItemStack expectedTopSlot, ItemStack expectedMiddleSlot, ItemStack expectedBottomSlot, ItemStack expectedResult) {
        tests.add("inscriber_recipe_" + suffix, plot -> {
            plot.creativeEnergyCell(BlockPos.f_121853_.m_7495_());
            plot.blockEntity(BlockPos.f_121853_, AEBlocks.INSCRIBER, be -> {
                be.getUpgrades().addItems(AEItems.SPEED_CARD.stack());
                be.getUpgrades().addItems(AEItems.SPEED_CARD.stack());
                be.getUpgrades().addItems(AEItems.SPEED_CARD.stack());
                be.getUpgrades().addItems(AEItems.SPEED_CARD.stack());
                be.getUpgrades().addItems(AEItems.SPEED_CARD.stack());
                InternalInventory inv = be.getInternalInventory();
                inv.insertItem(0, topSlot.m_41777_(), false);
                inv.insertItem(1, bottomSlot.m_41777_(), false);
                inv.insertItem(2, middleSlot.m_41777_(), false);
            });
        }, plotTestHelper -> plotTestHelper.m_177425_().m_177552_(() -> {
            InscriberBlockEntity inscriber = (InscriberBlockEntity)plotTestHelper.m_177347_(BlockPos.f_121853_);
            InternalInventory inv = inscriber.getInternalInventory();
            plotTestHelper.check(ItemStack.m_150942_((ItemStack)inv.getStackInSlot(0), (ItemStack)expectedTopSlot), "Top slot is not as expected", BlockPos.f_121853_);
            plotTestHelper.check(ItemStack.m_150942_((ItemStack)inv.getStackInSlot(1), (ItemStack)expectedBottomSlot), "Bottom slot is not as expected", BlockPos.f_121853_);
            plotTestHelper.check(ItemStack.m_150942_((ItemStack)inv.getStackInSlot(2), (ItemStack)expectedMiddleSlot), "Middle slot is not as expected", BlockPos.f_121853_);
            plotTestHelper.check(ItemStack.m_150942_((ItemStack)inv.getStackInSlot(3), (ItemStack)expectedResult), "Result slot is not as expected", BlockPos.f_121853_);
        }).m_177543_());
    }
}

