/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.event;

import com.github.jarva.arsadditions.server.storage.ChunkLoadingData;
import com.github.jarva.arsadditions.setup.config.ServerConfig;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_additions")
public class ChunkLoadingEvents {
    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        UUID uuid = player.m_20148_();
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        MinecraftServer server = serverLevel.m_7654_();
        ChunkLoadingData.loadChunks(server, uuid, true);
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        UUID uuid = player.m_20148_();
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!((Boolean)ServerConfig.SERVER.chunkloading_require_online.get()).booleanValue()) {
            return;
        }
        MinecraftServer server = serverLevel.m_7654_();
        ChunkLoadingData.loadChunks(server, uuid, false);
    }
}

