/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.me.misc;

import appeng.api.config.Actionable;
import appeng.api.config.PowerUnits;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.blockentity.powersink.IExternalPowerSink;
import com.google.common.primitives.Ints;
import gripe._90.arseng.block.entity.IAdvancedSourceTile;
import gripe._90.arseng.definition.ArsEngConfig;

public record SourceEnergyAdaptor(IExternalPowerSink sink, IActionHost host) implements IAdvancedSourceTile
{
    private static final double AE_PER_SOURCE = (Double)ArsEngConfig.AE_PER_SOURCE.get();

    public int getTransferRate() {
        return this.getMaxSource();
    }

    public boolean canAcceptSource() {
        return this.getSource() < this.getMaxSource();
    }

    public int getSource() {
        return Ints.saturatedCast((long)((long)this.getMaxSource() - Math.round(this.sink.getExternalPowerDemand(PowerUnits.AE, (double)this.getMaxSource()) / AE_PER_SOURCE)));
    }

    public int getMaxSource() {
        IGridNode grid = this.host.getActionableNode();
        return grid != null ? (int)(grid.getGrid().getEnergyService().getMaxStoredPower() / AE_PER_SOURCE) : 0;
    }

    public void setMaxSource(int max) {
        throw new UnsupportedOperationException();
    }

    public int setSource(int source) {
        throw new UnsupportedOperationException();
    }

    public int addSource(int source) {
        this.sink.injectExternalPower(PowerUnits.AE, (double)source * AE_PER_SOURCE, Actionable.MODULATE);
        return Math.min(source + this.getSource(), this.getMaxSource());
    }

    public int removeSource(int source) {
        return 0;
    }

    @Override
    public boolean relayCanTakePower() {
        return false;
    }

    @Override
    public boolean sourcelinksCanProvidePower() {
        return true;
    }
}

